/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.pipeline.stages;

import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Command$EOF$;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.pipeline.stages.SSLStage$DelayedRead$;
import org.http4s.blaze.pipeline.stages.SSLStage$DelayedWrite$;
import org.http4s.blaze.pipeline.stages.SSLStage$SSLFailure$;
import org.http4s.blaze.pipeline.stages.SSLStage$SSLNeedHandshake$;
import org.http4s.blaze.pipeline.stages.SSLStage$SSLSuccess$;
import org.http4s.blaze.util.BufferTools$;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.SerialExecutionContext;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class SSLStage
implements MidStage<ByteBuffer, ByteBuffer> {
    private Logger logger;
    private Head _prevStage;
    private Tail _nextStage;
    private final SSLEngine engine;
    private final int maxWrite;
    private final SerialExecutionContext serialExec;
    private final int maxNetSize;
    private final int maxBuffer;
    private final ListBuffer<DelayedOp> handshakeQueue;
    private ByteBuffer readLeftover;

    public static int $lessinit$greater$default$2() {
        return SSLStage$.MODULE$.$lessinit$greater$default$2();
    }

    public SSLStage(SSLEngine engine, int maxWrite) {
        this.engine = engine;
        this.maxWrite = maxWrite;
        Stage.$init$(this);
        Tail.$init$(this);
        Head.$init$(this);
        this.serialExec = new SerialExecutionContext(this){
            private final /* synthetic */ SSLStage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(Execution$.MODULE$.directec());
            }

            public void reportFailure(Throwable cause) {
                Logger Logger_this = this.$outer.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Failure during SSL operation. Aborting pipeline.", cause);
                }
                this.$outer.closePipeline((Option)Some$.MODULE$.apply((Object)cause));
                this.$outer.org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure(cause);
            }
        };
        this.maxNetSize = engine.getSession().getPacketBufferSize();
        this.maxBuffer = package$.MODULE$.max(this.maxNetSize, engine.getSession().getApplicationBufferSize());
        this.handshakeQueue = new ListBuffer();
        this.readLeftover = null;
        Statics.releaseFence();
    }

    @Override
    public final Logger logger() {
        return this.logger;
    }

    @Override
    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    @Override
    public Head _prevStage() {
        return this._prevStage;
    }

    @Override
    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    @Override
    public Tail _nextStage() {
        return this._nextStage;
    }

    @Override
    public void _nextStage_$eq(Tail x$1) {
        this._nextStage = x$1;
    }

    @Override
    public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
        Stage.inboundCommand$(this, cmd);
    }

    @Override
    public String name() {
        return "SSLStage";
    }

    @Override
    public void stageShutdown() {
        block2: {
            try {
                this.engine.closeInbound();
                this.engine.closeOutbound();
            }
            catch (SSLException e) {
                Logger Logger_this = this.logger();
                if (!Logger_this.isDebugEnabled()) break block2;
                Logger_this.debug("Error while closing SSL Engine", (Throwable)e);
            }
        }
    }

    @Override
    public Future<BoxedUnit> writeRequest(Seq<ByteBuffer> data) {
        return this.writeArray((ByteBuffer[])data.toArray(ClassTag$.MODULE$.apply(ByteBuffer.class)));
    }

    @Override
    public Future<BoxedUnit> writeRequest(ByteBuffer data) {
        return this.writeArray(new ByteBuffer[]{data});
    }

    @Override
    public Future<ByteBuffer> readRequest(int size) {
        Promise p = Promise$.MODULE$.apply();
        this.serialExec.execute(new Runnable(size, p, this){
            private final int size$1;
            private final Promise p$1;
            private final /* synthetic */ SSLStage $outer;
            {
                this.size$1 = size$3;
                this.p$1 = p$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.org$http4s$blaze$pipeline$stages$SSLStage$$doRead(this.size$1, (Promise<ByteBuffer>)this.p$1);
            }
        });
        return p.future();
    }

    private Future<BoxedUnit> writeArray(ByteBuffer[] data) {
        Promise p = Promise$.MODULE$.apply();
        this.serialExec.execute(new Runnable(data, p, this){
            private final ByteBuffer[] data$1;
            private final Promise p$2;
            private final /* synthetic */ SSLStage $outer;
            {
                this.data$1 = data$5;
                this.p$2 = p$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.org$http4s$blaze$pipeline$stages$SSLStage$$doWrite(this.data$1, (Promise<BoxedUnit>)this.p$2);
            }
        });
        return p.future();
    }

    private boolean inHandshake() {
        return this.handshakeQueue.nonEmpty();
    }

    private ByteBuffer takeQueuedBytes() {
        if (this.readLeftover != null) {
            ByteBuffer b = this.readLeftover;
            this.readLeftover = null;
            return b;
        }
        return BufferTools$.MODULE$.emptyBuffer();
    }

    public void org$http4s$blaze$pipeline$stages$SSLStage$$doRead(int size, Promise<ByteBuffer> p) {
        Growable growable;
        long start = System.nanoTime();
        if (this.inHandshake()) {
            growable = this.handshakeQueue.$plus$eq((Object)SSLStage$DelayedRead$.MODULE$.apply(size, p));
        } else {
            SSLResult sSLResult;
            ArrayBuffer out = new ArrayBuffer();
            ByteBuffer b = this.takeQueuedBytes();
            SSLResult r = this.readLoop(b, (Buffer<ByteBuffer>)out);
            if (b.hasRemaining()) {
                this.readLeftover = b;
            }
            if (SSLStage$SSLSuccess$.MODULE$.equals(sSLResult = r)) {
                if (out.nonEmpty()) {
                    p.success((Object)BufferTools$.MODULE$.joinBuffers((Seq<ByteBuffer>)out));
                } else {
                    this.channelRead(size > 0 ? package$.MODULE$.max(size, this.maxNetSize) : size, this.channelRead$default$2()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Try try_ = x$1;
                        if (try_ instanceof Success) {
                            ByteBuffer buff = (ByteBuffer)((Success)try_).value();
                            this.readLeftover = BufferTools$.MODULE$.concatBuffers(this.readLeftover, buff);
                            this.org$http4s$blaze$pipeline$stages$SSLStage$$doRead(size, p);
                            return;
                        }
                        if (try_ instanceof Failure) {
                            Throwable t = ((Failure)try_).exception();
                            p.failure(t);
                            return;
                        }
                        throw new MatchError((Object)try_);
                    }, (ExecutionContext)this.serialExec);
                }
            } else if (sSLResult instanceof SSLNeedHandshake) {
                SSLEngineResult.HandshakeStatus handshakeStatus;
                SSLNeedHandshake sSLNeedHandshake = SSLStage$SSLNeedHandshake$.MODULE$.unapply((SSLNeedHandshake)sSLResult);
                SSLEngineResult.HandshakeStatus r2 = handshakeStatus = sSLNeedHandshake._1();
                this.handshakeQueue.$plus$eq((Object)SSLStage$DelayedRead$.MODULE$.apply(size, p));
                ByteBuffer data = this.takeQueuedBytes();
                this.sslHandshake(data, r2);
            } else if (sSLResult instanceof SSLFailure) {
                Throwable throwable;
                SSLFailure sSLFailure = SSLStage$SSLFailure$.MODULE$.unapply((SSLFailure)sSLResult);
                Throwable t = throwable = sSLFailure._1();
                p.failure(t);
            } else {
                throw new MatchError((Object)sSLResult);
            }
            growable = BoxedUnit.UNIT;
        }
        Logger Logger_this = this.logger();
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(24).append(Statics.anyHash((Object)this.engine)).append(": doRead completed in ").append(System.nanoTime() - start).append("ns").toString());
            return;
        }
    }

    public void org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure(Throwable t) {
        long start = System.nanoTime();
        List results = this.handshakeQueue.result();
        this.handshakeQueue.clear();
        if (results.isEmpty()) {
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("Handshake failure with no pending results", t);
            }
        } else {
            results.foreach((Function1 & Serializable)x$1 -> {
                DelayedOp delayedOp = x$1;
                if (delayedOp instanceof DelayedRead) {
                    Promise<ByteBuffer> promise;
                    DelayedRead delayedRead = SSLStage$DelayedRead$.MODULE$.unapply((DelayedRead)delayedOp);
                    int n = delayedRead._1();
                    Promise<ByteBuffer> p = promise = delayedRead._2();
                    return p.failure(t);
                }
                if (delayedOp instanceof DelayedWrite) {
                    Promise<BoxedUnit> promise;
                    DelayedWrite delayedWrite = SSLStage$DelayedWrite$.MODULE$.unapply((DelayedWrite)delayedOp);
                    ByteBuffer[] byteBufferArray = delayedWrite._1();
                    Promise<BoxedUnit> p = promise = delayedWrite._2();
                    return p.failure(t);
                }
                throw new MatchError((Object)delayedOp);
            });
        }
        Logger Logger_this = this.logger();
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(34).append(Statics.anyHash((Object)this.engine)).append(": handshakeFailure completed in ").append(System.nanoTime() - start).append("ns").toString());
            return;
        }
    }

    private void sslHandshake(ByteBuffer data, SSLEngineResult.HandshakeStatus r) {
        long start = System.nanoTime();
        try {
            this.sslHandshakeLoop$1(data, r);
        }
        catch (SSLException t) {
            Logger Logger_this = this.logger();
            if (Logger_this.isWarnEnabled()) {
                Logger_this.warn("SSLException in SSL handshake", (Throwable)t);
            }
            this.org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure(t);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Error in SSL handshake", t);
                }
                this.org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure(t);
            }
            throw throwable;
        }
        Logger Logger_this = this.logger();
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(30).append(Statics.anyHash((Object)this.engine)).append(": sslHandshake completed in ").append(System.nanoTime() - start).append("ns").toString());
            return;
        }
    }

    private SSLResult readLoop(ByteBuffer b, Buffer<ByteBuffer> out) {
        SSLResult sSLResult;
        ByteBuffer scratch = SSLStage$.MODULE$.org$http4s$blaze$pipeline$stages$SSLStage$$$getScratchBuffer(this.maxBuffer);
        try {
            sSLResult = this.goRead$1(b, scratch, out);
        }
        catch (SSLException t) {
            Logger Logger_this = this.logger();
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("SSLException during read loop", (Throwable)t);
            }
            sSLResult = SSLStage$SSLFailure$.MODULE$.apply(t);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Logger Logger_this = this.logger();
                if (Logger_this.isTraceEnabled()) {
                    Logger_this.trace("Error in SSL read loop", t);
                }
                sSLResult = SSLStage$SSLFailure$.MODULE$.apply(t);
            }
            throw throwable;
        }
        return sSLResult;
    }

    public void org$http4s$blaze$pipeline$stages$SSLStage$$doWrite(ByteBuffer[] data, Promise<BoxedUnit> p) {
        long start = System.nanoTime();
        if (this.inHandshake()) {
            this.handshakeQueue.$plus$eq((Object)SSLStage$DelayedWrite$.MODULE$.apply(data, p));
        } else {
            ArrayBuffer out = new ArrayBuffer();
            SSLResult sSLResult = this.writeLoop(data, (Buffer<ByteBuffer>)out);
            if (SSLStage$SSLSuccess$.MODULE$.equals(sSLResult)) {
                if (BufferTools$.MODULE$.checkEmpty(data)) {
                    p.completeWith(this.channelWrite((Seq)out.toSeq()));
                } else {
                    this.channelWrite((Seq)out.toSeq()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Try try_ = x$1;
                        if (try_ instanceof Success) {
                            this.org$http4s$blaze$pipeline$stages$SSLStage$$doWrite(data, p);
                            return;
                        }
                        if (try_ instanceof Failure) {
                            Throwable t = ((Failure)try_).exception();
                            p.failure(t);
                            return;
                        }
                        throw new MatchError((Object)try_);
                    }, (ExecutionContext)this.serialExec);
                }
            } else if (sSLResult instanceof SSLNeedHandshake) {
                SSLEngineResult.HandshakeStatus handshakeStatus;
                SSLNeedHandshake sSLNeedHandshake = SSLStage$SSLNeedHandshake$.MODULE$.unapply((SSLNeedHandshake)sSLResult);
                SSLEngineResult.HandshakeStatus r = handshakeStatus = sSLNeedHandshake._1();
                this.handshakeQueue.$plus$eq((Object)SSLStage$DelayedWrite$.MODULE$.apply(data, p));
                ByteBuffer readData = this.takeQueuedBytes();
                if (out.nonEmpty()) {
                    this.channelWrite((Seq)out.toSeq()).onComplete((Function1 & Serializable)x$1 -> {
                        Try try_ = x$1;
                        if (try_ instanceof Success) {
                            this.sslHandshake(readData, r);
                            return BoxedUnit.UNIT;
                        }
                        if (try_ instanceof Failure) {
                            Throwable t = ((Failure)try_).exception();
                            return p.failure(t);
                        }
                        throw new MatchError((Object)try_);
                    }, (ExecutionContext)this.serialExec);
                } else {
                    this.sslHandshake(readData, r);
                }
            } else if (sSLResult instanceof SSLFailure) {
                Throwable throwable;
                SSLFailure sSLFailure = SSLStage$SSLFailure$.MODULE$.unapply((SSLFailure)sSLResult);
                Throwable t = throwable = sSLFailure._1();
                p.failure(t);
            } else {
                throw new MatchError((Object)sSLResult);
            }
        }
        Logger Logger_this = this.logger();
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(31).append(Statics.anyHash((Object)this.engine)).append(": continueWrite completed in ").append(System.nanoTime() - start).append("ns").toString());
            return;
        }
    }

    private SSLResult writeLoop(ByteBuffer[] buffers, Buffer<ByteBuffer> out) {
        SSLResult sSLResult;
        ByteBuffer o = SSLStage$.MODULE$.org$http4s$blaze$pipeline$stages$SSLStage$$$getScratchBuffer(this.maxBuffer);
        try {
            SSLResult r = this.goWrite$1(o, buffers, out, 0);
            BufferTools$.MODULE$.dropEmpty(buffers);
            sSLResult = r;
        }
        catch (SSLException t) {
            Logger Logger_this = this.logger();
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("SSLException during writeLoop", (Throwable)t);
            }
            sSLResult = SSLStage$SSLFailure$.MODULE$.apply(t);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Logger Logger_this = this.logger();
                if (Logger_this.isTraceEnabled()) {
                    Logger_this.trace("Error in SSL writeLoop", t);
                }
                sSLResult = SSLStage$SSLFailure$.MODULE$.apply(t);
            }
            throw throwable;
        }
        return sSLResult;
    }

    private void runTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
    }

    private final void sslHandshakeLoop$1(ByteBuffer data, SSLEngineResult.HandshakeStatus r) {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        block24: {
            block21: {
                SSLEngineResult.HandshakeStatus handshakeStatus2;
                SSLEngineResult.HandshakeStatus handshakeStatus3;
                block23: {
                    block22: {
                        SSLEngineResult.HandshakeStatus handshakeStatus4;
                        SSLEngineResult.HandshakeStatus handshakeStatus5;
                        block20: {
                            block17: {
                                block19: {
                                    SSLEngineResult r2;
                                    ByteBuffer o;
                                    block18: {
                                        while (true) {
                                            handshakeStatus = r;
                                            SSLEngineResult.HandshakeStatus handshakeStatus6 = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                                            SSLEngineResult.HandshakeStatus handshakeStatus7 = handshakeStatus;
                                            if (!(handshakeStatus6 != null ? !((Object)((Object)handshakeStatus6)).equals((Object)handshakeStatus7) : handshakeStatus7 != null)) {
                                                ByteBuffer o2 = SSLStage$.MODULE$.org$http4s$blaze$pipeline$stages$SSLStage$$$getScratchBuffer(this.maxBuffer);
                                                SSLEngineResult r3 = this.engine.unwrap(data, o2);
                                                SSLEngineResult.Status status = r3.getStatus();
                                                SSLEngineResult.Status status2 = SSLEngineResult.Status.OK;
                                                SSLEngineResult.Status status3 = status;
                                                if (!(status2 != null ? !((Object)((Object)status2)).equals((Object)status3) : status3 != null)) {
                                                    r = r3.getHandshakeStatus();
                                                    continue;
                                                }
                                                SSLEngineResult.Status status4 = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                                                SSLEngineResult.Status status5 = status;
                                                if (!(status4 != null ? !((Object)((Object)status4)).equals((Object)status5) : status5 != null)) {
                                                    this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                                                        Try try_ = x$1;
                                                        if (try_ instanceof Success) {
                                                            ByteBuffer b = (ByteBuffer)((Success)try_).value();
                                                            this.sslHandshake(BufferTools$.MODULE$.concatBuffers(data, b), r3.getHandshakeStatus());
                                                            return;
                                                        }
                                                        if (try_ instanceof Failure) {
                                                            Throwable t = ((Failure)try_).exception();
                                                            this.org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure(t);
                                                            return;
                                                        }
                                                        throw new MatchError((Object)try_);
                                                    }, (ExecutionContext)this.serialExec);
                                                    return;
                                                }
                                                SSLEngineResult.Status status6 = SSLEngineResult.Status.CLOSED;
                                                SSLEngineResult.Status status7 = status;
                                                if (!(status6 != null ? !((Object)((Object)status6)).equals((Object)status7) : status7 != null)) {
                                                    this.org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure(new SSLException("SSL Closed"));
                                                    return;
                                                }
                                                SSLEngineResult.Status status8 = SSLEngineResult.Status.BUFFER_OVERFLOW;
                                                SSLEngineResult.Status status9 = status;
                                                if (!(status8 != null ? !((Object)((Object)status8)).equals((Object)status9) : status9 != null)) {
                                                    this.org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure((Throwable)((Object)org.http4s.blaze.util.package$.MODULE$.bug(new StringBuilder(19).append("Unexpected status: ").append((Object)SSLEngineResult.Status.BUFFER_OVERFLOW).toString())));
                                                    return;
                                                }
                                                throw new MatchError((Object)status);
                                            }
                                            SSLEngineResult.HandshakeStatus handshakeStatus8 = SSLEngineResult.HandshakeStatus.NEED_TASK;
                                            SSLEngineResult.HandshakeStatus handshakeStatus9 = handshakeStatus;
                                            if (handshakeStatus8 != null ? !((Object)((Object)handshakeStatus8)).equals((Object)handshakeStatus9) : handshakeStatus9 != null) break;
                                            this.runTasks();
                                            r = this.engine.getHandshakeStatus();
                                        }
                                        SSLEngineResult.HandshakeStatus handshakeStatus10 = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                                        SSLEngineResult.HandshakeStatus handshakeStatus11 = handshakeStatus;
                                        if (handshakeStatus10 != null ? !((Object)((Object)handshakeStatus10)).equals((Object)handshakeStatus11) : handshakeStatus11 != null) break block17;
                                        o = SSLStage$.MODULE$.org$http4s$blaze$pipeline$stages$SSLStage$$$getScratchBuffer(this.maxBuffer);
                                        r2 = this.engine.wrap(BufferTools$.MODULE$.emptyBuffer(), o);
                                        Logger Logger_this = this.logger();
                                        if (Logger_this.isTraceEnabled()) {
                                            Logger_this.trace(new StringBuilder(33).append("SSL Handshake Status after wrap: ").append(r2).toString());
                                        }
                                        o.flip();
                                        if (r2.bytesProduced() < 1) {
                                            SSLEngineResult.HandshakeStatus handshakeStatus12 = r2.getHandshakeStatus();
                                            SSLEngineResult.HandshakeStatus handshakeStatus13 = SSLEngineResult.HandshakeStatus.FINISHED;
                                            if (handshakeStatus12 == null ? handshakeStatus13 != null : !((Object)((Object)handshakeStatus12)).equals((Object)handshakeStatus13)) {
                                                this.org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure(new SSLException(new StringBuilder(37).append("SSL Handshake WRAP produced 0 bytes: ").append(r2).toString()));
                                            }
                                        }
                                        if (r2.bytesProduced() > 0) break block18;
                                        SSLEngineResult.HandshakeStatus handshakeStatus14 = r2.getHandshakeStatus();
                                        SSLEngineResult.HandshakeStatus handshakeStatus15 = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                                        if (!(handshakeStatus14 == null ? handshakeStatus15 != null : !((Object)((Object)handshakeStatus14)).equals((Object)handshakeStatus15))) break block19;
                                    }
                                    this.channelWrite(BufferTools$.MODULE$.copyBuffer(o)).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                                        Try try_ = x$1;
                                        if (try_ instanceof Success) {
                                            this.sslHandshake(data, r2.getHandshakeStatus());
                                            return;
                                        }
                                        if (try_ instanceof Failure) {
                                            Throwable t = ((Failure)try_).exception();
                                            this.org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure(t);
                                            return;
                                        }
                                        throw new MatchError((Object)try_);
                                    }, (ExecutionContext)this.serialExec);
                                    return;
                                }
                                return;
                            }
                            handshakeStatus5 = SSLEngineResult.HandshakeStatus.FINISHED;
                            handshakeStatus4 = handshakeStatus;
                            if (handshakeStatus5 != null) break block20;
                            if (handshakeStatus4 == null) break block21;
                            break block22;
                        }
                        if (((Object)((Object)handshakeStatus5)).equals((Object)handshakeStatus4)) break block21;
                    }
                    handshakeStatus3 = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                    handshakeStatus2 = handshakeStatus;
                    if (handshakeStatus3 != null) break block23;
                    if (handshakeStatus2 == null) break block21;
                    break block24;
                }
                if (!((Object)((Object)handshakeStatus3)).equals((Object)handshakeStatus2)) break block24;
            }
            if (this.readLeftover != null) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            this.readLeftover = data;
            List pendingOps = this.handshakeQueue.result();
            this.handshakeQueue.clear();
            Logger Logger_this = this.logger();
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace(new StringBuilder(26).append("Submitting backed up ops: ").append(pendingOps).toString());
            }
            pendingOps.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                DelayedOp delayedOp = x$1;
                if (delayedOp instanceof DelayedRead) {
                    DelayedRead delayedRead = SSLStage$DelayedRead$.MODULE$.unapply((DelayedRead)delayedOp);
                    int n = delayedRead._1();
                    Promise<ByteBuffer> promise = delayedRead._2();
                    int sz = n;
                    Promise<ByteBuffer> p = promise;
                    this.org$http4s$blaze$pipeline$stages$SSLStage$$doRead(sz, p);
                    return;
                }
                if (delayedOp instanceof DelayedWrite) {
                    DelayedWrite delayedWrite = SSLStage$DelayedWrite$.MODULE$.unapply((DelayedWrite)delayedOp);
                    ByteBuffer[] byteBufferArray = delayedWrite._1();
                    Promise<BoxedUnit> promise = delayedWrite._2();
                    ByteBuffer[] d = byteBufferArray;
                    Promise<BoxedUnit> p = promise;
                    this.org$http4s$blaze$pipeline$stages$SSLStage$$doWrite(d, p);
                    return;
                }
                throw new MatchError((Object)delayedOp);
            });
            return;
        }
        SSLEngineResult.HandshakeStatus unexpected = handshakeStatus;
        this.org$http4s$blaze$pipeline$stages$SSLStage$$handshakeFailure((Throwable)((Object)org.http4s.blaze.util.package$.MODULE$.bug(new StringBuilder(16).append("Unknown status: ").append((Object)unexpected).toString())));
    }

    private final SSLResult goRead$1(ByteBuffer b$1, ByteBuffer scratch$1, Buffer out$1) {
        SSLEngineResult r;
        block7: {
            SSLEngineResult.Status status;
            while (true) {
                r = this.engine.unwrap(b$1, scratch$1);
                Logger Logger_this = this.logger();
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug(new StringBuilder(27).append("SSL Read Request Status: ").append(r).append(", ").append(scratch$1).toString());
                }
                if (r.bytesProduced() > 0) {
                    scratch$1.flip();
                    out$1.$plus$eq((Object)BufferTools$.MODULE$.copyBuffer(scratch$1));
                    scratch$1.clear();
                }
                SSLEngineResult.HandshakeStatus handshakeStatus = r.getHandshakeStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus2 = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                SSLEngineResult.HandshakeStatus handshakeStatus3 = handshakeStatus;
                if (handshakeStatus2 != null ? !((Object)((Object)handshakeStatus2)).equals((Object)handshakeStatus3) : handshakeStatus3 != null) break block7;
                status = r.getStatus();
                SSLEngineResult.Status status2 = SSLEngineResult.Status.OK;
                SSLEngineResult.Status status3 = status;
                if (status2 == null) {
                    if (status3 == null) continue;
                    break;
                }
                if (!((Object)((Object)status2)).equals((Object)status3)) break;
            }
            SSLEngineResult.Status status4 = SSLEngineResult.Status.BUFFER_UNDERFLOW;
            SSLEngineResult.Status status5 = status;
            if (!(status4 != null ? !((Object)((Object)status4)).equals((Object)status5) : status5 != null)) {
                return SSLStage$SSLSuccess$.MODULE$;
            }
            SSLEngineResult.Status status6 = SSLEngineResult.Status.CLOSED;
            SSLEngineResult.Status status7 = status;
            if (!(status6 != null ? !((Object)((Object)status6)).equals((Object)status7) : status7 != null)) {
                return (SSLResult)(out$1.nonEmpty() ? SSLStage$SSLSuccess$.MODULE$ : SSLStage$SSLFailure$.MODULE$.apply(Command$EOF$.MODULE$));
            }
            SSLEngineResult.Status status8 = SSLEngineResult.Status.BUFFER_OVERFLOW;
            SSLEngineResult.Status status9 = status;
            if (!(status8 != null ? !((Object)((Object)status8)).equals((Object)status9) : status9 != null)) {
                return SSLStage$SSLFailure$.MODULE$.apply(new Exception("Shouldn't get here: Buffer overflow in readLoop"));
            }
            throw new MatchError((Object)status);
        }
        return (SSLResult)(out$1.nonEmpty() ? SSLStage$SSLSuccess$.MODULE$ : SSLStage$SSLNeedHandshake$.MODULE$.apply(r.getHandshakeStatus()));
    }

    private final SSLResult goWrite$1(ByteBuffer o$1, ByteBuffer[] buffers$1, Buffer out$2, int b) {
        SSLEngineResult r;
        block4: {
            SSLEngineResult.Status status;
            while (true) {
                o$1.clear();
                r = this.engine.wrap(buffers$1, o$1);
                if (o$1.position() > 0) {
                    o$1.flip();
                    out$2.$plus$eq((Object)BufferTools$.MODULE$.copyBuffer(o$1));
                }
                SSLEngineResult.HandshakeStatus handshakeStatus = r.getHandshakeStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus2 = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                SSLEngineResult.HandshakeStatus handshakeStatus3 = handshakeStatus;
                if (handshakeStatus2 != null ? !((Object)((Object)handshakeStatus2)).equals((Object)handshakeStatus3) : handshakeStatus3 != null) break block4;
                int buffered = b + r.bytesProduced();
                status = r.getStatus();
                SSLEngineResult.Status status2 = SSLEngineResult.Status.OK;
                SSLEngineResult.Status status3 = status;
                if (status2 != null ? !((Object)((Object)status2)).equals((Object)status3) : status3 != null) break;
                if (BufferTools$.MODULE$.checkEmpty(buffers$1) || this.maxWrite > 0 && buffered > this.maxWrite) {
                    return SSLStage$SSLSuccess$.MODULE$;
                }
                b = buffered;
            }
            SSLEngineResult.Status status4 = SSLEngineResult.Status.CLOSED;
            SSLEngineResult.Status status5 = status;
            if (!(status4 != null ? !((Object)((Object)status4)).equals((Object)status5) : status5 != null)) {
                return SSLStage$SSLFailure$.MODULE$.apply(Command$EOF$.MODULE$);
            }
            SSLEngineResult.Status s2 = status;
            return SSLStage$SSLFailure$.MODULE$.apply(new Exception(new StringBuilder(33).append("Invalid status in SSL writeLoop: ").append((Object)s2).toString()));
        }
        return SSLStage$SSLNeedHandshake$.MODULE$.apply(r.getHandshakeStatus());
    }

    public static interface DelayedOp {
    }

    public static class DelayedRead
    implements DelayedOp,
    Product,
    Serializable {
        private final int size;
        private final Promise p;

        public static DelayedRead apply(int n, Promise<ByteBuffer> promise) {
            return SSLStage$DelayedRead$.MODULE$.apply(n, promise);
        }

        public static DelayedRead fromProduct(Product product) {
            return SSLStage$DelayedRead$.MODULE$.fromProduct(product);
        }

        public static DelayedRead unapply(DelayedRead delayedRead) {
            return SSLStage$DelayedRead$.MODULE$.unapply(delayedRead);
        }

        public DelayedRead(int size, Promise<ByteBuffer> p) {
            this.size = size;
            this.p = p;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.size());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.p()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DelayedRead)) return false;
            DelayedRead delayedRead = (DelayedRead)object;
            if (this.size() != delayedRead.size()) return false;
            Promise<ByteBuffer> promise = this.p();
            Promise<ByteBuffer> promise2 = delayedRead.p();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!delayedRead.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DelayedRead;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DelayedRead";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "size";
            }
            if (1 == n2) {
                return "p";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int size() {
            return this.size;
        }

        public Promise<ByteBuffer> p() {
            return this.p;
        }

        public DelayedRead copy(int size, Promise<ByteBuffer> p) {
            return new DelayedRead(size, p);
        }

        public int copy$default$1() {
            return this.size();
        }

        public Promise<ByteBuffer> copy$default$2() {
            return this.p();
        }

        public int _1() {
            return this.size();
        }

        public Promise<ByteBuffer> _2() {
            return this.p();
        }
    }

    public static class DelayedWrite
    implements DelayedOp,
    Product,
    Serializable {
        private final ByteBuffer[] data;
        private final Promise p;

        public static DelayedWrite apply(ByteBuffer[] byteBufferArray, Promise<BoxedUnit> promise) {
            return SSLStage$DelayedWrite$.MODULE$.apply(byteBufferArray, promise);
        }

        public static DelayedWrite fromProduct(Product product) {
            return SSLStage$DelayedWrite$.MODULE$.fromProduct(product);
        }

        public static DelayedWrite unapply(DelayedWrite delayedWrite) {
            return SSLStage$DelayedWrite$.MODULE$.unapply(delayedWrite);
        }

        public DelayedWrite(ByteBuffer[] data, Promise<BoxedUnit> p) {
            this.data = data;
            this.p = p;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DelayedWrite)) return false;
            DelayedWrite delayedWrite = (DelayedWrite)object;
            if (this.data() != delayedWrite.data()) return false;
            Promise<BoxedUnit> promise = this.p();
            Promise<BoxedUnit> promise2 = delayedWrite.p();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!delayedWrite.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DelayedWrite;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DelayedWrite";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            if (1 == n2) {
                return "p";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteBuffer[] data() {
            return this.data;
        }

        public Promise<BoxedUnit> p() {
            return this.p;
        }

        public DelayedWrite copy(ByteBuffer[] data, Promise<BoxedUnit> p) {
            return new DelayedWrite(data, p);
        }

        public ByteBuffer[] copy$default$1() {
            return this.data();
        }

        public Promise<BoxedUnit> copy$default$2() {
            return this.p();
        }

        public ByteBuffer[] _1() {
            return this.data();
        }

        public Promise<BoxedUnit> _2() {
            return this.p();
        }
    }

    public static class SSLFailure
    implements SSLResult,
    Product,
    Serializable {
        private final Throwable t;

        public static SSLFailure apply(Throwable throwable) {
            return SSLStage$SSLFailure$.MODULE$.apply(throwable);
        }

        public static SSLFailure fromProduct(Product product) {
            return SSLStage$SSLFailure$.MODULE$.fromProduct(product);
        }

        public static SSLFailure unapply(SSLFailure sSLFailure) {
            return SSLStage$SSLFailure$.MODULE$.unapply(sSLFailure);
        }

        public SSLFailure(Throwable t) {
            this.t = t;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SSLFailure)) return false;
            SSLFailure sSLFailure = (SSLFailure)object;
            Throwable throwable = this.t();
            Throwable throwable2 = sSLFailure.t();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!sSLFailure.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SSLFailure;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SSLFailure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "t";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Throwable t() {
            return this.t;
        }

        public SSLFailure copy(Throwable t) {
            return new SSLFailure(t);
        }

        public Throwable copy$default$1() {
            return this.t();
        }

        public Throwable _1() {
            return this.t();
        }
    }

    public static class SSLNeedHandshake
    implements SSLResult,
    Product,
    Serializable {
        private final SSLEngineResult.HandshakeStatus r;

        public static SSLNeedHandshake apply(SSLEngineResult.HandshakeStatus handshakeStatus) {
            return SSLStage$SSLNeedHandshake$.MODULE$.apply(handshakeStatus);
        }

        public static SSLNeedHandshake fromProduct(Product product) {
            return SSLStage$SSLNeedHandshake$.MODULE$.fromProduct(product);
        }

        public static SSLNeedHandshake unapply(SSLNeedHandshake sSLNeedHandshake) {
            return SSLStage$SSLNeedHandshake$.MODULE$.unapply(sSLNeedHandshake);
        }

        public SSLNeedHandshake(SSLEngineResult.HandshakeStatus r) {
            this.r = r;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SSLNeedHandshake)) return false;
            SSLNeedHandshake sSLNeedHandshake = (SSLNeedHandshake)object;
            SSLEngineResult.HandshakeStatus handshakeStatus = this.r();
            SSLEngineResult.HandshakeStatus handshakeStatus2 = sSLNeedHandshake.r();
            if (handshakeStatus == null) {
                if (handshakeStatus2 != null) {
                    return false;
                }
            } else if (!((Object)((Object)handshakeStatus)).equals((Object)handshakeStatus2)) return false;
            if (!sSLNeedHandshake.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SSLNeedHandshake;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SSLNeedHandshake";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "r";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SSLEngineResult.HandshakeStatus r() {
            return this.r;
        }

        public SSLNeedHandshake copy(SSLEngineResult.HandshakeStatus r) {
            return new SSLNeedHandshake(r);
        }

        public SSLEngineResult.HandshakeStatus copy$default$1() {
            return this.r();
        }

        public SSLEngineResult.HandshakeStatus _1() {
            return this.r();
        }
    }

    public static interface SSLResult {
    }
}

