/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.pipeline.stages.monitors;

import java.io.Serializable;
import org.http4s.blaze.pipeline.stages.monitors.ConnectionMonitor;
import org.http4s.blaze.pipeline.stages.monitors.IntervalConnectionMonitor$Stats$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class IntervalConnectionMonitor
extends ConnectionMonitor {
    private final Duration interval;
    public final double org$http4s$blaze$pipeline$stages$monitors$IntervalConnectionMonitor$$alpha;
    private final MeanTracker inbound;
    private final MeanTracker outbound;
    private final ConnTracker conns;
    public final IntervalConnectionMonitor$Stats$ Stats$lzy1;

    public IntervalConnectionMonitor(Duration interval) {
        this.interval = interval;
        this.Stats$lzy1 = new IntervalConnectionMonitor$Stats$(this);
        Predef$.MODULE$.require(interval.isFinite() && interval.toNanos() > 1L, IntervalConnectionMonitor::$init$$$anonfun$1);
        this.org$http4s$blaze$pipeline$stages$monitors$IntervalConnectionMonitor$$alpha = 1.0 / (double)(interval.toNanos() + 1L);
        this.inbound = new MeanTracker();
        this.outbound = new MeanTracker();
        this.conns = new ConnTracker();
    }

    public Duration interval() {
        return this.interval;
    }

    public final IntervalConnectionMonitor$Stats$ Stats() {
        return this.Stats$lzy1;
    }

    public Stats getStats() {
        Stats stats;
        MeanTracker meanTracker = this.inbound;
        synchronized (meanTracker) {
            Stats stats2;
            MeanTracker meanTracker2 = this.outbound;
            synchronized (meanTracker2) {
                Stats stats3;
                ConnTracker connTracker = this.conns;
                synchronized (connTracker) {
                    stats3 = this.Stats().apply(this.inbound.getMean(), this.inbound.getTotal(), this.outbound.getMean(), this.outbound.getTotal(), this.conns.getMean(), this.conns.getTotal(), this.conns.getLive());
                }
                stats2 = stats3;
            }
            stats = stats2;
        }
        return stats;
    }

    @Override
    public void connectionAccepted() {
        this.conns.update(1L);
    }

    @Override
    public void bytesInbound(long n) {
        this.inbound.update(n);
    }

    @Override
    public void connectionClosed() {
        this.conns.closed();
    }

    @Override
    public void bytesOutBound(long n) {
        this.outbound.update(n);
    }

    private static final Object $init$$$anonfun$1() {
        return "Duration must be Finite and greater than 1 ns";
    }

    public class ConnTracker
    extends MeanTracker {
        private long currentLive;

        public ConnTracker() {
            if (IntervalConnectionMonitor.this == null) {
                throw new NullPointerException();
            }
            this.currentLive = 0L;
        }

        public long getLive() {
            return this.currentLive;
        }

        @Override
        public void update(long c) {
            ConnTracker connTracker = this;
            synchronized (connTracker) {
                this.currentLive += c;
                super.update(c);
            }
        }

        public void closed() {
            ConnTracker connTracker = this;
            synchronized (connTracker) {
                --this.currentLive;
            }
        }

        public final /* synthetic */ IntervalConnectionMonitor org$http4s$blaze$pipeline$stages$monitors$IntervalConnectionMonitor$ConnTracker$$$outer() {
            return IntervalConnectionMonitor.this;
        }
    }

    public class MeanTracker {
        private double currentMean;
        private long lastupdate;
        private long total;

        public MeanTracker() {
            if (IntervalConnectionMonitor.this == null) {
                throw new NullPointerException();
            }
            this.currentMean = 0.0;
            this.lastupdate = System.nanoTime();
            this.total = 0L;
        }

        public double getMean() {
            return this.currentMean * 1.0E9;
        }

        public long getTotal() {
            return this.total;
        }

        public void update(long c) {
            MeanTracker meanTracker = this;
            synchronized (meanTracker) {
                this.total += c;
                long currentTime = System.nanoTime();
                long ticks = currentTime - this.lastupdate;
                this.lastupdate = currentTime;
                this.currentMean = this.currentMean * package$.MODULE$.pow(1.0 - IntervalConnectionMonitor.this.org$http4s$blaze$pipeline$stages$monitors$IntervalConnectionMonitor$$alpha, (double)ticks) + (double)c * IntervalConnectionMonitor.this.org$http4s$blaze$pipeline$stages$monitors$IntervalConnectionMonitor$$alpha;
            }
        }

        public final /* synthetic */ IntervalConnectionMonitor org$http4s$blaze$pipeline$stages$monitors$IntervalConnectionMonitor$MeanTracker$$$outer() {
            return IntervalConnectionMonitor.this;
        }
    }

    public class Stats
    implements Product,
    Serializable {
        private final double imean;
        private final long itotal;
        private final double omean;
        private final long ototal;
        private final double connmean;
        private final long conntotal;
        private final long connlive;
        private final /* synthetic */ IntervalConnectionMonitor $outer;

        public Stats(IntervalConnectionMonitor $outer, double imean, long itotal, double omean, long ototal, double connmean, long conntotal, long connlive) {
            this.imean = imean;
            this.itotal = itotal;
            this.omean = omean;
            this.ototal = ototal;
            this.connmean = connmean;
            this.conntotal = conntotal;
            this.connlive = connlive;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.imean()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.itotal()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.omean()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.ototal()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.connmean()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.conntotal()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.connlive()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Stats)) return false;
            if (((Stats)object).org$http4s$blaze$pipeline$stages$monitors$IntervalConnectionMonitor$Stats$$$outer() != this.$outer) return false;
            Stats stats = (Stats)object;
            if (this.imean() != stats.imean()) return false;
            if (this.itotal() != stats.itotal()) return false;
            if (this.omean() != stats.omean()) return false;
            if (this.ototal() != stats.ototal()) return false;
            if (this.connmean() != stats.connmean()) return false;
            if (this.conntotal() != stats.conntotal()) return false;
            if (this.connlive() != stats.connlive()) return false;
            if (!stats.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Stats;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "Stats";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToDouble((double)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToLong((long)this._6());
                }
                case 6: {
                    return BoxesRunTime.boxToLong((long)this._7());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "imean";
                }
                case 1: {
                    return "itotal";
                }
                case 2: {
                    return "omean";
                }
                case 3: {
                    return "ototal";
                }
                case 4: {
                    return "connmean";
                }
                case 5: {
                    return "conntotal";
                }
                case 6: {
                    return "connlive";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double imean() {
            return this.imean;
        }

        public long itotal() {
            return this.itotal;
        }

        public double omean() {
            return this.omean;
        }

        public long ototal() {
            return this.ototal;
        }

        public double connmean() {
            return this.connmean;
        }

        public long conntotal() {
            return this.conntotal;
        }

        public long connlive() {
            return this.connlive;
        }

        public String toString() {
            double mb = 0x100000;
            Tuple2 tuple2 = package$.MODULE$.max(this.imean(), this.omean()) > mb ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)mb), (Object)"MB") : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1024.0), (Object)"kB");
            double f1 = BoxesRunTime.unboxToDouble((Object)tuple2._1());
            String unit1 = (String)tuple2._2();
            Tuple2 tuple22 = (double)package$.MODULE$.max(this.itotal(), this.ototal()) > 1024.0 * mb ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(1024.0 * mb)), (Object)"GB") : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)mb), (Object)"MB");
            double f2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
            String unit2 = (String)tuple22._2();
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("                 Mean (%s/s)     Total (%s)\n         |Inbound bytes    %11.3f     %10.3f\n         |Outbound bytes   %11.3f     %10.3f\n         |\n         |Connections      %-10.6f      %10d\n         |\n         |Live Connections: %d\n       "))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unit1, unit2, BoxesRunTime.boxToDouble((double)(this.imean() / f1)), BoxesRunTime.boxToDouble((double)((double)this.itotal() / f2)), BoxesRunTime.boxToDouble((double)(this.omean() / f1)), BoxesRunTime.boxToDouble((double)((double)this.ototal() / f2)), BoxesRunTime.boxToDouble((double)this.connmean()), BoxesRunTime.boxToLong((long)this.conntotal()), BoxesRunTime.boxToLong((long)this.connlive())}));
        }

        public Stats copy(double imean, long itotal, double omean, long ototal, double connmean, long conntotal, long connlive) {
            return new Stats(this.$outer, imean, itotal, omean, ototal, connmean, conntotal, connlive);
        }

        public double copy$default$1() {
            return this.imean();
        }

        public long copy$default$2() {
            return this.itotal();
        }

        public double copy$default$3() {
            return this.omean();
        }

        public long copy$default$4() {
            return this.ototal();
        }

        public double copy$default$5() {
            return this.connmean();
        }

        public long copy$default$6() {
            return this.conntotal();
        }

        public long copy$default$7() {
            return this.connlive();
        }

        public double _1() {
            return this.imean();
        }

        public long _2() {
            return this.itotal();
        }

        public double _3() {
            return this.omean();
        }

        public long _4() {
            return this.ototal();
        }

        public double _5() {
            return this.connmean();
        }

        public long _6() {
            return this.conntotal();
        }

        public long _7() {
            return this.connlive();
        }

        public final /* synthetic */ IntervalConnectionMonitor org$http4s$blaze$pipeline$stages$monitors$IntervalConnectionMonitor$Stats$$$outer() {
            return this.$outer;
        }
    }
}

