/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class BufferTools$
implements Serializable {
    private static final ByteBuffer emptyBuffer;
    private static final Future emptyFutureBuffer;
    public static final BufferTools$ MODULE$;

    private BufferTools$() {
    }

    static {
        MODULE$ = new BufferTools$();
        emptyBuffer = MODULE$.allocate(0);
        emptyFutureBuffer = Future$.MODULE$.successful((Object)MODULE$.emptyBuffer());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BufferTools$.class);
    }

    public ByteBuffer emptyBuffer() {
        return emptyBuffer;
    }

    public Future<ByteBuffer> emptyFutureBuffer() {
        return emptyFutureBuffer;
    }

    public ByteBuffer allocate(int size) {
        return ByteBuffer.allocate(size);
    }

    public ByteBuffer copyBuffer(ByteBuffer b) {
        ByteBuffer bb = this.allocate(b.remaining());
        bb.put(b).flip();
        return bb;
    }

    public ByteBuffer joinBuffers(Seq<ByteBuffer> buffers) {
        Seq<ByteBuffer> seq = buffers;
        if (seq instanceof scala.collection.immutable.Seq) {
            Object object;
            SeqOps seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)((scala.collection.immutable.Seq)seq));
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                return this.emptyBuffer();
            }
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0 && (object = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) instanceof ByteBuffer) {
                ByteBuffer b = (ByteBuffer)object;
                return b;
            }
        }
        int sz2 = BoxesRunTime.unboxToInt((Object)buffers.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(sz, o) -> BufferTools$.$anonfun$1(BoxesRunTime.unboxToInt((Object)sz), (ByteBuffer)o)));
        ByteBuffer b = this.allocate(sz2);
        buffers.foreach((Function1 & Serializable)x$0 -> b.put((ByteBuffer)x$0));
        b.flip();
        return b;
    }

    public String bufferToString(ByteBuffer buffer, Charset charset) {
        if (!buffer.hasRemaining()) {
            return "";
        }
        byte[] arr = new byte[buffer.remaining()];
        buffer.get(arr);
        return new String(arr, charset);
    }

    public Charset bufferToString$default$2() {
        return StandardCharsets.UTF_8;
    }

    public ByteBuffer concatBuffers(ByteBuffer oldbuff, ByteBuffer newbuff) {
        if (oldbuff == null) {
            if (newbuff == null) {
                return this.emptyBuffer();
            }
            return newbuff;
        }
        if (newbuff == null) {
            return oldbuff;
        }
        if (!oldbuff.hasRemaining()) {
            return newbuff;
        }
        if (!newbuff.hasRemaining()) {
            return oldbuff;
        }
        if (!oldbuff.isReadOnly() && oldbuff.capacity() >= oldbuff.limit() + newbuff.remaining()) {
            oldbuff.mark().position(oldbuff.limit()).limit(oldbuff.limit() + newbuff.remaining());
            oldbuff.put(newbuff).reset();
            return oldbuff;
        }
        ByteBuffer n = this.allocate(oldbuff.remaining() + newbuff.remaining());
        n.put(oldbuff).put(newbuff).flip();
        return n;
    }

    public ByteBuffer takeSlice(ByteBuffer buffer, int size) {
        if (size < 0 || size > buffer.remaining()) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid size: ").append(size).append(". buffer: ").append(buffer).toString());
        }
        int currentLimit = buffer.limit();
        buffer.limit(buffer.position() + size);
        ByteBuffer slice = buffer.slice();
        buffer.position(buffer.limit()).limit(currentLimit);
        return slice;
    }

    public boolean checkEmpty(ByteBuffer[] buffers) {
        return this.checkEmpty$1(buffers, buffers.length - 1);
    }

    public int dropEmpty(ByteBuffer[] buffers) {
        int first;
        int max2 = buffers.length - 1;
        for (first = 0; first < max2 && !buffers[first].hasRemaining(); ++first) {
            buffers[first] = this.emptyBuffer();
        }
        return first;
    }

    public boolean checkEmpty(Iterable<ByteBuffer> buffers) {
        return !buffers.iterator().exists((Function1 & Serializable)_$1 -> _$1.hasRemaining());
    }

    public String mkString(scala.collection.immutable.Seq<ByteBuffer> buffers, Charset charset) {
        ByteBuffer b = this.joinBuffers((Seq<ByteBuffer>)buffers);
        return charset.decode(b).toString();
    }

    public Charset mkString$default$2() {
        return StandardCharsets.UTF_8;
    }

    public int copyBuffers(ByteBuffer[] buffers, ByteBuffer out) {
        int start = out.position();
        this.go$1(out, buffers, 0);
        return out.position() - start;
    }

    public boolean fastForwardBuffers(ByteBuffer[] buffers, int size) {
        Predef$.MODULE$.require(size >= 0);
        return this.go$2(buffers, 0, size) == 0;
    }

    public boolean areDirectOrEmpty(ByteBuffer[] buffers) {
        return this.go$3(buffers, 0);
    }

    public String hexString(ByteBuffer buffer, int limit) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder(buffer.toString());
        sb.append(" 0x");
        ByteBuffer readOnly = buffer.asReadOnlyBuffer();
        this.go$4(limit, readOnly, sb, 0);
        return sb.result();
    }

    public int hexString$default$2() {
        return Integer.MAX_VALUE;
    }

    private static final /* synthetic */ int $anonfun$1(int sz, ByteBuffer o) {
        return sz + o.remaining();
    }

    private final boolean checkEmpty$1(ByteBuffer[] buffers$1, int i) {
        while (true) {
            if (i < 0) {
                return true;
            }
            if (buffers$1[i].hasRemaining()) break;
            --i;
        }
        return false;
    }

    private final void go$1(ByteBuffer out$1, ByteBuffer[] buffers$2, int i) {
        while (out$1.hasRemaining() && i < buffers$2.length) {
            if (buffers$2[i] == null || !buffers$2[i].hasRemaining()) {
                ++i;
                continue;
            }
            ByteBuffer buffer = buffers$2[i];
            int position = buffer.position();
            int limit = buffer.limit();
            buffer.limit(package$.MODULE$.min(limit, position + out$1.remaining()));
            out$1.put(buffer);
            buffer.limit(limit);
            buffer.position(position);
            ++i;
        }
        return;
    }

    private final int go$2(ByteBuffer[] buffers$3, int i, int remaining) {
        while (remaining != 0 && i < buffers$3.length) {
            ByteBuffer buffer = buffers$3[i];
            if (buffer == null || !buffer.hasRemaining()) {
                ++i;
                continue;
            }
            int toForward = package$.MODULE$.min(remaining, buffer.remaining());
            buffer.position(buffer.position() + toForward);
            int n = i + 1;
            int n2 = remaining - toForward;
            i = n;
            remaining = n2;
        }
        return remaining;
    }

    private final boolean go$3(ByteBuffer[] buffers$4, int i) {
        while (true) {
            if (i >= buffers$4.length) {
                return true;
            }
            ByteBuffer buffer = buffers$4[i];
            if (buffer != null && !buffer.isDirect() && buffer.hasRemaining()) break;
            ++i;
        }
        return false;
    }

    private final void go$4(int limit$1, ByteBuffer readOnly$1, scala.collection.mutable.StringBuilder sb$1, int i) {
        while (i < limit$1 && readOnly$1.hasRemaining()) {
            sb$1.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)readOnly$1.get())})));
            ++i;
        }
    }
}

