/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.util;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadLocalScratchBuffer {
    private final boolean useDirect;
    private final Logger logger;
    private final ThreadLocal<ByteBuffer> localBuffer;

    public ThreadLocalScratchBuffer(boolean useDirect) {
        this.useDirect = useDirect;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.util.ThreadLocalScratchBuffer");
        this.localBuffer = new ThreadLocal();
    }

    private ByteBuffer allocate(int size) {
        if (this.useDirect) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    public final ByteBuffer getScratchBuffer(int size) {
        ByteBuffer b = this.localBuffer.get();
        if (b == null || b.capacity() < size) {
            Logger Logger_this = this.logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace(new StringBuilder(36).append("Allocating thread local ByteBuffer(").append(size).append(")").toString());
            }
            ByteBuffer b2 = this.allocate(size);
            this.localBuffer.set(b2);
            return b2;
        }
        b.clear();
        return b;
    }

    public final void clearScratchBuffer() {
        Logger Logger_this = this.logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace("Removing thread local ByteBuffer");
        }
        this.localBuffer.remove();
    }
}

