/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blazecore.util;

import cats.effect.kernel.Async;
import cats.effect.std.Dispatcher;
import fs2.Chunk;
import fs2.Chunk$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blazecore.util.ChunkWriter$;
import org.http4s.blazecore.util.EntityBodyWriter;
import org.http4s.blazecore.util.Http1Writer;
import org.http4s.blazecore.util.package$;
import org.http4s.util.StringWriter;
import scala.$less$colon$less$;
import scala.Function$;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class CachingChunkWriter<F>
implements Http1Writer<F> {
    private Promise wroteHeader;
    private final TailStage<ByteBuffer> pipe;
    private final F trailer;
    private final int bufferMaxSize;
    private final boolean omitEmptyContentLength;
    private final Async F;
    private final ExecutionContext ec;
    private final Dispatcher dispatcher;
    private StringWriter pendingHeaders;
    private final Buffer<Chunk<Object>> bodyBuffer;
    private int size;

    public CachingChunkWriter(TailStage<ByteBuffer> pipe, Object trailer, int bufferMaxSize, boolean omitEmptyContentLength, Async<F> F, ExecutionContext ec, Dispatcher<F> dispatcher) {
        this.pipe = pipe;
        this.trailer = trailer;
        this.bufferMaxSize = bufferMaxSize;
        this.omitEmptyContentLength = omitEmptyContentLength;
        this.F = F;
        this.ec = ec;
        this.dispatcher = dispatcher;
        EntityBodyWriter.$init$(this);
        this.bodyBuffer = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Chunk[0]));
        this.size = 0;
        Statics.releaseFence();
    }

    @Override
    public Promise wroteHeader() {
        return this.wroteHeader;
    }

    @Override
    public void org$http4s$blazecore$util$EntityBodyWriter$_setter_$wroteHeader_$eq(Promise x$0) {
        this.wroteHeader = x$0;
    }

    @Override
    public Async<F> F() {
        return this.F;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    public Dispatcher<F> dispatcher() {
        return this.dispatcher;
    }

    @Override
    public Future<BoxedUnit> writeHeaders(StringWriter headerWriter) {
        this.pendingHeaders = headerWriter;
        return package$.MODULE$.FutureUnit();
    }

    private void addChunk(Chunk<Object> chunk) {
        if (chunk.nonEmpty()) {
            this.bodyBuffer.$plus$eq(chunk);
            this.size += chunk.size();
            return;
        }
    }

    private Chunk<Object> toChunkAndClear() {
        Chunk<Object> chunk = this.size == 0 ? Chunk$.MODULE$.empty() : (this.bodyBuffer.size() == 1 ? (Chunk<Object>)this.bodyBuffer.head() : Chunk$.MODULE$.concat(this.bodyBuffer, ClassTag$.MODULE$.apply(Byte.TYPE)));
        this.bodyBuffer.clear();
        this.size = 0;
        return chunk;
    }

    @Override
    public Future<BoxedUnit> exceptionFlush() {
        if (this.size > 0) {
            Chunk<Object> c = this.toChunkAndClear();
            return this.pipe.channelWrite((Seq<ByteBuffer>)this.encodeChunk(c, (List<ByteBuffer>)scala.package$.MODULE$.Nil()));
        }
        return package$.MODULE$.FutureUnit();
    }

    @Override
    public Future<Object> writeEnd(Chunk<Object> chunk) {
        this.addChunk(chunk);
        Chunk<Object> c = this.toChunkAndClear();
        return this.doWriteEnd(c);
    }

    private Future<Object> doWriteEnd(Chunk<Object> chunk) {
        Future<Object> future;
        if (this.pendingHeaders != null) {
            StringWriter h = this.pendingHeaders;
            this.pendingHeaders = null;
            if (!chunk.isEmpty()) {
                ByteBuffer body = chunk.toByteBuffer($less$colon$less$.MODULE$.refl());
                h.$less$less(new StringBuilder(20).append("Content-Length: ").append(body.remaining()).append("\r\n\r\n").toString());
                ByteBuffer hbuff = ByteBuffer.wrap(h.result().getBytes(StandardCharsets.ISO_8859_1));
                future = this.pipe.channelWrite((Seq<ByteBuffer>)scala.package$.MODULE$.Nil().$colon$colon((Object)body).$colon$colon((Object)hbuff));
            } else {
                if (!this.omitEmptyContentLength) {
                    h.$less$less("Content-Length: 0\r\n");
                }
                h.$less$less("\r\n");
                ByteBuffer hbuff = ByteBuffer.wrap(h.result().getBytes(StandardCharsets.ISO_8859_1));
                future = this.pipe.channelWrite(hbuff);
            }
        } else {
            future = !chunk.isEmpty() ? this.writeBodyChunk(chunk, true).flatMap((Function1 & Serializable)_$3 -> ChunkWriter$.MODULE$.writeTrailer(this.pipe, this.trailer, this.F(), this.ec(), this.dispatcher()), this.ec()) : ChunkWriter$.MODULE$.writeTrailer(this.pipe, this.trailer, this.F(), this.ec(), this.dispatcher());
        }
        Future<Object> f = future;
        return f.map((Function1 & Serializable)y -> BoxesRunTime.unboxToBoolean((Object)Function$.MODULE$.const((Object)BoxesRunTime.boxToBoolean((boolean)false), y)), this.ec());
    }

    @Override
    public Future<BoxedUnit> writeBodyChunk(Chunk<Object> chunk, boolean flush) {
        this.addChunk(chunk);
        if (this.size >= this.bufferMaxSize || flush) {
            Chunk<Object> c = this.toChunkAndClear();
            return this.pipe.channelWrite((Seq<ByteBuffer>)this.encodeChunk(c, (List<ByteBuffer>)scala.package$.MODULE$.Nil()));
        }
        return package$.MODULE$.FutureUnit();
    }

    private List<ByteBuffer> encodeChunk(Chunk<Object> chunk, List<ByteBuffer> last) {
        List<ByteBuffer> list = ChunkWriter$.MODULE$.encodeChunk(chunk, last);
        if (this.pendingHeaders != null) {
            this.pendingHeaders.$less$less(ChunkWriter$.MODULE$.TransferEncodingChunkedString());
            ByteBuffer b = ByteBuffer.wrap(this.pendingHeaders.result().getBytes(StandardCharsets.ISO_8859_1));
            this.pendingHeaders = null;
            return list.$colon$colon((Object)b);
        }
        return list;
    }
}

