/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blazecore.websocket;

import cats.ApplicativeError;
import cats.Functor;
import cats.Invariant$;
import cats.MonadError;
import cats.effect.std.Random;
import cats.syntax.package;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.http4s.blazecore.websocket.WebSocketHandshake;
import org.http4s.crypto.Hash$;
import org.http4s.crypto.HashAlgorithm$SHA1$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class WebSocketHandshake$
implements Serializable {
    private static final ByteVector magicString;
    public static final List<Tuple2<String, String>> org$http4s$blazecore$websocket$WebSocketHandshake$$$clientBaseHeaders;
    public static final WebSocketHandshake$ MODULE$;

    private WebSocketHandshake$() {
    }

    static {
        MODULE$ = new WebSocketHandshake$();
        magicString = ByteVector$.MODULE$.view("258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.US_ASCII));
        org$http4s$blazecore$websocket$WebSocketHandshake$$$clientBaseHeaders = (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)"Connection", (Object)"Upgrade"), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)"Upgrade", (Object)"websocket"), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)"Sec-WebSocket-Version", (Object)"13"), (List)Nil$.MODULE$)));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WebSocketHandshake$.class);
    }

    public <F> Object clientHandshaker(String host, Random<F> random, MonadError<F, Throwable> evidence$1) {
        Base64.Encoder encoder = Base64.getEncoder();
        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(random.nextBytes(16), evidence$1).map((Function1 & Serializable)x$0 -> encoder.encodeToString((byte[])x$0)), evidence$1).flatMap((Function1 & Serializable)key -> package.all$.MODULE$.toFunctorOps(MODULE$.genAcceptKey((String)key, evidence$1), (Functor)evidence$1).map((Function1 & Serializable)acceptKey -> new WebSocketHandshake.ClientHandshaker(host, (String)key, (String)acceptKey)));
    }

    public Either<Tuple2<Object, String>, Seq<Tuple2<String, String>>> serverHandshake(Iterable<Tuple2<String, String>> headers) {
        if (!headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                return k.equalsIgnoreCase("Host");
            }
            throw new MatchError((Object)tuple2);
        })) {
            return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Missing Host Header"));
        }
        if (!headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Connection") && MODULE$.valueContains("Upgrade", v);
            }
            throw new MatchError((Object)tuple2);
        })) {
            return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Connection header"));
        }
        if (!headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Upgrade") && v.equalsIgnoreCase("websocket");
            }
            throw new MatchError((Object)tuple2);
        })) {
            return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Upgrade header"));
        }
        if (!headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Sec-WebSocket-Version") && MODULE$.valueContains("13", v);
            }
            throw new MatchError((Object)tuple2);
        })) {
            return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Websocket Version header"));
        }
        return (Either)headers.find((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Sec-WebSocket-Key") && MODULE$.decodeLen(v) == 16;
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._2();
                Either either = (Either)MODULE$.genAcceptKey(key, Invariant$.MODULE$.catsMonadErrorForEither());
                if (either instanceof Left) {
                    return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Sec-WebSocket-Key header"));
                }
                if (either instanceof Right) {
                    String acceptKey = (String)((Right)either).value();
                    return package$.MODULE$.Right().apply((Object)((SeqOps)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)"Upgrade", (Object)"websocket"), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)"Connection", (Object)"Upgrade"), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)"Sec-WebSocket-Accept", (Object)acceptKey), (List)Nil$.MODULE$)))));
                }
                throw new MatchError((Object)either);
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse(WebSocketHandshake$::serverHandshake$$anonfun$7);
    }

    public boolean isWebSocketRequest(Iterable<Tuple2<String, String>> headers) {
        return headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Upgrade") && v.equalsIgnoreCase("websocket");
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private int decodeLen(String key) {
        return Base64.getDecoder().decode(key).length;
    }

    private <F> Object genAcceptKey(String str, MonadError<F, Throwable> F) {
        return package.all$.MODULE$.toFlatMapOps(F.fromEither(ByteVector$.MODULE$.encodeAscii(str)), F).flatMap((Function1 & Serializable)data -> package.all$.MODULE$.toFunctorOps(Hash$.MODULE$.apply(Hash$.MODULE$.forApplicativeThrow((ApplicativeError)F)).digest(HashAlgorithm$SHA1$.MODULE$, data.$plus$plus(magicString)), (Functor)F).map((Function1 & Serializable)digest -> digest.toBase64()));
    }

    public boolean valueContains(String key, String value) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])value.split(","));
        Object[] parts = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$4 -> _$4.trim(), ClassTag$.MODULE$.apply(String.class));
        Object object2 = Predef$.MODULE$.refArrayOps(parts);
        return BoxesRunTime.unboxToBoolean((Object)ArrayOps$.MODULE$.foldLeft$extension(object2, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable)(b, s2) -> WebSocketHandshake$.valueContains$$anonfun$1(key, BoxesRunTime.unboxToBoolean((Object)b), (String)s2)));
    }

    public static final /* synthetic */ boolean org$http4s$blazecore$websocket$WebSocketHandshake$ClientHandshaker$$_$checkResponse$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return k.equalsIgnoreCase("Connection") && MODULE$.valueContains("Upgrade", v);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean org$http4s$blazecore$websocket$WebSocketHandshake$ClientHandshaker$$_$checkResponse$$anonfun$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return k.equalsIgnoreCase("Upgrade") && v.equalsIgnoreCase("websocket");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean org$http4s$blazecore$websocket$WebSocketHandshake$ClientHandshaker$$_$checkResponse$$anonfun$3(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.equalsIgnoreCase("Sec-WebSocket-Accept");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final Either org$http4s$blazecore$websocket$WebSocketHandshake$ClientHandshaker$$_$checkResponse$$anonfun$5() {
        return package$.MODULE$.Left().apply((Object)"Missing Sec-WebSocket-Accept header");
    }

    private static final Either serverHandshake$$anonfun$7() {
        return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Sec-WebSocket-Key header"));
    }

    private static final /* synthetic */ boolean valueContains$$anonfun$1(String key$2, boolean b, String s2) {
        return b || s2.equalsIgnoreCase(key$2) || s2.length() > 1 && s2.startsWith("\"") && s2.endsWith("\"") && s2.substring(1, s2.length() - 1).equalsIgnoreCase(key$2);
    }
}

