/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.internal;

import java.util.ArrayDeque;
import org.http4s.internal.Trampoline$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Trampoline {
    public static void execute(Runnable runnable) {
        Trampoline$.MODULE$.execute(runnable);
    }

    public static ExecutionContext prepare() {
        return Trampoline$.MODULE$.prepare();
    }

    public static void reportFailure(Throwable throwable) {
        Trampoline$.MODULE$.reportFailure(throwable);
    }

    public static final class ThreadLocalTrampoline
    implements ExecutionContext {
        private boolean running;
        private Runnable r0;
        private Runnable r1;
        private Runnable r2;
        private ArrayDeque<Runnable> rest;

        public ThreadLocalTrampoline() {
            ExecutionContext.$init$((ExecutionContext)this);
            this.running = false;
            this.r0 = null;
            this.r1 = null;
            this.r2 = null;
            this.rest = null;
        }

        public void execute(Runnable runnable) {
            Object object;
            if (this.r0 == null) {
                this.r0 = runnable;
                object = BoxedUnit.UNIT;
            } else if (this.r1 == null) {
                this.r1 = runnable;
                object = BoxedUnit.UNIT;
            } else if (this.r2 == null) {
                this.r2 = runnable;
                object = BoxedUnit.UNIT;
            } else {
                if (this.rest == null) {
                    this.rest = new ArrayDeque();
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.rest.add(runnable));
            }
            if (!this.running) {
                this.running = true;
                this.run();
                return;
            }
        }

        public void reportFailure(Throwable cause) {
            ExecutionContext$.MODULE$.defaultReporter().apply((Object)cause);
        }

        private void run() {
            while (true) {
                Runnable r;
                if ((r = this.next()) == null) {
                    this.rest = null;
                    this.running = false;
                    return;
                }
                try {
                    r.run();
                    continue;
                }
                catch (Throwable e) {
                    this.reportFailure(e);
                    continue;
                }
                break;
            }
        }

        private Runnable next() {
            Runnable r = this.r0;
            this.r0 = this.r1;
            this.r1 = this.r2;
            this.r2 = this.rest != null ? this.rest.pollFirst() : null;
            return r;
        }
    }
}

