/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.internal.parsing;

import cats.Invariant;
import cats.Semigroupal;
import cats.parse.Accumulator$;
import cats.parse.Accumulator0$;
import cats.parse.Parser;
import cats.parse.Parser$;
import cats.parse.Parser0;
import cats.syntax.package;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address;
import com.comcast.ip4s.Ipv6Address$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.internal.parsing.Rfc2234$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar;
import scala.runtime.RichInt$;

public final class Rfc3986$
implements Serializable {
    private static final Parser hexdig;
    private static final Parser unreserved;
    private static final Parser pctEncoded;
    private static final Parser subDelims;
    private static final Parser pchar;
    private static final Parser ipv4Address;
    private static final Parser ipv6Address;
    public static final Rfc3986$ MODULE$;

    private Rfc3986$() {
    }

    static {
        MODULE$ = new Rfc3986$();
        hexdig = MODULE$.digit().orElse(Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString("ABCDEFabcdef")));
        unreserved = MODULE$.alpha().orElse(MODULE$.digit()).orElse(Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString("-._~")));
        pctEncoded = Parser$.MODULE$.char('%').$times$greater((Parser0)MODULE$.hexdig().$tilde(MODULE$.hexdig())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                char a = tuple2._1$mcC$sp();
                char b = tuple2._2$mcC$sp();
                return (char)(this.toInt$1(a) << 4 + this.toInt$1(b));
            }
            throw new MatchError((Object)tuple2);
        });
        subDelims = Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString("!$&'()*+,;="));
        pchar = MODULE$.unreserved().orElse(MODULE$.pctEncoded()).orElse(MODULE$.subDelims()).orElse(Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString(":@")));
        Parser decOctet = Parser$.MODULE$.char('1').$tilde(MODULE$.digit()).$tilde(MODULE$.digit()).string().backtrack().orElse(Parser$.MODULE$.char('2').$tilde((Parser0)Parser$.MODULE$.charIn((Iterable)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'4')))).$tilde(MODULE$.digit()).string()).backtrack().orElse(Parser$.MODULE$.string("25").$tilde((Parser0)Parser$.MODULE$.charIn((Iterable)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'5')))).string()).backtrack().orElse(Parser$.MODULE$.charIn((Iterable)new RichChar(Predef$.MODULE$.charWrapper('1')).to((Object)BoxesRunTime.boxToCharacter((char)'9'))).$tilde(MODULE$.digit()).string()).backtrack().orElse(MODULE$.digit().string()).map((Function1 & Serializable)_$1 -> (byte)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$1))).backtrack();
        Parser dot = Parser$.MODULE$.char('.');
        Parser decOctDot = decOctet.$less$times((Parser0)dot);
        Parser ipv4Bytes = (Parser)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply((Object)decOctDot, (Object)decOctDot, (Object)decOctDot, (Object)decOctet)).tupled((Invariant)Parser$.MODULE$.catsInstancesParser(), (Semigroupal)Parser$.MODULE$.catsInstancesParser());
        ipv4Address = ipv4Bytes.map((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                byte a = BoxesRunTime.unboxToByte((Object)tuple4._1());
                byte b = BoxesRunTime.unboxToByte((Object)tuple4._2());
                byte c = BoxesRunTime.unboxToByte((Object)tuple4._3());
                byte d = BoxesRunTime.unboxToByte((Object)tuple4._4());
                return Ipv4Address$.MODULE$.fromBytes(a, b, c, d);
            }
            throw new MatchError((Object)tuple4);
        }).backtrack();
        Parser h16 = MODULE$.hexdig().$tilde(MODULE$.hexdig().$qmark()).$tilde(MODULE$.hexdig().$qmark()).$tilde(MODULE$.hexdig().$qmark()).string().map((Function1 & Serializable)s2 -> (short)Integer.parseInt(s2, 16));
        Parser colon2 = Parser$.MODULE$.char(':');
        Parser doubleColon = Parser$.MODULE$.string("::").void();
        Parser h16Colon = h16.$less$times((Parser0)colon2);
        Parser parsedIpv4Bytes = ipv4Bytes.map((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                byte by = BoxesRunTime.unboxToByte((Object)tuple4._1());
                byte by2 = BoxesRunTime.unboxToByte((Object)tuple4._2());
                byte by3 = BoxesRunTime.unboxToByte((Object)tuple4._3());
                byte by4 = BoxesRunTime.unboxToByte((Object)tuple4._4());
                if (true) {
                    byte a = by;
                    if (true) {
                        byte b = by2;
                        if (true) {
                            byte c = by3;
                            if (true) {
                                byte d = by4;
                                return (List)new .colon.colon((Object)BoxesRunTime.boxToShort((short)((short)(a << 8 | b))), (List)new .colon.colon((Object)BoxesRunTime.boxToShort((short)((short)(c << 8 | d))), (List)Nil$.MODULE$));
                            }
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple4);
        });
        Parser option1 = h16.$less$times((Parser0)colon2.void()).$tilde((Parser0)h16).map((Function1 & Serializable)t -> (List)new .colon.colon((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)t._1())), (List)new .colon.colon((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)t._2())), (List)Nil$.MODULE$)));
        Parser ls32 = option1.backtrack().orElse(parsedIpv4Bytes);
        Parser fullIpv6WihtOptionalIpv4 = h16Colon.repExactlyAs(6, Accumulator$.MODULE$.fromAccumulator0(Accumulator0$.MODULE$.listAccumulator0())).$tilde((Parser0)ls32).map((Function1 & Serializable)x$1 -> {
            List list;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && (list = (List)tuple2._1()) instanceof List) {
                List ls = list;
                List rs = (List)tuple2._2();
                return this.toIpv6$1((Seq)ls, (Seq)rs);
            }
            throw new MatchError((Object)tuple2);
        });
        Parser0 parser0 = h16.repSep0(0, 5, (Parser0)colon2).with1();
        Parser shortIpv6WithIpv4 = Parser.With1$.MODULE$.$less$times$extension(parser0, doubleColon).flatMap((Function1 & Serializable)lefts -> this.rightsWithIpv4$1(h16Colon, parsedIpv4Bytes, 4 - lefts.size()).map((Function1 & Serializable)rights -> this.toIpv6$1((Seq)lefts, (Seq)rights)));
        Parser0 parser02 = h16.repSep0(0, 7, (Parser0)colon2).with1();
        Parser shortIpv6 = Parser.With1$.MODULE$.$less$times$extension(parser02, doubleColon).flatMap((Function1 & Serializable)lefts -> (6 - lefts.size() > 0 ? h16.repSep0(0, 6 - lefts.size(), (Parser0)colon2) : Parser$.MODULE$.pure((Object)package$.MODULE$.Nil())).map((Function1 & Serializable)rights -> this.toIpv6$1((Seq)lefts, (Seq)rights)));
        ipv6Address = fullIpv6WihtOptionalIpv4.backtrack().orElse(shortIpv6WithIpv4.backtrack()).orElse(shortIpv6);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Rfc3986$.class);
    }

    public Parser<Object> alpha() {
        return Rfc2234$.MODULE$.alpha();
    }

    public Parser<Object> digit() {
        return Rfc2234$.MODULE$.digit();
    }

    public Parser<Object> hexdig() {
        return hexdig;
    }

    public Parser<Object> unreserved() {
        return unreserved;
    }

    public Parser<Object> pctEncoded() {
        return pctEncoded;
    }

    public Parser<Object> subDelims() {
        return subDelims;
    }

    public Parser<Object> pchar() {
        return pchar;
    }

    public Parser<Ipv4Address> ipv4Address() {
        return ipv4Address;
    }

    public Parser<Ipv6Address> ipv6Address() {
        return ipv6Address;
    }

    private final int toInt$1(char c) {
        char c2 = c;
        char c3 = c2;
        if (c3 >= '0' && c3 <= '9') {
            return c3 - 48;
        }
        char c4 = c2;
        if (c4 >= 'a' && c4 <= 'f') {
            return c4 - 97 + 10;
        }
        char c5 = c2;
        if (c5 >= 'A' && c5 <= 'F') {
            return c5 - 65 + 10;
        }
        throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c2));
    }

    private final short toIpv6$1$$anonfun$1() {
        return (short)0;
    }

    private final Ipv6Address toIpv6$1(Seq lefts, Seq rights) {
        SeqOps seqOps;
        Seq seq = (Seq)((IterableOps)lefts.$plus$plus((IterableOnce)Seq$.MODULE$.fill(8 - lefts.size() - rights.size(), this::toIpv6$1$$anonfun$1))).$plus$plus((IterableOnce)rights);
        if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq), 8) == 0) {
            short s2 = BoxesRunTime.unboxToShort((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0));
            short s3 = BoxesRunTime.unboxToShort((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1));
            short s4 = BoxesRunTime.unboxToShort((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 2));
            short s5 = BoxesRunTime.unboxToShort((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 3));
            short s6 = BoxesRunTime.unboxToShort((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 4));
            short s7 = BoxesRunTime.unboxToShort((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 5));
            short s8 = BoxesRunTime.unboxToShort((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 6));
            short s9 = BoxesRunTime.unboxToShort((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 7));
            short a = s2;
            short b = s3;
            short c = s4;
            short d = s5;
            short e = s6;
            short f = s7;
            short g = s8;
            short h = s9;
            ByteBuffer bb = ByteBuffer.allocate(16);
            bb.putShort(a);
            bb.putShort(b);
            bb.putShort(c);
            bb.putShort(d);
            bb.putShort(e);
            bb.putShort(f);
            bb.putShort(g);
            bb.putShort(h);
            return (Ipv6Address)Ipv6Address$.MODULE$.fromBytes(bb.array()).get();
        }
        throw new MatchError((Object)seq);
    }

    private final /* synthetic */ Parser rightsWithIpv4$1$$anonfun$1(Parser h16Colon$2, Parser parsedIpv4Bytes$2, int i) {
        return h16Colon$2.repExactlyAs(i, Accumulator$.MODULE$.fromAccumulator0(Accumulator0$.MODULE$.listAccumulator0())).$tilde((Parser0)parsedIpv4Bytes$2).backtrack().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List l = (List)tuple2._1();
                List r = (List)tuple2._2();
                return (List)l.$plus$plus((IterableOnce)r);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final Parser rightsWithIpv4$1(Parser h16Colon$1, Parser parsedIpv4Bytes$1, int n) {
        return (Parser)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), n).map((Function1 & Serializable)i -> this.rightsWithIpv4$1$$anonfun$1(h16Colon$1, parsedIpv4Bytes$1, BoxesRunTime.unboxToInt((Object)i))).foldLeft((Object)parsedIpv4Bytes$1.backtrack(), (Function2 & Serializable)(_$2, _$3) -> _$2.$bar(_$3));
    }
}

