/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.parser;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.CharBuffer;
import org.http4s.ParseFailure;
import org.http4s.ParseResult$;
import org.http4s.Query;
import org.http4s.Query$;
import org.http4s.Uri$;
import org.http4s.parser.QueryParser$;
import org.http4s.parser.QueryParser$KEY$;
import org.http4s.parser.QueryParser$VALUE$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ReusableBuilder;
import scala.io.Codec;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Either;

public class QueryParser {
    private final Codec codec;
    private final boolean colonSeparators;
    private final BitSet qChars;

    public static BitSet ExtendedQChars() {
        return QueryParser$.MODULE$.ExtendedQChars();
    }

    public static BitSet QChars() {
        return QueryParser$.MODULE$.QChars();
    }

    public static Either<ParseFailure, Query> parseQueryString(String string, Codec codec) {
        return QueryParser$.MODULE$.parseQueryString(string, codec);
    }

    public static Either<ParseFailure, Vector<Tuple2<String, Option<String>>>> parseQueryStringVector(String string, Codec codec) {
        return QueryParser$.MODULE$.parseQueryStringVector(string, codec);
    }

    public static Codec parseQueryString$default$2() {
        return QueryParser$.MODULE$.parseQueryString$default$2();
    }

    public static Codec parseQueryStringVector$default$2() {
        return QueryParser$.MODULE$.parseQueryStringVector$default$2();
    }

    public static BitSet $lessinit$greater$default$3() {
        return QueryParser$.MODULE$.$lessinit$greater$default$3();
    }

    public QueryParser(Codec codec, boolean colonSeparators, BitSet qChars) {
        this.codec = codec;
        this.colonSeparators = colonSeparators;
        this.qChars = qChars;
    }

    public Either<ParseFailure, Query> decode(CharBuffer input, boolean flush) {
        return this.decodeVector(input, flush).map((Function1 & Serializable)xs -> Query$.MODULE$.fromVector((Vector<Tuple2<String, Option<String>>>)xs));
    }

    public Either<ParseFailure, Vector<Tuple2<String, Option<String>>>> decodeVector(CharBuffer input, boolean flush) {
        ReusableBuilder acc = package$.MODULE$.Vector().newBuilder();
        Option<String> option = this.decodeBuffer(input, (Function2<String, Option<String>, Builder<Tuple2<String, Option<String>>, Vector<Tuple2<String, Option<String>>>>>)((Function2 & Serializable)(arg_0, arg_1) -> QueryParser.decodeVector$$anonfun$1((Builder)acc, arg_0, arg_1)), flush);
        if (option instanceof Some) {
            String e = (String)((Some)option).value();
            return ParseResult$.MODULE$.fail("Decoding of url encoded data failed.", e);
        }
        if (None$.MODULE$.equals(option)) {
            return ParseResult$.MODULE$.success(acc.result());
        }
        throw new MatchError(option);
    }

    private Option<String> decodeBuffer(CharBuffer input, Function2<String, Option<String>, Builder<Tuple2<String, Option<String>>, Vector<Tuple2<String, Option<String>>>>> acc, boolean flush) {
        Buffer buffer;
        scala.collection.mutable.StringBuilder valAcc = new scala.collection.mutable.StringBuilder(QueryParser$.org$http4s$parser$QueryParser$$$InitialBufferCapactiy);
        String error = null;
        ObjectRef key = ObjectRef.create(null);
        ObjectRef state = ObjectRef.create((Object)QueryParser$KEY$.MODULE$);
        if (!flush) {
            input.mark();
        }
        while (error == null && input.hasRemaining()) {
            char c = input.get();
            char c2 = c;
            if ('&' == c2) {
                this.endPair$1(flush, input, state, valAcc, acc, key);
                continue;
            }
            if (';' == c2 && this.colonSeparators) {
                this.endPair$1(flush, input, state, valAcc, acc, key);
                continue;
            }
            if ('=' == c2) {
                State state2 = (State)state.elem;
                QueryParser$VALUE$ queryParser$VALUE$ = QueryParser$VALUE$.MODULE$;
                if (!(state2 != null ? !state2.equals(queryParser$VALUE$) : queryParser$VALUE$ != null)) {
                    valAcc.append('=');
                    continue;
                }
                state.elem = QueryParser$VALUE$.MODULE$;
                key.elem = valAcc.result();
                valAcc.clear();
                continue;
            }
            char c3 = c2;
            if (this.qChars.contains((int)c3)) {
                valAcc.append(c3);
                continue;
            }
            char c4 = c2;
            error = new StringBuilder(48).append("Invalid char while splitting key/value pairs: '").append(c4).append("'").toString();
        }
        if (error != null) {
            return Some$.MODULE$.apply(error);
        }
        if (flush) {
            this.appendValue$1(state, valAcc, acc, key);
            buffer = BoxedUnit.UNIT;
        } else {
            buffer = input.reset();
        }
        return None$.MODULE$;
    }

    private String decodeParam(String str) {
        String string;
        try {
            string = Uri$.MODULE$.decode(str, this.codec.charSet(), true, Uri$.MODULE$.decode$default$4());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = "";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "";
        }
        return string;
    }

    private static final /* synthetic */ Builder decodeVector$$anonfun$1(Builder acc$1, String k, Option v) {
        return (Builder)acc$1.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)k, (Object)v));
    }

    private final void appendValue$1(ObjectRef state$1, scala.collection.mutable.StringBuilder valAcc$1, Function2 acc$2, ObjectRef key$1) {
        Builder builder;
        State state = (State)state$1.elem;
        QueryParser$KEY$ queryParser$KEY$ = QueryParser$KEY$.MODULE$;
        if (!(state != null ? !state.equals(queryParser$KEY$) : queryParser$KEY$ != null)) {
            String s2 = valAcc$1.result();
            String k = this.decodeParam(s2);
            valAcc$1.clear();
            builder = (Builder)acc$2.apply((Object)k, (Object)None$.MODULE$);
        } else {
            String k = this.decodeParam((String)key$1.elem);
            key$1.elem = null;
            String s3 = valAcc$1.result();
            valAcc$1.clear();
            Some v = Some$.MODULE$.apply((Object)this.decodeParam(s3));
            builder = (Builder)acc$2.apply((Object)k, (Object)v);
        }
    }

    private final void endPair$1(boolean flush$1, CharBuffer input$1, ObjectRef state$2, scala.collection.mutable.StringBuilder valAcc$2, Function2 acc$3, ObjectRef key$2) {
        if (!flush$1) {
            input$1.mark();
        }
        this.appendValue$1(state$2, valAcc$2, acc$3, key$2);
        state$2.elem = QueryParser$KEY$.MODULE$;
    }

    public static interface State {
    }
}

