/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.collection;

import org.openmole.tool.collection.ArrayStack$;
import scala.Array$;
import scala.reflect.ClassTag;
import scala.runtime.ScalaRunTime$;

public class ArrayStack<T> {
    private Object array;
    private final int growthFactor;
    private int capacity;
    private final int initialCapacity;
    private final ClassTag<T> evidence$1;
    private int currentIndex;

    public static <T> ArrayStack<T> apply(int n, int n2, ClassTag<T> classTag) {
        return ArrayStack$.MODULE$.apply(n, n2, classTag);
    }

    public static <T> int apply$default$2() {
        return ArrayStack$.MODULE$.apply$default$2();
    }

    public ArrayStack(Object array, int growthFactor, int capacity, int initialCapacity, ClassTag<T> evidence$1) {
        this.array = array;
        this.growthFactor = growthFactor;
        this.capacity = capacity;
        this.initialCapacity = initialCapacity;
        this.evidence$1 = evidence$1;
        this.currentIndex = 0;
    }

    private Object array() {
        return this.array;
    }

    private void array_$eq(Object x$0) {
        this.array = x$0;
    }

    private int capacity() {
        return this.capacity;
    }

    private void capacity_$eq(int x$0) {
        this.capacity = x$0;
    }

    public void add(T t) {
        ArrayStack arrayStack = this;
        synchronized (arrayStack) {
            if (this.currentIndex == this.capacity()) {
                this.growCapacity();
            }
            ScalaRunTime$.MODULE$.array_update(this.array(), this.currentIndex, t);
            ++this.currentIndex;
        }
    }

    public int size() {
        int n;
        ArrayStack arrayStack = this;
        synchronized (arrayStack) {
            n = this.currentIndex;
        }
        return n;
    }

    public T pop() {
        Object object;
        ArrayStack arrayStack = this;
        synchronized (arrayStack) {
            --this.currentIndex;
            object = ScalaRunTime$.MODULE$.array_apply(this.array(), this.currentIndex);
        }
        return (T)object;
    }

    public void clear() {
        ArrayStack arrayStack = this;
        synchronized (arrayStack) {
            this.currentIndex = 0;
            this.array_$eq(Array$.MODULE$.ofDim(this.initialCapacity, this.evidence$1));
        }
    }

    private void growCapacity() {
        int newCapacity = this.capacity() * this.growthFactor;
        Object newArray = Array$.MODULE$.ofDim(newCapacity, this.evidence$1);
        System.arraycopy(this.array(), 0, newArray, 0, ScalaRunTime$.MODULE$.array_length(this.array()));
        this.array_$eq(newArray);
        this.capacity_$eq(newCapacity);
    }
}

