/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.collection;

import java.util.concurrent.atomic.AtomicInteger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.mutable.HashMap;

public class DisposableRepository<K, V> {
    private final Function1<K, V> build;
    private final HashMap<K, Tuple2<V, AtomicInteger>> objects;

    public DisposableRepository(Function1<K, V> build) {
        this.build = build;
        this.objects = new HashMap();
    }

    public HashMap<K, Tuple2<V, AtomicInteger>> objects() {
        return this.objects;
    }

    private V get(K k) {
        Object object;
        HashMap<K, Tuple2<V, AtomicInteger>> hashMap = this.objects();
        synchronized (hashMap) {
            Tuple2 tuple2 = (Tuple2)this.objects().getOrElseUpdate(k, () -> this.$anonfun$1(k));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object lock = tuple2._1();
            AtomicInteger users = (AtomicInteger)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(lock, (Object)users);
            Object lock2 = tuple22._1();
            AtomicInteger users2 = (AtomicInteger)tuple22._2();
            users2.incrementAndGet();
            object = lock2;
        }
        return (V)object;
    }

    private V dispose(K k) {
        Object object;
        HashMap<K, Tuple2<V, AtomicInteger>> hashMap = this.objects();
        synchronized (hashMap) {
            Object v;
            Tuple2 tuple2;
            Option option = this.objects().get(k);
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                v = tuple2._1();
                AtomicInteger users = (AtomicInteger)tuple2._2();
                int value = users.decrementAndGet();
                if (value <= 0) {
                    this.objects().remove(k);
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException("Disposing an object that has not been borrowed.");
                }
                throw new MatchError((Object)option);
            }
            object = v;
        }
        return (V)object;
    }

    public <T> T borrow(K k, Function1<V, T> f) {
        Object object;
        V v = this.get(k);
        try {
            object = f.apply(v);
        }
        finally {
            this.dispose(k);
        }
        return (T)object;
    }

    private final Tuple2 $anonfun$1(Object k$1) {
        return Tuple2$.MODULE$.apply(this.build.apply(k$1), (Object)new AtomicInteger(0));
    }
}

