/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.collection;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Stack;
import java.util.TreeMap;
import org.openmole.tool.collection.PriorityQueue$;
import org.openmole.tool.collection.PriorityQueue$FIFO$;
import org.openmole.tool.collection.PriorityQueue$FILO$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class PriorityQueue<T> {
    private final boolean fifo;
    private int inQueue;
    private final Map<Object, InnerQueue<T>> queues;

    public static <T> Object add(InnerQueue<T> innerQueue, T t) {
        return PriorityQueue$.MODULE$.add(innerQueue, t);
    }

    public static <T> PriorityQueue<T> apply(boolean bl) {
        return PriorityQueue$.MODULE$.apply(bl);
    }

    public static <T> T pool(InnerQueue<T> innerQueue) {
        return PriorityQueue$.MODULE$.pool(innerQueue);
    }

    public static <T> Vector<T> toVector(InnerQueue<T> innerQueue) {
        return PriorityQueue$.MODULE$.toVector(innerQueue);
    }

    public static <T> boolean apply$default$1() {
        return PriorityQueue$.MODULE$.apply$default$1();
    }

    public PriorityQueue(boolean fifo) {
        this.fifo = fifo;
        this.inQueue = 0;
        this.queues = CollectionConverters$.MODULE$.MapHasAsScala(new TreeMap()).asScala();
    }

    public Map<Object, InnerQueue<T>> queues() {
        return this.queues;
    }

    public int size() {
        int n;
        PriorityQueue priorityQueue = this;
        synchronized (priorityQueue) {
            n = this.inQueue;
        }
        return n;
    }

    public void enqueue(T e, int priority) {
        PriorityQueue priorityQueue = this;
        synchronized (priorityQueue) {
            Option option = this.queues().get((Object)BoxesRunTime.boxToInteger((int)priority));
            if (option instanceof Some) {
                InnerQueue queue = (InnerQueue)((Some)option).value();
                v0 = PriorityQueue$.MODULE$.add(queue, e);
            } else if (None$.MODULE$.equals(option)) {
                InnerQueue q = (InnerQueue)(!this.fifo ? PriorityQueue$FILO$.MODULE$.apply(PriorityQueue$FILO$.MODULE$.$lessinit$greater$default$1()) : PriorityQueue$FIFO$.MODULE$.apply(PriorityQueue$FIFO$.MODULE$.$lessinit$greater$default$1()));
                PriorityQueue$.MODULE$.add(q, e);
                v0 = this.queues().put((Object)BoxesRunTime.boxToInteger((int)priority), (Object)q);
            } else {
                throw new MatchError((Object)option);
            }
            ++this.inQueue;
        }
    }

    public Option<T> dequeue() {
        Option option;
        PriorityQueue priorityQueue = this;
        synchronized (priorityQueue) {
            ObjectRef res = ObjectRef.create((Object)None$.MODULE$);
            this.queues().lastOption().foreach((Function1 & Serializable)x$1 -> {
                int n = BoxesRunTime.unboxToInt((Object)x$1._1());
                InnerQueue innerQueue = (InnerQueue)x$1._2();
                Object job = PriorityQueue$.MODULE$.pool(innerQueue);
                res$1.elem = Some$.MODULE$.apply(job);
                --this.inQueue;
                if (PriorityQueue$.MODULE$.isEmpty(innerQueue)) {
                    this.queues().remove((Object)BoxesRunTime.boxToInteger((int)n));
                }
                return job;
            });
            option = (Option)res.elem;
        }
        return option;
    }

    public Vector<T> all() {
        Vector vector;
        PriorityQueue priorityQueue = this;
        synchronized (priorityQueue) {
            vector = (Vector)this.queues().values().toVector().flatMap((Function1 & Serializable)innerQueue -> PriorityQueue$.MODULE$.toVector(innerQueue));
        }
        return vector;
    }

    public void clear() {
        PriorityQueue priorityQueue = this;
        synchronized (priorityQueue) {
            this.queues().clear();
        }
    }

    public boolean isEmpty() {
        boolean bl;
        PriorityQueue priorityQueue = this;
        synchronized (priorityQueue) {
            bl = this.size() == 0;
        }
        return bl;
    }

    public static class FIFO<T>
    implements InnerQueue<T>,
    Product,
    Serializable {
        private final LinkedList<T> linkedList;

        public static <T> FIFO<T> apply(LinkedList<T> linkedList) {
            return PriorityQueue$FIFO$.MODULE$.apply(linkedList);
        }

        public static FIFO<?> fromProduct(Product product) {
            return PriorityQueue$FIFO$.MODULE$.fromProduct(product);
        }

        public static <T> FIFO<T> unapply(FIFO<T> fIFO) {
            return PriorityQueue$FIFO$.MODULE$.unapply(fIFO);
        }

        public static <T> LinkedList<T> $lessinit$greater$default$1() {
            return PriorityQueue$FIFO$.MODULE$.$lessinit$greater$default$1();
        }

        public FIFO(LinkedList<T> linkedList) {
            this.linkedList = linkedList;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 144674921, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FIFO)) return false;
            FIFO fIFO = (FIFO)object;
            LinkedList<T> linkedList = this.linkedList();
            LinkedList<T> linkedList2 = fIFO.linkedList();
            if (linkedList == null) {
                if (linkedList2 != null) {
                    return false;
                }
            } else if (!((Object)linkedList).equals(linkedList2)) return false;
            if (!fIFO.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FIFO;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FIFO";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "linkedList";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LinkedList<T> linkedList() {
            return this.linkedList;
        }

        public <T> FIFO<T> copy(LinkedList<T> linkedList) {
            return new FIFO<T>(linkedList);
        }

        public <T> LinkedList<T> copy$default$1() {
            return this.linkedList();
        }

        public LinkedList<T> _1() {
            return this.linkedList();
        }
    }

    public static class FILO<T>
    implements InnerQueue<T>,
    Product,
    Serializable {
        private final Stack<T> stack;

        public static <T> FILO<T> apply(Stack<T> stack) {
            return PriorityQueue$FILO$.MODULE$.apply(stack);
        }

        public static FILO<?> fromProduct(Product product) {
            return PriorityQueue$FILO$.MODULE$.fromProduct(product);
        }

        public static <T> FILO<T> unapply(FILO<T> fILO) {
            return PriorityQueue$FILO$.MODULE$.unapply(fILO);
        }

        public static <T> Stack<T> $lessinit$greater$default$1() {
            return PriorityQueue$FILO$.MODULE$.$lessinit$greater$default$1();
        }

        public FILO(Stack<T> stack) {
            this.stack = stack;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -1047093768, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FILO)) return false;
            FILO fILO = (FILO)object;
            Stack<T> stack = this.stack();
            Stack<T> stack2 = fILO.stack();
            if (stack == null) {
                if (stack2 != null) {
                    return false;
                }
            } else if (!((Object)stack).equals(stack2)) return false;
            if (!fILO.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FILO;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FILO";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "stack";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Stack<T> stack() {
            return this.stack;
        }

        public <T> FILO<T> copy(Stack<T> stack) {
            return new FILO<T>(stack);
        }

        public <T> Stack<T> copy$default$1() {
            return this.stack();
        }

        public Stack<T> _1() {
            return this.stack();
        }
    }

    public static interface InnerQueue<T> {
    }
}

