/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.authentication;

import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.File;
import org.openmole.core.authentication.AuthenticationStore$;
import org.openmole.core.workspace.Workspace;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;

public class AuthenticationStore {
    private final File _baseDir;

    public static AuthenticationStore apply(Workspace workspace) {
        return AuthenticationStore$.MODULE$.apply(workspace);
    }

    public static String authenticationsLocation() {
        return AuthenticationStore$.MODULE$.authenticationsLocation();
    }

    public AuthenticationStore(File _baseDir) {
        this._baseDir = _baseDir;
    }

    public File baseDir() {
        this._baseDir.mkdirs();
        return this._baseDir;
    }

    public File store(String name) {
        return new File(this.baseDir(), name);
    }

    public <T> void save(String name, Seq<T> obj, Encoder<T> evidence$1) {
        AuthenticationStore authenticationStore = this;
        synchronized (authenticationStore) {
            File file = new File(this.baseDir(), name);
            Seq seq = (Seq)io.circe.syntax.package$.MODULE$.EncoderOps(obj);
            org.openmole.tool.file.package$.MODULE$.FileDecorator(file).content_$eq(package.EncoderOps$.MODULE$.asJson$extension((Object)seq, (Encoder)Encoder$.MODULE$.encodeSeq(evidence$1)).noSpaces());
        }
    }

    public <T> Seq<T> load(String name, Decoder<T> evidence$1) {
        Seq seq;
        AuthenticationStore authenticationStore = this;
        synchronized (authenticationStore) {
            File file = this.store(name);
            seq = file.exists() ? (Seq)package$.MODULE$.decode(org.openmole.tool.file.package$.MODULE$.FileDecorator(file).content(), Decoder$.MODULE$.decodeSeq(evidence$1)).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl()).get() : (Seq)((SeqOps)Nil$.MODULE$);
        }
        return seq;
    }

    public <T> void modify(String name, Function1<Seq<T>, Seq<T>> m, Encoder<T> evidence$1, Decoder<T> evidence$2) {
        AuthenticationStore authenticationStore = this;
        synchronized (authenticationStore) {
            this.save(name, (Seq)m.apply(this.load(name, evidence$2)), evidence$1);
        }
    }

    public boolean clear(String name) {
        boolean bl;
        AuthenticationStore authenticationStore = this;
        synchronized (authenticationStore) {
            bl = this.store(name).delete();
        }
        return bl;
    }

    public boolean delete() {
        boolean bl;
        AuthenticationStore authenticationStore = this;
        synchronized (authenticationStore) {
            org.openmole.tool.file.package$.MODULE$.FileDecorator(this.baseDir()).recursiveDelete();
            bl = this.baseDir().mkdirs();
        }
        return bl;
    }
}

