/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class CMCEPublicKey
extends ASN1Object {
    private byte[] T;

    public CMCEPublicKey(byte[] byArray) {
        this.T = byArray;
    }

    public CMCEPublicKey(ASN1Sequence aSN1Sequence) {
        this.T = Arrays.clone((byte[])ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(0)).getOctets());
    }

    public byte[] getT() {
        return Arrays.clone((byte[])this.T);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.T));
        return new DERSequence(aSN1EncodableVector);
    }

    public static CMCEPublicKey getInstance(Object object) {
        if (object instanceof CMCEPublicKey) {
            return (CMCEPublicKey)object;
        }
        if (object != null) {
            return new CMCEPublicKey(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }
}

