/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.asn1.CMCEPrivateKey;
import org.bouncycastle.pqc.asn1.FalconPrivateKey;
import org.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import org.bouncycastle.pqc.asn1.SPHINCSPLUSPrivateKey;
import org.bouncycastle.pqc.asn1.SPHINCSPLUSPublicKey;
import org.bouncycastle.pqc.asn1.XMSSKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import org.bouncycastle.pqc.asn1.XMSSPrivateKey;
import org.bouncycastle.pqc.crypto.bike.BIKEParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import org.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.frodo.FrodoParameters;
import org.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import org.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import org.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.saber.SABERParameters;
import org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.Utils;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPrivateKeyParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("privateKeyInfoData array null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("privateKeyInfoData array empty");
        }
        return PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) throws IOException {
        return PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        if (privateKeyInfo == null) {
            throw new IllegalArgumentException("keyInfo array null");
        }
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (aSN1ObjectIdentifier.on(PQCObjectIdentifiers.qTESLA)) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey());
            return new QTESLAPrivateKeyParameters(Utils.qTeslaLookupSecurityCategory((AlgorithmIdentifier)algorithmIdentifier), aSN1OctetString.getOctets());
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)PQCObjectIdentifiers.sphincs256)) {
            return new SPHINCSPrivateKeyParameters(ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets(), Utils.sphincs256LookupTreeAlgName((SPHINCS256KeyParams)SPHINCS256KeyParams.getInstance((Object)algorithmIdentifier.getParameters())));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)PQCObjectIdentifiers.newHope)) {
            return new NHPrivateKeyParameters(PrivateKeyFactory.convert((byte[])ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets()));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
            ASN1OctetString aSN1OctetString = PrivateKeyFactory.parseOctetString((ASN1OctetString)privateKeyInfo.getPrivateKey(), (int)64);
            byte[] byArray = aSN1OctetString.getOctets();
            ASN1BitString aSN1BitString = privateKeyInfo.getPublicKeyData();
            if (aSN1BitString != null) {
                byte[] byArray2 = aSN1BitString.getOctets();
                return HSSPrivateKeyParameters.getInstance((byte[])Arrays.copyOfRange((byte[])byArray, (int)4, (int)byArray.length), (byte[])byArray2);
            }
            return HSSPrivateKeyParameters.getInstance((Object)Arrays.copyOfRange((byte[])byArray, (int)4, (int)byArray.length));
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.sphincsPlus) || aSN1ObjectIdentifier.on(BCObjectIdentifiers.sphincsPlus_interop)) {
            SPHINCSPlusParameters sPHINCSPlusParameters = Utils.sphincsPlusParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
            if (aSN1Encodable instanceof ASN1Sequence) {
                SPHINCSPLUSPrivateKey sPHINCSPLUSPrivateKey = SPHINCSPLUSPrivateKey.getInstance((Object)aSN1Encodable);
                SPHINCSPLUSPublicKey sPHINCSPLUSPublicKey = sPHINCSPLUSPrivateKey.getPublicKey();
                return new SPHINCSPlusPrivateKeyParameters(sPHINCSPlusParameters, sPHINCSPLUSPrivateKey.getSkseed(), sPHINCSPLUSPrivateKey.getSkprf(), sPHINCSPLUSPublicKey.getPkseed(), sPHINCSPLUSPublicKey.getPkroot());
            }
            return new SPHINCSPlusPrivateKeyParameters(sPHINCSPlusParameters, ASN1OctetString.getInstance((Object)aSN1Encodable).getOctets());
        }
        if (Utils.shldsaParams.containsKey(aSN1ObjectIdentifier)) {
            SLHDSAParameters sLHDSAParameters = Utils.slhdsaParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            ASN1OctetString aSN1OctetString = PrivateKeyFactory.parseOctetString((ASN1OctetString)privateKeyInfo.getPrivateKey(), (int)(sLHDSAParameters.getN() * 4));
            return new SLHDSAPrivateKeyParameters(sLHDSAParameters, aSN1OctetString.getOctets());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.picnic)) {
            byte[] byArray = ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets();
            PicnicParameters picnicParameters = Utils.picnicParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new PicnicPrivateKeyParameters(picnicParameters, byArray);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_mceliece)) {
            CMCEPrivateKey cMCEPrivateKey = CMCEPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
            CMCEParameters cMCEParameters = Utils.mcElieceParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new CMCEPrivateKeyParameters(cMCEParameters, cMCEPrivateKey.getDelta(), cMCEPrivateKey.getC(), cMCEPrivateKey.getG(), cMCEPrivateKey.getAlpha(), cMCEPrivateKey.getS());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_frodo)) {
            byte[] byArray = ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets();
            FrodoParameters frodoParameters = Utils.frodoParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new FrodoPrivateKeyParameters(frodoParameters, byArray);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_saber)) {
            byte[] byArray = ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets();
            SABERParameters sABERParameters = Utils.saberParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new SABERPrivateKeyParameters(sABERParameters, byArray);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_ntru)) {
            byte[] byArray = ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets();
            NTRUParameters nTRUParameters = Utils.ntruParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new NTRUPrivateKeyParameters(nTRUParameters, byArray);
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)NISTObjectIdentifiers.id_alg_ml_kem_512) || aSN1ObjectIdentifier.equals((ASN1Primitive)NISTObjectIdentifiers.id_alg_ml_kem_768) || aSN1ObjectIdentifier.equals((ASN1Primitive)NISTObjectIdentifiers.id_alg_ml_kem_1024)) {
            ASN1OctetString aSN1OctetString = PrivateKeyFactory.parseOctetString((ASN1OctetString)privateKeyInfo.getPrivateKey(), (int)64);
            MLKEMParameters mLKEMParameters = Utils.mlkemParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new MLKEMPrivateKeyParameters(mLKEMParameters, aSN1OctetString.getOctets());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_ntrulprime)) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)privateKeyInfo.parsePrivateKey());
            NTRULPRimeParameters nTRULPRimeParameters = Utils.ntrulprimeParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new NTRULPRimePrivateKeyParameters(nTRULPRimeParameters, ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(0)).getOctets(), ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets(), ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(2)).getOctets(), ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(3)).getOctets());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_sntruprime)) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)privateKeyInfo.parsePrivateKey());
            SNTRUPrimeParameters sNTRUPrimeParameters = Utils.sntruprimeParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new SNTRUPrimePrivateKeyParameters(sNTRUPrimeParameters, ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(0)).getOctets(), ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets(), ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(2)).getOctets(), ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(3)).getOctets(), ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(4)).getOctets());
        }
        if (Utils.mldsaParams.containsKey(aSN1ObjectIdentifier)) {
            ASN1OctetString aSN1OctetString = PrivateKeyFactory.parseOctetString((ASN1OctetString)privateKeyInfo.getPrivateKey(), (int)32);
            MLDSAParameters mLDSAParameters = Utils.mldsaParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            if (aSN1OctetString instanceof DEROctetString) {
                byte[] byArray = ASN1OctetString.getInstance((Object)aSN1OctetString).getOctets();
                if (privateKeyInfo.getPublicKeyData() != null) {
                    MLDSAPublicKeyParameters mLDSAPublicKeyParameters = PublicKeyFactory.MLDSAConverter.getPublicKeyParams((MLDSAParameters)mLDSAParameters, (ASN1BitString)privateKeyInfo.getPublicKeyData());
                    return new MLDSAPrivateKeyParameters(mLDSAParameters, byArray, mLDSAPublicKeyParameters);
                }
                return new MLDSAPrivateKeyParameters(mLDSAParameters, byArray);
            }
            throw new IOException("not supported");
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)BCObjectIdentifiers.dilithium2) || aSN1ObjectIdentifier.equals((ASN1Primitive)BCObjectIdentifiers.dilithium3) || aSN1ObjectIdentifier.equals((ASN1Primitive)BCObjectIdentifiers.dilithium5)) {
            ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
            DilithiumParameters dilithiumParameters = Utils.dilithiumParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            if (aSN1Encodable instanceof ASN1Sequence) {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)aSN1Encodable);
                int n = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0)).intValueExact();
                if (n != 0) {
                    throw new IOException("unknown private key version: " + n);
                }
                if (privateKeyInfo.getPublicKeyData() != null) {
                    DilithiumPublicKeyParameters dilithiumPublicKeyParameters = PublicKeyFactory.DilithiumConverter.getPublicKeyParams((DilithiumParameters)dilithiumParameters, (ASN1BitString)privateKeyInfo.getPublicKeyData());
                    return new DilithiumPrivateKeyParameters(dilithiumParameters, ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(2)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(3)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(4)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(5)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(6)).getOctets(), dilithiumPublicKeyParameters.getT1());
                }
                return new DilithiumPrivateKeyParameters(dilithiumParameters, ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(2)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(3)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(4)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(5)).getOctets(), ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(6)).getOctets(), null);
            }
            if (aSN1Encodable instanceof DEROctetString) {
                byte[] byArray = ASN1OctetString.getInstance((Object)aSN1Encodable).getOctets();
                if (privateKeyInfo.getPublicKeyData() != null) {
                    DilithiumPublicKeyParameters dilithiumPublicKeyParameters = PublicKeyFactory.DilithiumConverter.getPublicKeyParams((DilithiumParameters)dilithiumParameters, (ASN1BitString)privateKeyInfo.getPublicKeyData());
                    return new DilithiumPrivateKeyParameters(dilithiumParameters, byArray, dilithiumPublicKeyParameters);
                }
                return new DilithiumPrivateKeyParameters(dilithiumParameters, byArray, null);
            }
            throw new IOException("not supported");
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)BCObjectIdentifiers.falcon_512) || aSN1ObjectIdentifier.equals((ASN1Primitive)BCObjectIdentifiers.falcon_1024)) {
            FalconPrivateKey falconPrivateKey = FalconPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
            FalconParameters falconParameters = Utils.falconParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new FalconPrivateKeyParameters(falconParameters, falconPrivateKey.getf(), falconPrivateKey.getG(), falconPrivateKey.getF(), falconPrivateKey.getPublicKey().getH());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_bike)) {
            byte[] byArray = ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets();
            BIKEParameters bIKEParameters = Utils.bikeParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            byte[] byArray3 = Arrays.copyOfRange((byte[])byArray, (int)0, (int)bIKEParameters.getRByte());
            byte[] byArray4 = Arrays.copyOfRange((byte[])byArray, (int)bIKEParameters.getRByte(), (int)(2 * bIKEParameters.getRByte()));
            byte[] byArray5 = Arrays.copyOfRange((byte[])byArray, (int)(2 * bIKEParameters.getRByte()), (int)byArray.length);
            return new BIKEPrivateKeyParameters(bIKEParameters, byArray3, byArray4, byArray5);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_hqc)) {
            byte[] byArray = ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets();
            HQCParameters hQCParameters = Utils.hqcParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new HQCPrivateKeyParameters(hQCParameters, byArray);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.rainbow)) {
            byte[] byArray = ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets();
            RainbowParameters rainbowParameters = Utils.rainbowParamsLookup((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            return new RainbowPrivateKeyParameters(rainbowParameters, byArray);
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)PQCObjectIdentifiers.xmss)) {
            XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance((Object)algorithmIdentifier.getParameters());
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = xMSSKeyParams.getTreeDigest().getAlgorithm();
            XMSSPrivateKey xMSSPrivateKey = XMSSPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
            try {
                XMSSPrivateKeyParameters.Builder builder = new XMSSPrivateKeyParameters.Builder(new XMSSParameters(xMSSKeyParams.getHeight(), Utils.getDigest((ASN1ObjectIdentifier)aSN1ObjectIdentifier2))).withIndex(xMSSPrivateKey.getIndex()).withSecretKeySeed(xMSSPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKey.getPublicSeed()).withRoot(xMSSPrivateKey.getRoot());
                if (xMSSPrivateKey.getVersion() != 0) {
                    builder.withMaxIndex(xMSSPrivateKey.getMaxIndex());
                }
                if (xMSSPrivateKey.getBdsState() != null) {
                    BDS bDS = (BDS)XMSSUtil.deserialize((byte[])xMSSPrivateKey.getBdsState(), BDS.class);
                    builder.withBDSState(bDS.withWOTSDigest(aSN1ObjectIdentifier2));
                }
                return builder.build();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
            }
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)PQCObjectIdentifiers.xmss_mt)) {
            XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance((Object)algorithmIdentifier.getParameters());
            ASN1ObjectIdentifier aSN1ObjectIdentifier3 = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
            try {
                XMSSMTPrivateKey xMSSMTPrivateKey = XMSSMTPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
                XMSSMTPrivateKeyParameters.Builder builder = new XMSSMTPrivateKeyParameters.Builder(new XMSSMTParameters(xMSSMTKeyParams.getHeight(), xMSSMTKeyParams.getLayers(), Utils.getDigest((ASN1ObjectIdentifier)aSN1ObjectIdentifier3))).withIndex(xMSSMTPrivateKey.getIndex()).withSecretKeySeed(xMSSMTPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSMTPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSMTPrivateKey.getPublicSeed()).withRoot(xMSSMTPrivateKey.getRoot());
                if (xMSSMTPrivateKey.getVersion() != 0) {
                    builder.withMaxIndex(xMSSMTPrivateKey.getMaxIndex());
                }
                if (xMSSMTPrivateKey.getBdsState() != null) {
                    BDSStateMap bDSStateMap = (BDSStateMap)XMSSUtil.deserialize((byte[])xMSSMTPrivateKey.getBdsState(), BDSStateMap.class);
                    builder.withBDSState(bDSStateMap.withWOTSDigest(aSN1ObjectIdentifier3));
                }
                return builder.build();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
            }
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)PQCObjectIdentifiers.mcElieceCca2)) {
            McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = McElieceCCA2PrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
            return new McElieceCCA2PrivateKeyParameters(mcElieceCCA2PrivateKey.getN(), mcElieceCCA2PrivateKey.getK(), mcElieceCCA2PrivateKey.getField(), mcElieceCCA2PrivateKey.getGoppaPoly(), mcElieceCCA2PrivateKey.getP(), Utils.getDigestName((ASN1ObjectIdentifier)mcElieceCCA2PrivateKey.getDigest().getAlgorithm()));
        }
        throw new RuntimeException("algorithm identifier in private key not recognised");
    }

    private static ASN1OctetString parseOctetString(ASN1OctetString aSN1OctetString, int n) throws IOException {
        byte[] byArray = aSN1OctetString.getOctets();
        if (byArray.length == n) {
            return aSN1OctetString;
        }
        if ((byArray = Utils.readOctetString((byte[])byArray)) != null) {
            return new DEROctetString(byArray);
        }
        return aSN1OctetString;
    }

    private static short[] convert(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i != sArray.length; ++i) {
            sArray[i] = Pack.littleEndianToShort((byte[])byArray, (int)(i * 2));
        }
        return sArray;
    }
}

