/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import jsat.DataStore;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.SparseVector;
import jsat.linear.Vec;
import jsat.math.OnLineStatistics;

public class RowMajorStore
implements DataStore {
    protected List<DataPoint> datapoints;
    protected int num_numeric = 0;
    protected int num_cat = 0;
    protected CategoricalData[] cat_info;

    public RowMajorStore() {
        this(0, null);
    }

    public RowMajorStore(int numNumeric, CategoricalData[] cat_info) {
        this.num_numeric = numNumeric;
        this.cat_info = cat_info;
        this.num_cat = cat_info == null ? 0 : cat_info.length;
        this.datapoints = new ArrayList<DataPoint>();
    }

    public RowMajorStore(List<DataPoint> collection) {
        this(collection.get(0).numNumericalValues(), collection.get(0).getCategoricalData());
        for (DataPoint dp : collection) {
            this.addDataPoint(dp);
        }
    }

    public RowMajorStore(RowMajorStore toCopy) {
        this.datapoints = new ArrayList<DataPoint>(toCopy.datapoints);
        if (toCopy.cat_info != null) {
            this.cat_info = CategoricalData.copyOf(toCopy.cat_info);
        }
        this.num_cat = toCopy.num_cat;
        this.num_numeric = toCopy.numNumeric();
    }

    @Override
    public void addDataPoint(DataPoint dp) {
        this.datapoints.add(dp);
        this.num_numeric = Math.max(dp.getNumericalValues().length(), this.num_numeric);
        this.num_cat = Math.max(dp.getCategoricalValues().length, this.num_cat);
    }

    @Override
    public CategoricalData[] getCategoricalDataInfo() {
        return this.cat_info;
    }

    @Override
    public DataPoint getDataPoint(int i) {
        return this.datapoints.get(i);
    }

    @Override
    public void setDataPoint(int i, DataPoint dp) {
        this.datapoints.set(i, dp);
    }

    @Override
    public void finishAdding() {
        for (int i = 0; i < this.datapoints.size(); ++i) {
            int[] c;
            Vec v;
            DataPoint d = this.datapoints.get(i);
            Vec nv = v = d.getNumericalValues();
            v.setLength(this.num_numeric);
            int[] nc = c = d.getCategoricalValues();
            if (d.numCategoricalValues() < this.num_cat) {
                nc = Arrays.copyOf(c, this.num_cat);
                for (int j = c.length; j < nc.length; ++j) {
                    nc[j] = -1;
                }
            }
            if (v == nv && c == nc) continue;
            this.datapoints.set(i, new DataPoint(nv, nc, this.cat_info));
        }
    }

    @Override
    public int size() {
        return this.datapoints.size();
    }

    @Override
    public Vec[] getNumericColumns(Set<Integer> skipColumns) {
        int i;
        boolean sparse = this.getSparsityStats().getMean() < 0.6;
        Vec[] cols = new Vec[this.numNumeric()];
        for (i = 0; i < cols.length; ++i) {
            if (skipColumns.contains(i)) continue;
            cols[i] = sparse ? new SparseVector(this.size()) : new DenseVector(this.size());
        }
        for (i = 0; i < this.size(); ++i) {
            Vec v = this.getDataPoint(i).getNumericalValues();
            for (IndexValue iv : v) {
                int col = iv.getIndex();
                if (cols[col] == null) continue;
                cols[col].set(i, iv.getValue());
            }
        }
        return cols;
    }

    @Override
    public void setCategoricalDataInfo(CategoricalData[] cat_info) {
        this.cat_info = cat_info;
        this.num_cat = cat_info.length;
    }

    @Override
    public int numNumeric() {
        return this.num_numeric;
    }

    @Override
    public void setNumNumeric(int d) {
        if (d < 0) {
            throw new RuntimeException("Can not store a negative number of features (" + d + ")");
        }
        this.num_numeric = d;
    }

    @Override
    public int numCategorical() {
        return this.num_cat;
    }

    @Override
    public OnLineStatistics getSparsityStats() {
        OnLineStatistics stats = new OnLineStatistics();
        for (int i = 0; i < this.size(); ++i) {
            Vec v = this.getDataPoint(i).getNumericalValues();
            if (v.isSparse()) {
                stats.add((double)v.nnz() / (double)v.length());
                continue;
            }
            stats.add(1.0);
        }
        return stats;
    }

    @Override
    public RowMajorStore clone() {
        return new RowMajorStore(this);
    }

    @Override
    public RowMajorStore emptyClone() {
        return new RowMajorStore(this.num_numeric, this.cat_info);
    }

    @Override
    public int[] getCatColumn(int i) {
        if (i < 0 || i >= this.numCategorical()) {
            throw new IndexOutOfBoundsException("There is no index for column " + i);
        }
        int[] toRet = new int[this.size()];
        for (int z = 0; z < this.size(); ++z) {
            toRet[z] = this.datapoints.get(z).getCategoricalValue(i);
        }
        return toRet;
    }
}

