/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.DataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.classifiers.trees.ImpurityScore;
import jsat.exceptions.FailedToFitException;
import jsat.linear.Vec;
import jsat.math.OnLineStatistics;
import jsat.parameters.Parameterized;
import jsat.regression.RegressionDataSet;
import jsat.regression.Regressor;
import jsat.utils.DoubleList;
import jsat.utils.FakeExecutor;
import jsat.utils.IntList;
import jsat.utils.IntSet;
import jsat.utils.PairedReturn;
import jsat.utils.QuickSort;
import jsat.utils.concurrent.AtomicDouble;
import jsat.utils.concurrent.ParallelUtils;

public class DecisionStump
implements Classifier,
Regressor,
Parameterized {
    private static final long serialVersionUID = -2849268862089019514L;
    private int splittingAttribute;
    private CategoricalData predicting;
    private CategoricalData[] catAttributes;
    private int numNumericFeatures;
    private List<Double> boundries;
    private List<Integer> owners;
    private CategoricalResults[] results;
    protected double[] pathRatio;
    private double[] regressionResults;
    private ImpurityScore.ImpurityMeasure gainMethod = ImpurityScore.ImpurityMeasure.INFORMATION_GAIN_RATIO;
    private boolean removeContinuousAttributes = false;
    private int minResultSplitSize = 10;
    private static final double almost0 = 1.0E-6;
    private static final double almost1 = 0.999999;

    public void setRemoveContinuousAttributes(boolean removeContinuousAttributes) {
        this.removeContinuousAttributes = removeContinuousAttributes;
    }

    public void setGainMethod(ImpurityScore.ImpurityMeasure gainMethod) {
        this.gainMethod = gainMethod;
    }

    public ImpurityScore.ImpurityMeasure getGainMethod() {
        return this.gainMethod;
    }

    protected int numNumeric() {
        return this.numNumericFeatures;
    }

    protected int numCategorical() {
        return this.catAttributes.length;
    }

    public void setMinResultSplitSize(int minResultSplitSize) {
        if (minResultSplitSize <= 1) {
            throw new ArithmeticException("Min split size must be a positive value ");
        }
        this.minResultSplitSize = minResultSplitSize;
    }

    public int getMinResultSplitSize() {
        return this.minResultSplitSize;
    }

    public int getSplittingAttribute() {
        if (this.splittingAttribute < this.catAttributes.length) {
            return this.numNumericFeatures + this.splittingAttribute;
        }
        int numerAttribute = this.splittingAttribute - this.catAttributes.length;
        return numerAttribute;
    }

    public void setPredicting(CategoricalData predicting) {
        this.predicting = predicting;
    }

    @Override
    public double regress(DataPoint data) {
        if (this.regressionResults == null) {
            throw new RuntimeException("Decusion stump has not been trained for regression");
        }
        int path = this.whichPath(data);
        if (path >= 0) {
            return this.regressionResults[path];
        }
        double avg = 0.0;
        for (int i = 0; i < this.pathRatio.length; ++i) {
            avg += this.pathRatio[i] * this.regressionResults[i];
        }
        return avg;
    }

    @Override
    public void train(RegressionDataSet dataSet, boolean parallel) {
        IntSet options = new IntSet(dataSet.getNumFeatures());
        for (int i = 0; i < dataSet.getNumFeatures(); ++i) {
            options.add(Integer.valueOf(i));
        }
        List<RegressionDataSet> split = this.trainR(dataSet, options, parallel);
        if (split == null) {
            throw new FailedToFitException("Tree could not be fit, make sure your data is good. Potentially file a bug");
        }
    }

    protected double getGain(ImpurityScore origScore, ClassificationDataSet source, List<IntList> aSplit) {
        ImpurityScore[] scores = this.getSplitScores(source, aSplit);
        return ImpurityScore.gain(origScore, scores);
    }

    private ImpurityScore[] getSplitScores(ClassificationDataSet source, List<IntList> aSplit) {
        ImpurityScore[] scores = new ImpurityScore[aSplit.size()];
        for (int i = 0; i < aSplit.size(); ++i) {
            scores[i] = this.getClassGainScore(source, aSplit.get(i));
        }
        return scores;
    }

    public int whichPath(DataPoint data) {
        int paths = this.getNumberOfPaths();
        if (paths < 0) {
            return paths;
        }
        if (paths == 1) {
            return 0;
        }
        if (this.splittingAttribute < this.catAttributes.length) {
            return data.getCategoricalValue(this.splittingAttribute);
        }
        int numerAttribute = this.splittingAttribute - this.catAttributes.length;
        double val = data.getNumericalValues().get(numerAttribute);
        if (Double.isNaN(val)) {
            return -1;
        }
        if (this.results != null) {
            int pos = Collections.binarySearch(this.boundries, val);
            pos = pos < 0 ? -pos - 1 : pos;
            return this.owners.get(pos);
        }
        if (this.regressionResults.length == 1) {
            return 0;
        }
        if (val <= this.regressionResults[2]) {
            return 0;
        }
        return 1;
    }

    public int getNumberOfPaths() {
        if (this.results != null) {
            return this.results.length;
        }
        if (this.catAttributes != null) {
            if (this.regressionResults.length == 1) {
                return 1;
            }
            if (this.splittingAttribute < this.catAttributes.length) {
                return this.catAttributes[this.splittingAttribute].getNumOfCategories();
            }
            return 2;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        if (this.results == null) {
            throw new RuntimeException("DecisionStump has not been trained for classification");
        }
        int path = this.whichPath(data);
        if (path >= 0) {
            return this.results[path];
        }
        Vec tmp = this.results[0].getVecView().clone();
        tmp.mutableMultiply(this.pathRatio[0]);
        for (int i = 1; i < this.results.length; ++i) {
            tmp.mutableAdd(this.pathRatio[i], this.results[i].getVecView());
        }
        return new CategoricalResults(tmp.arrayCopy());
    }

    public CategoricalResults result(int i) {
        if (i < 0 || i >= this.getNumberOfPaths()) {
            throw new IndexOutOfBoundsException("Invalid path, can to return a result for path " + i);
        }
        return this.results[i];
    }

    @Override
    public void train(ClassificationDataSet dataSet, boolean parallel) {
        IntSet splitOptions = new IntSet(dataSet.getNumFeatures());
        for (int i = 0; i < dataSet.getNumFeatures(); ++i) {
            splitOptions.add(Integer.valueOf(i));
        }
        this.predicting = dataSet.getPredicting();
        this.trainC(dataSet, splitOptions, parallel);
    }

    public List<ClassificationDataSet> trainC(ClassificationDataSet dataPoints, Set<Integer> options) {
        return this.trainC(dataPoints, options, false);
    }

    public List<ClassificationDataSet> trainC(ClassificationDataSet data, Set<Integer> options, boolean parallel) {
        if (this.predicting == null) {
            throw new RuntimeException("Predicting value has not been set");
        }
        this.catAttributes = data.getCategories();
        this.numNumericFeatures = data.getNumNumericalVars();
        ImpurityScore origScoreObj = this.getClassGainScore(data);
        double origScore = origScoreObj.getScore();
        if (origScore == 0.0 || data.size() < this.minResultSplitSize * 2) {
            this.results = new CategoricalResults[1];
            this.results[0] = new CategoricalResults(this.predicting.getNumOfCategories());
            this.results[0].setProb(data.getDataPointCategory(0), 1.0);
            this.pathRatio = new double[]{0.0};
            ArrayList<ClassificationDataSet> toReturn = new ArrayList<ClassificationDataSet>();
            toReturn.add(data);
            return toReturn;
        }
        List<ClassificationDataSet> bestSplit = Collections.synchronizedList(new ArrayList());
        AtomicDouble bestGain = new AtomicDouble(-1.0);
        DoubleList bestRatio = new DoubleList();
        this.splittingAttribute = -1;
        CountDownLatch latch = new CountDownLatch(options.size());
        ThreadLocal<ClassificationDataSet> localList = ThreadLocal.withInitial(() -> data.shallowClone());
        ExecutorService ex = parallel ? ParallelUtils.CACHED_THREAD_POOL : new FakeExecutor();
        for (int attribute_to_consider : options) {
            ex.submit(() -> {
                try {
                    double gain;
                    List<ClassificationDataSet> aSplit;
                    ClassificationDataSet DPs = (ClassificationDataSet)localList.get();
                    int attribute = attribute_to_consider;
                    double[] gainRet = new double[]{Double.NaN};
                    gainRet[0] = Double.NaN;
                    PairedReturn<List<Double>, List<Integer>> tmp = null;
                    ImpurityScore[] split_scores = null;
                    double weightScale = 1.0;
                    if (attribute < this.catAttributes.length) {
                        aSplit = DecisionStump.listOfLists(data, this.catAttributes[attribute].getNumOfCategories());
                        split_scores = new ImpurityScore[aSplit.size()];
                        for (int i = 0; i < split_scores.length; ++i) {
                            split_scores[i] = new ImpurityScore(this.predicting.getNumOfCategories(), this.gainMethod);
                        }
                        IntList wasMissing = new IntList();
                        double missingSum = 0.0;
                        for (int i = 0; i < data.size(); ++i) {
                            int val = data.getDataPoint(i).getCategoricalValue(attribute);
                            double weight = data.getWeight(i);
                            if (val >= 0) {
                                aSplit.get(val).addDataPoint(data.getDataPoint(i), data.getDataPointCategory(i), weight);
                                split_scores[val].addPoint(weight, data.getDataPointCategory(i));
                                continue;
                            }
                            wasMissing.add(i);
                            missingSum += weight;
                        }
                        int pathsTaken = 0;
                        for (ClassificationDataSet split : aSplit) {
                            if (split.size() <= 0) continue;
                            ++pathsTaken;
                        }
                        if (pathsTaken <= 1) {
                            latch.countDown();
                            return;
                        }
                        if (missingSum > 0.0) {
                            double newSum = origScoreObj.getSumOfWeights() - missingSum;
                            weightScale = newSum / origScoreObj.getSumOfWeights();
                            double[] fracs = new double[split_scores.length];
                            for (int i = 0; i < fracs.length; ++i) {
                                fracs[i] = split_scores[i].getSumOfWeights() / newSum;
                            }
                            DecisionStump.distributMissing(aSplit, fracs, data, wasMissing);
                        }
                    } else {
                        int N = this.predicting.getNumOfCategories();
                        tmp = this.createNumericCSplit(DPs, N, attribute -= this.catAttributes.length, aSplit = DecisionStump.listOfLists(data, 2), origScoreObj, gainRet, split_scores = new ImpurityScore[2]);
                        if (tmp == null) {
                            latch.countDown();
                            return;
                        }
                        attribute += this.catAttributes.length;
                    }
                    if (!Double.isNaN(gainRet[0])) {
                        gain = gainRet[0];
                    } else {
                        if (split_scores == null) {
                            split_scores = this.getClassGainScore(aSplit);
                        }
                        gain = ImpurityScore.gain(origScoreObj, weightScale, split_scores);
                    }
                    if (gain > bestGain.get()) {
                        DoubleList doubleList = bestRatio;
                        synchronized (doubleList) {
                            if (gain > bestGain.get()) {
                                int i;
                                bestGain.set(gain);
                                this.splittingAttribute = attribute;
                                bestSplit.clear();
                                bestSplit.addAll(aSplit);
                                bestRatio.clear();
                                double sum = 1.0E-8;
                                for (i = 0; i < split_scores.length; ++i) {
                                    sum += split_scores[i].getSumOfWeights();
                                    bestRatio.add(split_scores[i].getSumOfWeights());
                                }
                                for (i = 0; i < split_scores.length; ++i) {
                                    bestRatio.set(i, bestRatio.getD(i) / sum);
                                }
                                if (attribute >= this.catAttributes.length) {
                                    this.boundries = tmp.getFirstItem();
                                    this.owners = tmp.getSecondItem();
                                }
                            }
                        }
                    }
                    latch.countDown();
                }
                catch (Exception easx) {
                    easx.printStackTrace();
                    System.out.println();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex1) {
            Logger.getLogger(DecisionStump.class.getName()).log(Level.SEVERE, null, ex1);
            throw new FailedToFitException(ex1);
        }
        if (this.splittingAttribute == -1) {
            bestSplit.clear();
            bestSplit.add(data);
            CategoricalResults badResult = new CategoricalResults(data.getPriors());
            this.results = new CategoricalResults[]{badResult};
            this.pathRatio = new double[]{1.0};
            return bestSplit;
        }
        if (this.splittingAttribute < this.catAttributes.length || this.removeContinuousAttributes) {
            options.remove(this.splittingAttribute);
        }
        this.results = new CategoricalResults[bestSplit.size()];
        this.pathRatio = bestRatio.getVecView().arrayCopy();
        for (int i = 0; i < bestSplit.size(); ++i) {
            this.results[i] = new CategoricalResults(bestSplit.get(i).getPriors());
        }
        return bestSplit;
    }

    private PairedReturn<List<Double>, List<Integer>> createNumericCSplit(ClassificationDataSet dataPoints, int N, int attribute, List<ClassificationDataSet> aSplit, ImpurityScore origScore, double[] finalGain, ImpurityScore[] subScores) {
        int i;
        int indx;
        int i2;
        double[] vals = new double[dataPoints.size()];
        IntList workSet = new IntList(dataPoints.size());
        IntList wasNaN = new IntList();
        for (int i3 = 0; i3 < dataPoints.size(); ++i3) {
            double val = dataPoints.getDataPoint(i3).getNumericalValues().get(attribute);
            if (!Double.isNaN(val)) {
                vals[i3 - wasNaN.size()] = val;
                workSet.add(i3);
                continue;
            }
            wasNaN.add(i3);
        }
        if (workSet.size() < this.minResultSplitSize * 2) {
            return null;
        }
        List<List<?>> paired = Arrays.asList(workSet);
        QuickSort.sort(vals, 0, vals.length - wasNaN.size(), paired);
        double bestGain = Double.NEGATIVE_INFINITY;
        double bestSplit = Double.NEGATIVE_INFINITY;
        int splitIndex = -1;
        ImpurityScore rightSide = origScore.clone();
        ImpurityScore leftSide = new ImpurityScore(N, this.gainMethod);
        double nanWeightRemoved = 0.0;
        Iterator iterator = wasNaN.iterator();
        while (iterator.hasNext()) {
            int i4 = (Integer)iterator.next();
            double weight = dataPoints.getWeight(i4);
            int truth = dataPoints.getDataPointCategory(i4);
            nanWeightRemoved += weight;
            rightSide.removePoint(weight, truth);
        }
        double wholeRescale = rightSide.getSumOfWeights() / (rightSide.getSumOfWeights() + nanWeightRemoved);
        for (i2 = 0; i2 < this.minResultSplitSize; ++i2) {
            if (i2 >= dataPoints.size()) {
                System.out.println("WHAT?");
            }
            indx = workSet.getI(i2);
            double weight = dataPoints.getWeight(indx);
            int truth = dataPoints.getDataPointCategory(indx);
            leftSide.addPoint(weight, truth);
            rightSide.removePoint(weight, truth);
        }
        for (i2 = this.minResultSplitSize; i2 < dataPoints.size() - this.minResultSplitSize - 1 - wasNaN.size(); ++i2) {
            indx = workSet.getI(i2);
            double w = dataPoints.getWeight(indx);
            int y = dataPoints.getDataPointCategory(indx);
            rightSide.removePoint(w, y);
            leftSide.addPoint(w, y);
            double leftVal = vals[i2];
            double rightVal = vals[i2 + 1];
            if (rightVal - leftVal < 1.0E-14) continue;
            ImpurityScore[] impurityScoreArray = new ImpurityScore[]{leftSide, rightSide};
            double curGain = ImpurityScore.gain(origScore, wholeRescale, impurityScoreArray);
            if (!(curGain >= bestGain)) continue;
            double curSplit = (leftVal + rightVal) / 2.0;
            bestGain = curGain;
            bestSplit = curSplit;
            splitIndex = i2 + 1;
            subScores[0] = leftSide.clone();
            subScores[1] = rightSide.clone();
        }
        if (splitIndex == -1) {
            return null;
        }
        if (finalGain != null) {
            finalGain[0] = bestGain;
        }
        ClassificationDataSet cds_left = dataPoints.emptyClone();
        ClassificationDataSet cds_right = dataPoints.emptyClone();
        Iterator w = workSet.subList(0, splitIndex).iterator();
        while (w.hasNext()) {
            i = (Integer)w.next();
            cds_left.addDataPoint(dataPoints.getDataPoint(i), dataPoints.getDataPointCategory(i), dataPoints.getWeight(i));
        }
        w = workSet.subList(splitIndex, workSet.size()).iterator();
        while (w.hasNext()) {
            i = (Integer)w.next();
            cds_right.addDataPoint(dataPoints.getDataPoint(i), dataPoints.getDataPointCategory(i), dataPoints.getWeight(i));
        }
        aSplit.set(0, cds_left);
        aSplit.set(1, cds_right);
        if (wasNaN.size() > 0) {
            double weightScale = leftSide.getSumOfWeights() / (leftSide.getSumOfWeights() + rightSide.getSumOfWeights() + 0.0);
            DecisionStump.distributMissing(aSplit, new double[]{weightScale, 1.0 - weightScale}, dataPoints, wasNaN);
        }
        PairedReturn<List<Double>, List<Integer>> tmp = new PairedReturn<List<Double>, List<Integer>>(Arrays.asList(bestSplit, Double.POSITIVE_INFINITY), Arrays.asList(0, 1));
        return tmp;
    }

    protected static <T> void distributMissing(List<ClassificationDataSet> splits, double[] fracs, ClassificationDataSet source, IntList hadMissing) {
        Iterator iterator = hadMissing.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            DataPoint dp = source.getDataPoint(i);
            for (int j = 0; j < fracs.length; ++j) {
                double nw = fracs[j] * source.getWeight(i);
                if (Double.isNaN(nw) || nw <= 1.0E-13) continue;
                splits.get(j).addDataPoint(dp, source.getDataPointCategory(i), nw);
            }
        }
    }

    protected static <T> void distributMissing(List<RegressionDataSet> splits, double[] fracs, RegressionDataSet source, IntList hadMissing) {
        Iterator iterator = hadMissing.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            DataPoint dp = source.getDataPoint(i);
            for (int j = 0; j < fracs.length; ++j) {
                double nw = fracs[j] * source.getWeight(i);
                if (Double.isNaN(nw) || nw <= 1.0E-13) continue;
                splits.get(j).addDataPoint(dp, source.getTargetValue(i), nw);
            }
        }
    }

    public List<RegressionDataSet> trainR(RegressionDataSet dataPoints, Set<Integer> options) {
        return this.trainR(dataPoints, options, false);
    }

    public List<RegressionDataSet> trainR(RegressionDataSet data, Set<Integer> options, boolean parallel) {
        this.catAttributes = data.getCategories();
        this.numNumericFeatures = data.getNumNumericalVars();
        if (data.size() <= this.minResultSplitSize * 2) {
            this.splittingAttribute = this.catAttributes.length;
            this.regressionResults = new double[1];
            double avg = 0.0;
            double sum = 0.0;
            for (int i = 0; i < data.size(); ++i) {
                double weight = data.getWeight(i);
                avg += data.getTargetValue(i) * weight;
                sum += weight;
            }
            this.regressionResults[0] = avg / sum;
            ArrayList<RegressionDataSet> toRet = new ArrayList<RegressionDataSet>(1);
            toRet.add(data);
            return toRet;
        }
        ArrayList<RegressionDataSet> bestSplit = new ArrayList<RegressionDataSet>();
        AtomicDouble lowestSplitSqrdError = new AtomicDouble(Double.MAX_VALUE);
        ThreadLocal<RegressionDataSet> localList = ThreadLocal.withInitial(() -> data.shallowClone());
        ExecutorService ex = parallel ? ParallelUtils.CACHED_THREAD_POOL : new FakeExecutor();
        CountDownLatch latch = new CountDownLatch(options.size());
        Iterator<Integer> weight = options.iterator();
        while (weight.hasNext()) {
            int attribute_to_consider;
            int attribute = attribute_to_consider = weight.next().intValue();
            ex.submit(() -> {
                double[] thisRatio;
                RegressionDataSet DPs = (RegressionDataSet)localList.get();
                List<RegressionDataSet> thisSplit = null;
                double thisSplitSqrdErr = Double.MAX_VALUE;
                double[] thisMeans = null;
                if (attribute < this.catAttributes.length) {
                    int i;
                    thisSplit = DecisionStump.listOfLists(DPs, this.catAttributes[attribute].getNumOfCategories());
                    OnLineStatistics[] stats = new OnLineStatistics[thisSplit.size()];
                    thisRatio = new double[thisSplit.size()];
                    for (int i2 = 0; i2 < thisSplit.size(); ++i2) {
                        stats[i2] = new OnLineStatistics();
                    }
                    IntList wasMissing = new IntList();
                    for (int i3 = 0; i3 < DPs.size(); ++i3) {
                        int category = DPs.getDataPoint(i3).getCategoricalValue(attribute);
                        if (category >= 0) {
                            thisSplit.get(category).addDataPoint(DPs.getDataPoint(i3), DPs.getTargetValue(i3), DPs.getWeight(i3));
                            stats[category].add(DPs.getTargetValue(i3), DPs.getWeight(i3));
                            continue;
                        }
                        wasMissing.add(i3);
                    }
                    thisMeans = new double[stats.length];
                    thisSplitSqrdErr = 0.0;
                    double sum = 0.0;
                    for (i = 0; i < stats.length; ++i) {
                        thisRatio[i] = stats[i].getSumOfWeights();
                        sum += thisRatio[i];
                        thisSplitSqrdErr += stats[i].getVarance() * stats[i].getSumOfWeights();
                        thisMeans[i] = stats[i].getMean();
                    }
                    i = 0;
                    while (i < stats.length) {
                        int n = i++;
                        thisRatio[n] = thisRatio[n] / sum;
                    }
                    if (!wasMissing.isEmpty()) {
                        DecisionStump.distributMissing(thisSplit, thisRatio, DPs, wasMissing);
                    }
                } else {
                    int numAttri = attribute - this.catAttributes.length;
                    OnLineStatistics rightSide = new OnLineStatistics();
                    OnLineStatistics leftSide = new OnLineStatistics();
                    DoubleList att_vals = new DoubleList(DPs.size());
                    IntList order = new IntList(DPs.size());
                    DoubleList weights = new DoubleList(DPs.size());
                    DoubleList targets = new DoubleList(DPs.size());
                    IntList wasNaN = new IntList();
                    for (int i = 0; i < DPs.size(); ++i) {
                        double v = DPs.getDataPoint(i).getNumericalValues().get(numAttri);
                        if (Double.isNaN(v)) {
                            wasNaN.add(i);
                            continue;
                        }
                        rightSide.add(DPs.getTargetValue(i), DPs.getWeight(i));
                        att_vals.add(v);
                        order.add(i);
                        weights.add(DPs.getWeight(i));
                        targets.add(DPs.getTargetValue(i));
                    }
                    QuickSort.sort(att_vals.getBackingArray(), 0, att_vals.size(), Arrays.asList(order, weights, targets));
                    int bestS = 0;
                    thisSplitSqrdErr = Double.POSITIVE_INFINITY;
                    double allWeight = rightSide.getSumOfWeights();
                    thisMeans = new double[3];
                    thisRatio = new double[2];
                    for (int i = 0; i < att_vals.size(); ++i) {
                        double weight = weights.getD(i);
                        double val = targets.getD(i);
                        rightSide.remove(val, weight);
                        leftSide.add(val, weight);
                        if (i < this.minResultSplitSize) continue;
                        if (i > att_vals.size() - this.minResultSplitSize) break;
                        double tmpSVariance = rightSide.getVarance() * rightSide.getSumOfWeights() + leftSide.getVarance() * leftSide.getSumOfWeights();
                        if (!(tmpSVariance < thisSplitSqrdErr) || Double.isInfinite(tmpSVariance)) continue;
                        thisSplitSqrdErr = tmpSVariance;
                        bestS = i;
                        thisMeans[0] = leftSide.getMean();
                        thisMeans[1] = rightSide.getMean();
                        thisMeans[2] = (att_vals.get(bestS) + att_vals.get(bestS + 1)) / 2.0;
                        thisRatio[0] = leftSide.getSumOfWeights() / allWeight;
                        thisRatio[1] = rightSide.getSumOfWeights() / allWeight;
                    }
                    if (att_vals.size() >= this.minResultSplitSize) {
                        thisSplit = DecisionStump.listOfLists(DPs, 2);
                        Iterator iterator = order.subList(0, bestS).iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            thisSplit.get(0).addDataPoint(DPs.getDataPoint(i), DPs.getTargetValue(i), DPs.getWeight(i));
                        }
                        iterator = order.subList(bestS + 1, order.size()).iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            thisSplit.get(1).addDataPoint(DPs.getDataPoint(i), DPs.getTargetValue(i), DPs.getWeight(i));
                        }
                        if (wasNaN.size() > 0) {
                            DecisionStump.distributMissing(thisSplit, thisRatio, DPs, wasNaN);
                        }
                    } else {
                        thisSplitSqrdErr = Double.NEGATIVE_INFINITY;
                    }
                }
                if (Math.abs(thisSplitSqrdErr) < 1.0E-13) {
                    thisSplitSqrdErr = Math.abs(thisSplitSqrdErr);
                }
                if (thisSplitSqrdErr >= 0.0 && thisSplitSqrdErr < lowestSplitSqrdError.get()) {
                    List list = bestSplit;
                    synchronized (list) {
                        if (thisSplitSqrdErr < lowestSplitSqrdError.get()) {
                            lowestSplitSqrdError.set(thisSplitSqrdErr);
                            bestSplit.clear();
                            bestSplit.addAll(thisSplit);
                            this.splittingAttribute = attribute;
                            this.regressionResults = thisMeans;
                            this.pathRatio = thisRatio;
                        }
                    }
                }
                latch.countDown();
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex1) {
            Logger.getLogger(DecisionStump.class.getName()).log(Level.SEVERE, null, ex1);
            throw new FailedToFitException(ex1);
        }
        if (this.splittingAttribute < this.catAttributes.length || this.removeContinuousAttributes) {
            options.remove(this.splittingAttribute);
        }
        if (bestSplit.size() == 0) {
            return null;
        }
        return bestSplit;
    }

    private static <T extends DataSet<T>> List<T> listOfLists(T type, int n) {
        ArrayList<DataSet<T>> aSplit = new ArrayList<DataSet<T>>(n);
        for (int i = 0; i < n; ++i) {
            aSplit.add(type.emptyClone());
        }
        return aSplit;
    }

    @Override
    public boolean supportsWeightedData() {
        return true;
    }

    private ImpurityScore getClassGainScore(ClassificationDataSet dataPoints, IntList subset) {
        ImpurityScore cgs = new ImpurityScore(this.predicting.getNumOfCategories(), this.gainMethod);
        Iterator iterator = subset.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            cgs.addPoint(dataPoints.getWeight(i), dataPoints.getDataPointCategory(i));
        }
        return cgs;
    }

    private ImpurityScore[] getClassGainScore(List<ClassificationDataSet> splits) {
        ImpurityScore[] toRet = new ImpurityScore[splits.size()];
        for (int i = 0; i < toRet.length; ++i) {
            toRet[i] = this.getClassGainScore(splits.get(i));
        }
        return toRet;
    }

    private ImpurityScore getClassGainScore(ClassificationDataSet dataPoints) {
        ImpurityScore cgs = new ImpurityScore(this.predicting.getNumOfCategories(), this.gainMethod);
        for (int i = 0; i < dataPoints.size(); ++i) {
            cgs.addPoint(dataPoints.getWeight(i), dataPoints.getDataPointCategory(i));
        }
        return cgs;
    }

    @Override
    public DecisionStump clone() {
        DecisionStump copy = new DecisionStump();
        if (this.catAttributes != null) {
            copy.catAttributes = CategoricalData.copyOf(this.catAttributes);
        }
        if (this.results != null) {
            copy.results = new CategoricalResults[this.results.length];
            for (int i = 0; i < this.results.length; ++i) {
                copy.results[i] = this.results[i].clone();
            }
        }
        copy.removeContinuousAttributes = this.removeContinuousAttributes;
        copy.splittingAttribute = this.splittingAttribute;
        if (this.boundries != null) {
            copy.boundries = new DoubleList(this.boundries);
        }
        if (this.owners != null) {
            copy.owners = new IntList(this.owners);
        }
        if (this.predicting != null) {
            copy.predicting = this.predicting.clone();
        }
        if (this.regressionResults != null) {
            copy.regressionResults = Arrays.copyOf(this.regressionResults, this.regressionResults.length);
        }
        if (this.pathRatio != null) {
            copy.pathRatio = Arrays.copyOf(this.pathRatio, this.pathRatio.length);
        }
        copy.minResultSplitSize = this.minResultSplitSize;
        copy.gainMethod = this.gainMethod;
        copy.numNumericFeatures = this.numNumericFeatures;
        return copy;
    }
}

