/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.Arrays;
import jsat.DataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.linear.Matrix;
import jsat.linear.Vec;

public class ProjectionTransform
implements DataTransform {
    protected Matrix P;
    protected Vec b;

    public ProjectionTransform(Matrix P, Vec b) {
        this.P = P;
        this.b = b;
    }

    public ProjectionTransform(ProjectionTransform toClone) {
        this(toClone.P.clone(), toClone.b.clone());
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        Vec x_new = this.P.multiply(dp.getNumericalValues());
        x_new.mutableAdd(this.b);
        DataPoint newDP = new DataPoint(x_new, Arrays.copyOf(dp.getCategoricalValues(), dp.numCategoricalValues()), CategoricalData.copyOf(dp.getCategoricalData()));
        return newDP;
    }

    @Override
    public void fit(DataSet data) {
    }

    @Override
    public ProjectionTransform clone() {
        return new ProjectionTransform(this);
    }
}

