/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.discrete;

import jsat.distributions.discrete.DiscreteDistribution;
import jsat.math.SpecialMath;

public class Binomial
extends DiscreteDistribution {
    private int trials;
    private double p;

    public Binomial() {
        this(1, 0.5);
    }

    public Binomial(int trials, double p) {
        this.setTrials(trials);
        this.setP(p);
    }

    public void setTrials(int trials) {
        if (trials < 1) {
            throw new IllegalArgumentException("number of trials must be positive, not " + trials);
        }
        this.trials = trials;
    }

    public int getTrials() {
        return this.trials;
    }

    public void setP(double p) {
        if (Double.isNaN(p) || p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("probability of success must be in [0, 1], not " + p);
        }
        this.p = p;
    }

    public double getP() {
        return this.p;
    }

    @Override
    public double logPmf(int x) {
        if (x > this.trials || x < 0) {
            return -1.7976931348623157E308;
        }
        int n = this.trials;
        return (double)n * Math.log(1.0 - this.p) - SpecialMath.lnGamma(n - x + 1) + SpecialMath.lnGamma(n + 1) - (double)x * Math.log(1.0 - this.p) + (double)x * Math.log(this.p) - SpecialMath.lnGamma(x + 1);
    }

    @Override
    public double pmf(int x) {
        if (x > this.trials || x < 0) {
            return 0.0;
        }
        return Math.exp(this.logPmf(x));
    }

    @Override
    public double cdf(int x) {
        if (x >= this.trials) {
            return 1.0;
        }
        if (x < 0) {
            return 0.0;
        }
        return SpecialMath.betaIncReg(1.0 - this.p, this.trials - x, 1 + x);
    }

    @Override
    public double mean() {
        return (double)this.trials * this.p;
    }

    @Override
    public double median() {
        if (Math.abs(this.p - 0.5) < 0.001) {
            return this.trials / 2;
        }
        if (this.p <= 1.0 - Math.log(2.0) || this.p >= Math.log(2.0)) {
            return Math.round((double)this.trials * this.p);
        }
        return this.invCdf(0.5);
    }

    @Override
    public double mode() {
        if (this.p == 1.0) {
            return this.trials;
        }
        return Math.floor((double)(this.trials + 1) * this.p);
    }

    @Override
    public double variance() {
        return (double)this.trials * this.p * (1.0 - this.p);
    }

    @Override
    public double skewness() {
        return (1.0 - 2.0 * this.p) / this.standardDeviation();
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return this.trials;
    }

    @Override
    public Binomial clone() {
        return new Binomial(this.trials, this.p);
    }
}

