/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.discrete;

import jsat.distributions.Distribution;
import jsat.math.Function1D;
import jsat.math.rootfinding.Zeroin;

public abstract class DiscreteDistribution
extends Distribution {
    public double logPmf(int x) {
        double pmf = this.pmf(x);
        if (pmf <= 0.0) {
            return -1.7976931348623157E308;
        }
        return Math.log(pmf);
    }

    public abstract double pmf(int var1);

    public abstract double cdf(int var1);

    @Override
    public double cdf(double x) {
        return this.cdf((int)Math.floor(x));
    }

    @Override
    public double invCdf(double p) {
        return this.invCdfRootFinding(p, 1.0E-6);
    }

    protected double invCdfRootFinding(double p, double tol) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Value of p must be in the range [0,1], not " + p);
        }
        if (this.min() >= -2.147483648E9 && p <= this.cdf(this.min())) {
            return this.min();
        }
        if (this.max() < 2.147483647E9 && p > this.cdf(this.max() - 1.0)) {
            return this.max();
        }
        Function1D cdfInterpolated = x -> {
            double query = x;
            if (Math.rint(query) == query) {
                return this.cdf((int)query) - p;
            }
            double larger = query + 1.0;
            double diff = larger - query;
            return this.cdf(query) * diff + this.cdf(larger) * (1.0 - diff) - p;
        };
        double a = Double.isInfinite(this.min()) ? -2.0401094656E9 : this.min();
        double b = Double.isInfinite(this.max()) ? 2.0401094646499999E9 : this.max();
        double toRet = Zeroin.root(tol, a, b, cdfInterpolated);
        return Math.round(toRet);
    }

    @Override
    public abstract DiscreteDistribution clone();
}

