/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.multivariate;

import java.io.Serializable;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.linear.DenseVector;
import jsat.linear.Vec;

public interface MultivariateDistribution
extends Cloneable,
Serializable {
    default public double logPdf(double ... x) {
        return this.logPdf(DenseVector.toDenseVec(x));
    }

    public double logPdf(Vec var1);

    default public double pdf(double ... x) {
        return this.pdf(DenseVector.toDenseVec(x));
    }

    default public double pdf(Vec x) {
        return Math.exp(this.logPdf(x));
    }

    default public <V extends Vec> boolean setUsingData(List<V> dataSet) {
        return this.setUsingData(dataSet, false);
    }

    public <V extends Vec> boolean setUsingData(List<V> var1, boolean var2);

    default public boolean setUsingDataList(List<DataPoint> dataPoints) {
        return this.setUsingData(dataPoints.stream().map(d -> d.getNumericalValues()).collect(Collectors.toList()));
    }

    default public boolean setUsingData(DataSet dataSet) {
        return this.setUsingData(dataSet, false);
    }

    default public boolean setUsingData(DataSet dataSet, boolean parallel) {
        return this.setUsingData(dataSet.getDataVectors(), parallel);
    }

    public MultivariateDistribution clone();

    public List<Vec> sample(int var1, Random var2);
}

