/*
 * Decompiled with CFR 0.152.
 */
package jsat.driftdetectors;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import jsat.driftdetectors.BaseDriftDetector;
import jsat.driftdetectors.UnhandledDriftException;
import jsat.math.OnLineStatistics;

public class ADWIN<V>
extends BaseDriftDetector<V> {
    private static final long serialVersionUID = 3287510845017257629L;
    private double delta;
    private OnLineStatistics allStats;
    private LinkedList<OnLineStatistics> windows;
    private int M = 5;
    private double leftMean = Double.NaN;
    private double leftVariance = Double.NaN;
    private double rightMean = Double.NaN;
    private double rightVariance = Double.NaN;

    public ADWIN(double delta) {
        this(delta, 0);
    }

    public ADWIN(double delta, int maxHistory) {
        this.setDelta(delta);
        this.setMaxHistory(maxHistory);
        this.allStats = new OnLineStatistics();
        this.windows = new LinkedList();
    }

    public ADWIN(ADWIN<V> toCopy) {
        super(toCopy);
        this.delta = toCopy.delta;
        this.allStats = toCopy.allStats.clone();
        this.M = toCopy.M;
        this.leftMean = toCopy.leftMean;
        this.rightMean = toCopy.rightMean;
        this.leftVariance = toCopy.leftVariance;
        this.rightVariance = toCopy.rightVariance;
        this.windows = new LinkedList();
        for (OnLineStatistics stats : toCopy.windows) {
            this.windows.add(stats.clone());
        }
    }

    public void setDelta(double delta) {
        if (delta <= 0.0 || delta >= 1.0 || Double.isNaN(delta)) {
            throw new IllegalArgumentException("delta must be in (0,1), not " + delta);
        }
        this.delta = delta;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setM(int M) {
        if (M < 1) {
            throw new IllegalArgumentException("M must be positive, not " + M);
        }
        this.M = M;
    }

    public int getM() {
        return this.M;
    }

    @Override
    public boolean addSample(double value, V obj) {
        if (this.drifting) {
            throw new UnhandledDriftException("Drift must be handled before continuing");
        }
        ++this.time;
        this.addToHistory(obj);
        this.allStats.add(value);
        OnLineStatistics w = new OnLineStatistics();
        w.add(value);
        this.windows.addFirst(w);
        Iterator<OnLineStatistics> testIter = this.windows.descendingIterator();
        OnLineStatistics leftStats = new OnLineStatistics();
        OnLineStatistics rightStats = this.allStats.clone();
        double deltaPrime = this.delta / Math.log(this.allStats.getSumOfWeights());
        double ln2delta = Math.log(2.0) - Math.log(deltaPrime);
        double variance_W = this.allStats.getVarance();
        while (testIter.hasNext()) {
            OnLineStatistics windowItem = testIter.next();
            leftStats.add(windowItem);
            rightStats.remove(windowItem);
            double n_0 = leftStats.getSumOfWeights();
            double n_1 = rightStats.getSumOfWeights();
            double mu_0 = leftStats.getMean();
            double mu_1 = rightStats.getMean();
            double mInv = (n_0 + n_1) / (n_0 * n_1);
            double e_cut = Math.sqrt(2.0 * mInv * variance_W * ln2delta) + 0.6666666666666666 * mInv * ln2delta;
            if (!(Math.abs(mu_0 - mu_1) > e_cut)) continue;
            this.drifting = true;
            this.driftStart = (int)n_0;
            this.leftMean = mu_0;
            this.leftVariance = leftStats.getVarance();
            this.rightMean = mu_1;
            this.rightVariance = rightStats.getVarance();
        }
        this.compress();
        return this.drifting;
    }

    private void compress() {
        ListIterator listIter = this.windows.listIterator();
        double lastSizeSeen = -1.7976931348623157E308;
        int lastSizeCount = 0;
        while (listIter.hasNext()) {
            OnLineStatistics window = (OnLineStatistics)listIter.next();
            double n = window.getSumOfWeights();
            if (n == lastSizeSeen) {
                if (++lastSizeCount <= this.M) continue;
                listIter.previous();
                window.add((OnLineStatistics)listIter.previous());
                listIter.remove();
                if (listIter.hasNext()) {
                    listIter.next();
                }
                lastSizeSeen = window.getSumOfWeights();
                lastSizeCount = 1;
                continue;
            }
            lastSizeSeen = n;
            lastSizeCount = 1;
        }
    }

    public double getMean() {
        return this.allStats.getMean();
    }

    public double getVariance() {
        return this.allStats.getVarance();
    }

    public double getStndDev() {
        return this.allStats.getStandardDeviation();
    }

    public int getWidnowLength() {
        return this.time;
    }

    public double getOldMean() {
        return this.leftMean;
    }

    public double getOldVariance() {
        return this.leftVariance;
    }

    public double getOldStndDev() {
        return Math.sqrt(this.leftVariance);
    }

    public double getNewMean() {
        return this.rightMean;
    }

    public double getNewVariance() {
        return this.rightVariance;
    }

    public double getNewStndDev() {
        return Math.sqrt(this.rightVariance);
    }

    public void driftHandled(boolean dropOld) {
        Iterator<OnLineStatistics> testIter = this.windows.descendingIterator();
        OnLineStatistics leftStats = new OnLineStatistics();
        while (testIter.hasNext()) {
            OnLineStatistics windowItem = testIter.next();
            if (leftStats.getSumOfWeights() < (double)this.driftStart) {
                leftStats.add(windowItem);
                if (!dropOld) continue;
                testIter.remove();
                continue;
            }
            if (dropOld) continue;
            testIter.remove();
        }
        if (dropOld) {
            this.allStats.remove(leftStats);
        } else {
            this.allStats = leftStats;
        }
        this.time = (int)this.allStats.getSumOfWeights();
        this.rightVariance = Double.NaN;
        this.rightMean = Double.NaN;
        this.leftVariance = Double.NaN;
        this.leftMean = Double.NaN;
        super.driftHandled();
    }

    @Override
    public void driftHandled() {
        this.driftHandled(true);
    }

    @Override
    public ADWIN<V> clone() {
        return new ADWIN<V>(this);
    }
}

