/*
 * Decompiled with CFR 0.152.
 */
package jsat.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;

public abstract class DataWriter
implements Closeable {
    private static final int LOCAL_BUFFER_SIZE = 0xA00000;
    protected List<ByteArrayOutputStream> all_buffers = Collections.synchronizedList(new ArrayList());
    protected final OutputStream out;
    public final DataSetType type;
    public final CategoricalData[] catInfo;
    public final int dim;
    protected ThreadLocal<ByteArrayOutputStream> local_baos = new ThreadLocal<ByteArrayOutputStream>(){

        @Override
        protected ByteArrayOutputStream initialValue() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0xA00000);
            DataWriter.this.all_buffers.add(baos);
            return baos;
        }
    };

    public DataWriter(OutputStream out, CategoricalData[] catInfo, int dim, DataSetType type) throws IOException {
        this.out = out;
        this.type = type;
        this.catInfo = catInfo;
        this.dim = dim;
        this.writeHeader(catInfo, dim, type, out);
    }

    protected abstract void writeHeader(CategoricalData[] var1, int var2, DataSetType var3, OutputStream var4) throws IOException;

    public void writePoint(DataPoint dp, double label) throws IOException {
        this.writePoint(1.0, dp, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePoint(double weight, DataPoint dp, double label) throws IOException {
        ByteArrayOutputStream baos = this.local_baos.get();
        this.pointToBytes(weight, dp, label, baos);
        if (baos.size() >= 0xA00000) {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                baos.writeTo(this.out);
                baos.reset();
            }
        }
    }

    protected abstract void pointToBytes(double var1, DataPoint var3, double var4, ByteArrayOutputStream var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finish() throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            for (ByteArrayOutputStream baos : this.all_buffers) {
                baos.writeTo(this.out);
                baos.reset();
            }
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public static enum DataSetType {
        SIMPLE,
        CLASSIFICATION,
        REGRESSION;

    }
}

