/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import jsat.linear.ConstantVector;
import jsat.linear.DenseMatrix;
import jsat.linear.DenseVector;
import jsat.linear.EigenValueDecomposition;
import jsat.linear.Matrix;
import jsat.linear.Vec;
import jsat.utils.random.RandomUtil;

public class Lanczos
implements Serializable {
    public double[] d;
    public Matrix eigenVectors;

    public Lanczos(Matrix A2, int k, boolean A_AT, boolean is_symmetric) {
        Random rand = RandomUtil.getRandom();
        int dims = A_AT ? A2.rows() : A2.cols();
        int k_work = Math.min(k * 2 + 1, dims);
        int extra_ranks = k_work - k;
        Vec v_prev = new ConstantVector(0.0, dims);
        DenseVector v_next = new DenseVector(dims);
        v_next.add(1.0 / Math.sqrt(dims));
        double[] alpha = new double[k_work];
        double[] beta = new double[k_work];
        DenseMatrix V = new DenseMatrix(k_work, dims);
        DenseVector w_j = new DenseVector(dims);
        DenseVector tmp = new DenseVector(A_AT ? A2.cols() : A2.rows());
        for (int j = 0; j < k_work; ++j) {
            w_j.zeroOut();
            if (is_symmetric) {
                A2.multiply(v_next, 1.0, w_j);
            } else {
                tmp.zeroOut();
                if (A_AT) {
                    A2.transposeMultiply(1.0, v_next, tmp);
                    A2.multiply(tmp, 1.0, w_j);
                } else {
                    A2.multiply(v_next, 1.0, tmp);
                    A2.transposeMultiply(1.0, tmp, w_j);
                }
            }
            alpha[j] = w_j.dot(v_next);
            w_j.mutableAdd(-alpha[j], v_next);
            w_j.mutableAdd(-beta[j], v_prev);
            this.orthogonalize(j, V, w_j);
            v_prev = V.getRowView(j);
            v_next.copyTo(v_prev);
            if (j + 1 >= k_work) continue;
            beta[j + 1] = w_j.pNorm(2.0);
            if (Math.abs(beta[j + 1]) < 1.0E-15) {
                w_j.applyFunction(x -> rand.nextDouble() * 2.0 - 1.0);
                this.orthogonalize(j + 1, V, w_j);
                w_j.mutableDivide(w_j.pNorm(2.0) + 1.0E-15);
                beta[j + 1] = 1.0;
            }
            w_j.copyTo(v_next);
            ((Vec)v_next).mutableDivide(beta[j + 1]);
        }
        DenseMatrix triDaig = new DenseMatrix(k_work, k_work);
        for (int i = 0; i < k_work; ++i) {
            triDaig.set(i, i, alpha[i]);
            if (i + 1 >= k_work) continue;
            triDaig.set(i, i + 1, beta[i + 1]);
            triDaig.set(i + 1, i, beta[i + 1]);
        }
        EigenValueDecomposition evd = new EigenValueDecomposition(triDaig);
        evd.sortByEigenValue((a, b) -> -Double.compare(Math.abs(a), Math.abs(b)));
        this.d = Arrays.copyOf(evd.getRealEigenvalues(), k);
        this.eigenVectors = V.transposeMultiply(evd.getV());
        this.eigenVectors.changeSize(dims, k);
    }

    public Vec getEigenValues() {
        return new DenseVector(this.d);
    }

    public Matrix getEigenVectors() {
        return this.eigenVectors;
    }

    private void orthogonalize(int j, DenseMatrix V, Vec w_j) {
        for (int i = 0; i < j; ++i) {
            Vec V_i = V.getRowView(i);
            double tmp_dot = w_j.dot(V_i);
            if (Math.abs(tmp_dot) < 1.0E-15) continue;
            w_j.mutableAdd(-tmp_dot, V_i);
        }
    }
}

