/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.linear.DenseMatrix;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.RowColumnOps;
import jsat.linear.SparseVector;
import jsat.linear.Vec;
import jsat.utils.ModifiableCountDownLatch;
import jsat.utils.SystemInfo;

public abstract class Matrix
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6888360415978051714L;

    public Matrix add(Matrix B) {
        Matrix toReturn = this.getThisSideMatrix(B);
        toReturn.mutableAdd(1.0, B);
        return toReturn;
    }

    public Matrix add(Matrix B, ExecutorService threadPool) {
        Matrix toReturn = this.getThisSideMatrix(B);
        toReturn.mutableAdd(1.0, B, threadPool);
        return toReturn;
    }

    public Matrix add(double c) {
        Matrix toReturn = this.getThisSideMatrix(null);
        toReturn.mutableAdd(c);
        return toReturn;
    }

    public Matrix add(double c, ExecutorService threadPool) {
        Matrix toReturn = this.getThisSideMatrix(null);
        toReturn.mutableAdd(c, threadPool);
        return toReturn;
    }

    public void mutableAdd(Matrix B) {
        this.mutableAdd(1.0, B);
    }

    public abstract void mutableAdd(double var1, Matrix var3);

    public void mutableAdd(Matrix B, ExecutorService threadpool) {
        this.mutableAdd(1.0, B, threadpool);
    }

    public abstract void mutableAdd(double var1, Matrix var3, ExecutorService var4);

    public abstract void mutableAdd(double var1);

    public abstract void mutableAdd(double var1, ExecutorService var3);

    public boolean canBeMutated() {
        return true;
    }

    private Matrix getThisSideMatrix(Matrix B) {
        if (this.canBeMutated()) {
            return this.clone();
        }
        DenseMatrix dm = new DenseMatrix(this.rows(), this.cols());
        dm.mutableAdd(this);
        return dm;
    }

    public Matrix subtract(Matrix B) {
        Matrix toReturn = this.getThisSideMatrix(B);
        toReturn.mutableSubtract(1.0, B);
        return toReturn;
    }

    public Matrix subtract(Matrix B, ExecutorService threadPool) {
        Matrix toReturn = this.getThisSideMatrix(B);
        toReturn.mutableSubtract(1.0, B, threadPool);
        return toReturn;
    }

    public Matrix subtract(double c) {
        Matrix toReturn = this.getThisSideMatrix(null);
        toReturn.mutableSubtract(c);
        return toReturn;
    }

    public Matrix subtract(double c, ExecutorService threadPool) {
        Matrix toReturn = this.getThisSideMatrix(null);
        toReturn.mutableSubtract(c, threadPool);
        return toReturn;
    }

    public void mutableSubtract(Matrix B) {
        this.mutableSubtract(1.0, B);
    }

    public void mutableSubtract(double c, Matrix B) {
        this.mutableAdd(-c, B);
    }

    public void mutableSubtract(Matrix B, ExecutorService threadpool) {
        this.mutableSubtract(1.0, B, threadpool);
    }

    public void mutableSubtract(double c, Matrix B, ExecutorService threadPool) {
        this.mutableAdd(-c, B, threadPool);
    }

    public void mutableSubtract(double c) {
        this.mutableAdd(-c);
    }

    public void mutableSubtract(double c, ExecutorService threadPool) {
        this.mutableAdd(-c, threadPool);
    }

    public abstract void multiply(Vec var1, double var2, Vec var4);

    public Vec multiply(Vec b) {
        DenseVector result = new DenseVector(this.rows());
        this.multiply(b, 1.0, result);
        return result;
    }

    public Matrix multiply(Matrix B) {
        DenseMatrix C2 = new DenseMatrix(this.rows(), B.cols());
        this.multiply(B, C2);
        return C2;
    }

    public Matrix multiply(Matrix B, ExecutorService threadPool) {
        DenseMatrix C2 = new DenseMatrix(this.rows(), B.cols());
        this.multiply(B, C2, threadPool);
        return C2;
    }

    public abstract void multiply(Matrix var1, Matrix var2);

    public abstract void multiply(Matrix var1, Matrix var2, ExecutorService var3);

    public abstract void multiplyTranspose(Matrix var1, Matrix var2);

    public Matrix multiplyTranspose(Matrix B) {
        DenseMatrix C2 = new DenseMatrix(this.rows(), B.rows());
        this.multiplyTranspose(B, C2);
        return C2;
    }

    public abstract void multiplyTranspose(Matrix var1, Matrix var2, ExecutorService var3);

    public Matrix multiplyTranspose(Matrix B, ExecutorService threadPool) {
        DenseMatrix C2 = new DenseMatrix(this.rows(), B.rows());
        this.multiplyTranspose(B, C2, threadPool);
        return C2;
    }

    public Matrix multiply(double c) {
        Matrix toReturn = this.getThisSideMatrix(null);
        toReturn.mutableMultiply(c);
        return toReturn;
    }

    public Matrix multiply(double c, ExecutorService threadPool) {
        Matrix toReturn = this.getThisSideMatrix(null);
        toReturn.mutableMultiply(c, threadPool);
        return toReturn;
    }

    public abstract void mutableMultiply(double var1);

    public abstract void mutableMultiply(double var1, ExecutorService var3);

    public abstract Matrix[] lup();

    public abstract Matrix[] lup(ExecutorService var1);

    public abstract Matrix[] qr();

    public abstract Matrix[] qr(ExecutorService var1);

    public abstract void changeSize(int var1, int var2);

    public abstract void mutableTranspose();

    public Matrix transpose() {
        DenseMatrix toReturn = new DenseMatrix(this.cols(), this.rows());
        this.transpose(toReturn);
        return toReturn;
    }

    public abstract void transpose(Matrix var1);

    public Matrix transposeMultiply(Matrix B) {
        DenseMatrix C2 = new DenseMatrix(this.cols(), B.cols());
        this.transposeMultiply(B, C2);
        return C2;
    }

    public abstract void transposeMultiply(Matrix var1, Matrix var2);

    public Matrix transposeMultiply(Matrix B, ExecutorService threadPool) {
        DenseMatrix C2 = new DenseMatrix(this.cols(), B.cols());
        this.transposeMultiply(B, C2, threadPool);
        return C2;
    }

    public abstract void transposeMultiply(Matrix var1, Matrix var2, ExecutorService var3);

    public abstract void transposeMultiply(double var1, Vec var3, Vec var4);

    public Vec transposeMultiply(double c, Vec b) {
        DenseVector toReturns = new DenseVector(this.cols());
        this.transposeMultiply(c, b, toReturns);
        return toReturns;
    }

    public abstract double get(int var1, int var2);

    public abstract void set(int var1, int var2, double var3);

    public void increment(int i, int j, double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new ArithmeticException("Can not add a value " + value);
        }
        this.set(i, j, this.get(i, j) + value);
    }

    public abstract int rows();

    public abstract int cols();

    public abstract boolean isSparce();

    public long nnz() {
        return (long)this.rows() * (long)this.cols();
    }

    public boolean isSquare() {
        return this.rows() == this.cols();
    }

    public abstract void swapRows(int var1, int var2);

    public Vec getColumn(int j) {
        if (j < 0 || j >= this.cols()) {
            throw new ArithmeticException("Column was not a valid value " + j + " not in [0," + (this.cols() - 1) + "]");
        }
        DenseVector c = new DenseVector(this.rows());
        for (int i = 0; i < this.rows(); ++i) {
            c.set(i, this.get(i, j));
        }
        return c;
    }

    public Vec getColumnView(final int j) {
        final Matrix M = this;
        return new Vec(){
            private static final long serialVersionUID = 7107290189250645384L;

            @Override
            public int length() {
                return Matrix.this.rows();
            }

            @Override
            public double get(int index) {
                return M.get(index, j);
            }

            @Override
            public void set(int index, double val) {
                M.set(index, j, val);
            }

            @Override
            public boolean isSparse() {
                return M.isSparce();
            }

            @Override
            public Vec clone() {
                if (M.isSparce()) {
                    return new SparseVector(this);
                }
                return new DenseVector(this);
            }

            @Override
            public void setLength(int length) {
                throw new UnsupportedOperationException("Vector view can't not extend original matrix");
            }
        };
    }

    public Vec getRow(int r) {
        if (r < 0 || r >= this.rows()) {
            throw new ArithmeticException("Row was not a valid value " + r + " not in [0," + (this.rows() - 1) + "]");
        }
        DenseVector c = new DenseVector(this.cols());
        for (int j = 0; j < this.cols(); ++j) {
            c.set(j, this.get(r, j));
        }
        return c;
    }

    public Vec getRowView(final int r) {
        final Matrix M = this;
        return new Vec(){
            private static final long serialVersionUID = 8484494698777822563L;

            @Override
            public int length() {
                return M.cols();
            }

            @Override
            public double get(int index) {
                return M.get(r, index);
            }

            @Override
            public void set(int index, double val) {
                M.set(r, index, val);
            }

            @Override
            public boolean isSparse() {
                return M.isSparce();
            }

            @Override
            public Vec clone() {
                if (M.isSparce()) {
                    return new SparseVector(this);
                }
                return new DenseVector(this);
            }

            @Override
            public void setLength(int length) {
                throw new UnsupportedOperationException("Vector view can not extend original matrix");
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.rows() * this.cols());
        sb.append("[");
        for (int i = 0; i < this.rows(); ++i) {
            sb.append(this.get(i, 0));
            for (int j = 1; j < this.cols(); ++j) {
                sb.append(", ").append(this.get(i, j));
            }
            sb.append(";");
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean sameDimensions(Matrix A2, Matrix B) {
        return A2.rows() == B.rows() && A2.cols() == B.cols();
    }

    public static boolean canMultiply(Matrix A2, Matrix B) {
        return A2.cols() == B.rows();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Matrix)) {
            return false;
        }
        Matrix that = (Matrix)obj;
        if (this.rows() != that.rows() || this.cols() != that.cols()) {
            return false;
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                if (this.get(i, j) == that.get(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj, double range) {
        if (obj == null || !(obj instanceof Matrix)) {
            return false;
        }
        Matrix that = (Matrix)obj;
        if (this.rows() != that.rows() || this.cols() != that.cols()) {
            return false;
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                if (!(Math.abs(this.get(i, j) - that.get(i, j)) > range)) continue;
                return false;
            }
        }
        return true;
    }

    public abstract void zeroOut();

    public void copyTo(Matrix other) {
        if (this.rows() != other.rows() || this.cols() != other.cols()) {
            throw new ArithmeticException("Matrices are not of the same dimension");
        }
        for (int i = 0; i < this.rows(); ++i) {
            this.getRowView(i).copyTo(other.getRowView(i));
        }
    }

    public void updateRow(int i, double c, Vec b) {
        if (b.length() != this.cols()) {
            throw new ArithmeticException("vector is not of the same column length");
        }
        if (b.isSparse()) {
            for (IndexValue iv : b) {
                this.increment(i, iv.getIndex(), c * iv.getValue());
            }
        } else {
            for (int j = 0; j < b.length(); ++j) {
                this.increment(i, j, c * b.get(j));
            }
        }
    }

    public double frobenius() {
        double f = 0.0;
        for (int i = 0; i < this.rows(); ++i) {
            for (IndexValue iv : this.getRowView(i)) {
                f += Math.pow(iv.getValue(), 2.0);
            }
        }
        return Math.sqrt(f + 1.0E-15);
    }

    public static void OuterProductUpdate(Matrix A2, Vec x, Vec y, double c) {
        if (x.length() != A2.rows() || y.length() != A2.cols()) {
            throw new ArithmeticException("Matrix dimensions do not agree with outer product");
        }
        if (x.isSparse()) {
            for (IndexValue iv : x) {
                A2.updateRow(iv.getIndex(), iv.getValue() * c, y);
            }
        } else {
            for (int i = 0; i < x.length(); ++i) {
                double rowCosnt = c * x.get(i);
                A2.updateRow(i, rowCosnt, y);
            }
        }
    }

    public static void OuterProductUpdate(final Matrix A2, final Vec x, final Vec y, final double c, ExecutorService threadpool) {
        if (x.length() != A2.rows() || y.length() != A2.cols()) {
            throw new ArithmeticException("Matrix dimensions do not agree with outer product");
        }
        if (x.isSparse()) {
            final ModifiableCountDownLatch mcdl = new ModifiableCountDownLatch(1);
            for (final IndexValue iv : x) {
                mcdl.countUp();
                threadpool.submit(new Runnable(){

                    @Override
                    public void run() {
                        A2.updateRow(iv.getIndex(), iv.getValue() * c, y);
                        mcdl.countDown();
                    }
                });
            }
            mcdl.countDown();
            try {
                mcdl.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Matrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
            int id = 0;
            while (id < SystemInfo.LogicalCores) {
                final int threadID = id++;
                threadpool.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = threadID; i < x.length(); i += SystemInfo.LogicalCores) {
                            double rowCosnt = c * x.get(i);
                            A2.updateRow(i, rowCosnt, y);
                        }
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Matrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static DenseMatrix eye(int k) {
        DenseMatrix eye = new DenseMatrix(k, k);
        for (int i = 0; i < k; ++i) {
            eye.set(i, i, 1.0);
        }
        return eye;
    }

    public static DenseMatrix random(int rows, int cols, Random rand) {
        DenseMatrix m = new DenseMatrix(rows, cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                m.set(i, j, rand.nextDouble());
            }
        }
        return m;
    }

    public static Matrix diag(Vec a) {
        DenseMatrix A2 = new DenseMatrix(a.length(), a.length());
        Iterator<IndexValue> iter = a.getNonZeroIterator();
        while (iter.hasNext()) {
            IndexValue iv = iter.next();
            A2.set(iv.getIndex(), iv.getIndex(), iv.getValue());
        }
        return A2;
    }

    public static void diagMult(Matrix A2, Vec b) {
        if (A2.cols() != b.length()) {
            throw new ArithmeticException("Could not multiply, matrix dimensions must agree");
        }
        for (int i = 0; i < A2.rows(); ++i) {
            RowColumnOps.multRow(A2, i, b);
        }
    }

    public static void diagMult(Vec b, Matrix A2) {
        if (A2.rows() != b.length()) {
            throw new ArithmeticException("Could not multiply, matrix dimensions must agree");
        }
        for (int i = 0; i < A2.rows(); ++i) {
            RowColumnOps.multRow(A2, i, b.get(i));
        }
    }

    public static boolean isSymmetric(Matrix A2, double eps) {
        if (!A2.isSquare()) {
            return false;
        }
        for (int i = 0; i < A2.rows(); ++i) {
            for (int j = i + 1; j < A2.cols(); ++j) {
                if (!(Math.abs(A2.get(i, j) - A2.get(j, i)) > eps)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSymmetric(Matrix A2) {
        return Matrix.isSymmetric(A2, 0.0);
    }

    public static Matrix pascal(int size) {
        if (size <= 0) {
            throw new ArithmeticException();
        }
        DenseMatrix P = new DenseMatrix(size, size);
        RowColumnOps.fillRow(P, 0, 0, size, 1.0);
        RowColumnOps.fillCol(P, 0, 0, size, 1.0);
        for (int i = 1; i < size; ++i) {
            for (int j = 1; j < size; ++j) {
                P.set(i, j, P.get(i - 1, j) + P.get(i, j - 1));
            }
        }
        return P;
    }

    public abstract Matrix clone();
}

