/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import jsat.linear.IndexValue;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DenseSparseMetric;

public class ManhattanDistance
implements DenseSparseMetric {
    private static final long serialVersionUID = 3028834823742743351L;

    @Override
    public double dist(Vec a, Vec b) {
        return a.pNormDist(1.0, b);
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isSubadditive() {
        return true;
    }

    @Override
    public boolean isIndiscemible() {
        return true;
    }

    @Override
    public double metricBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String toString() {
        return "Manhattan Distance";
    }

    @Override
    public ManhattanDistance clone() {
        return new ManhattanDistance();
    }

    @Override
    public double getVectorConstant(Vec vec) {
        return vec.pNorm(1.0);
    }

    @Override
    public double dist(double summaryConst, Vec main, Vec target) {
        if (!target.isSparse()) {
            return this.dist(main, target);
        }
        double takeOut = 0.0;
        for (IndexValue iv : target) {
            int i = iv.getIndex();
            double mainVal = main.get(i);
            takeOut += mainVal - Math.abs(mainVal - iv.getValue());
        }
        return summaryConst - takeOut;
    }
}

