/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.math.FastMath;
import jsat.utils.ArrayUtils;
import jsat.utils.DoubleList;
import jsat.utils.IndexTable;
import jsat.utils.Pair;
import jsat.utils.Tuple3;
import jsat.utils.concurrent.ParallelUtils;

public class DCI<V extends Vec>
implements VectorCollection<V> {
    private static final long serialVersionUID = -567002398793828933L;
    private static EuclideanDistance euclid = new EuclideanDistance();
    private int m;
    private int L;
    private Vec[][] u;
    private NearestIterator[][] T;
    private List<V> vecs;
    private List<Double> cache;

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        int i;
        this.m = in.readInt();
        this.L = in.readInt();
        int vec_count = in.readInt();
        int cache_count = in.readInt();
        boolean wasBuilt = in.readBoolean();
        if (vec_count > 0) {
            this.vecs = new ArrayList<V>(vec_count);
            for (i = 0; i < vec_count; ++i) {
                this.vecs.add((Vec)in.readObject());
            }
        }
        if (cache_count > 0) {
            this.cache = new DoubleList(cache_count);
            for (i = 0; i < cache_count; ++i) {
                this.cache.add(in.readDouble());
            }
        }
        if (wasBuilt) {
            int L_i;
            int m_i;
            this.u = new Vec[this.m][this.L];
            this.T = new NearestIterator[this.m][this.L];
            for (m_i = 0; m_i < this.m; ++m_i) {
                for (L_i = 0; L_i < this.L; ++L_i) {
                    this.u[m_i][L_i] = (Vec)in.readObject();
                }
            }
            for (m_i = 0; m_i < this.m; ++m_i) {
                for (L_i = 0; L_i < this.L; ++L_i) {
                    double[] keys = new double[vec_count];
                    int[] vals = new int[vec_count];
                    for (int i2 = 0; i2 < vec_count; ++i2) {
                        keys[i2] = in.readDouble();
                        vals[i2] = in.readInt();
                    }
                    this.T[m_i][L_i] = new NearestIterator(keys, vals);
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        out.writeInt(this.m);
        out.writeInt(this.L);
        int vec_count = this.vecs == null ? 0 : this.vecs.size();
        int cache_count = this.cache == null ? 0 : this.vecs.size();
        out.writeInt(vec_count);
        out.writeInt(cache_count);
        out.writeBoolean(this.T != null);
        for (i = 0; i < vec_count; ++i) {
            out.writeObject(this.vecs.get(i));
        }
        for (i = 0; i < cache_count; ++i) {
            out.writeDouble(this.cache.get(i));
        }
        if (this.T != null) {
            int L_i;
            int m_i;
            for (m_i = 0; m_i < this.m; ++m_i) {
                for (L_i = 0; L_i < this.L; ++L_i) {
                    out.writeObject(this.u[m_i][L_i]);
                }
            }
            for (m_i = 0; m_i < this.m; ++m_i) {
                for (L_i = 0; L_i < this.L; ++L_i) {
                    NearestIterator ni = this.T[m_i][L_i];
                    for (int i2 = 0; i2 < vec_count; ++i2) {
                        out.writeDouble(ni.keys[i2]);
                        out.writeInt(ni.vals[i2]);
                    }
                }
            }
        }
    }

    public DCI() {
        this(15, 3);
    }

    public DCI(int m, int L) {
        this.m = m;
        this.L = L;
    }

    public DCI(DCI<V> toCopy) {
        this.m = toCopy.m;
        this.L = toCopy.L;
        if (toCopy.u != null) {
            this.u = new Vec[this.m][this.L];
            this.T = new NearestIterator[this.m][this.L];
            this.vecs = new ArrayList<V>(toCopy.vecs);
            this.cache = new DoubleList(toCopy.cache);
            for (int j = 0; j < this.m; ++j) {
                for (int l = 0; l < this.L; ++l) {
                    this.u[j][l] = toCopy.u[j][l].clone();
                    this.T[j][l] = toCopy.T[j][l].clone();
                }
            }
        }
    }

    @Override
    public void build(boolean parallel, List<V> collection, DistanceMetric dm) {
        int l;
        int j;
        this.setDistanceMetric(dm);
        this.vecs = new ArrayList<V>(collection);
        this.cache = euclid.getAccelerationCache(this.vecs, parallel);
        int d = ((Vec)collection.get(0)).length();
        int n = collection.size();
        this.u = new Vec[this.m][this.L];
        for (j = 0; j < this.m; ++j) {
            for (l = 0; l < this.L; ++l) {
                this.u[j][l] = DenseVector.random(d);
                this.u[j][l].mutableDivide(this.u[j][l].pNorm(2.0));
            }
        }
        this.T = new NearestIterator[this.m][this.L];
        for (j = 0; j < this.m; ++j) {
            for (l = 0; l < this.L; ++l) {
                Vec u_jl = this.u[j][l];
                double[] keys = new double[n];
                int[] vals = new int[n];
                ParallelUtils.run(parallel, n, (start, end) -> {
                    for (int i = start; i < end; ++i) {
                        double p_bar;
                        keys[i] = p_bar = ((Vec)this.vecs.get(i)).dot(u_jl);
                        vals[i] = i;
                    }
                });
                this.T[j][l] = new NearestIterator(keys, vals);
            }
        }
    }

    @Override
    public void setDistanceMetric(DistanceMetric dm) {
        if (!(dm instanceof EuclideanDistance)) {
            throw new IllegalArgumentException("DCI only works for Euclidean Distance Searches");
        }
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return new EuclideanDistance();
    }

    @Override
    public void search(Vec query, double range, List<Integer> neighbors, List<Double> distances) {
        Map.Entry entry22;
        Iterator iter_jl;
        int l;
        int n = this.vecs.size();
        int[][] C2 = new int[this.L][n];
        double[][] q_bar = new double[this.m][this.L];
        for (int j = 0; j < this.m; ++j) {
            for (l = 0; l < this.L; ++l) {
                q_bar[j][l] = query.dot(this.u[j][l]);
            }
        }
        ArrayList S = new ArrayList();
        for (l = 0; l < this.L; ++l) {
            S.add(new HashSet());
        }
        ArrayList q_iters = new ArrayList(this.m);
        for (int j = 0; j < this.m; ++j) {
            ArrayList<Iterator<Pair<Double, Integer>>> iter_m = new ArrayList<Iterator<Pair<Double, Integer>>>(this.L);
            for (int i = 0; i < this.L; ++i) {
                iter_m.add(this.T[j][i].nnWalk(q_bar[j][i]));
            }
            q_iters.add(iter_m);
        }
        for (int l3 = 0; l3 < this.L; ++l3) {
            Set S_l = (Set)S.get(l3);
            for (int i = 0; i < this.m; ++i) {
                Pair pair;
                double dist_lower;
                iter_jl = (Iterator)((List)q_iters.get(i)).get(l3);
                while (iter_jl.hasNext() && !((dist_lower = (Double)(pair = (Pair)iter_jl.next()).getFirstItem() - q_bar[i][l3]) > range)) {
                    int indx = (Integer)pair.getSecondItem();
                    int[] nArray = C2[l3];
                    int n2 = indx;
                    nArray[n2] = nArray[n2] + 1;
                    if (C2[l3][indx] != this.m) continue;
                    S_l.add(indx);
                }
            }
        }
        neighbors.clear();
        distances.clear();
        HashMap<Integer, Integer> unionCounter = new HashMap<Integer, Integer>();
        for (Set set : S) {
            iter_jl = set.iterator();
            while (iter_jl.hasNext()) {
                int i = (Integer)iter_jl.next();
                unionCounter.put(i, unionCounter.getOrDefault(i, 0) + 1);
            }
        }
        HashSet candidates = new HashSet();
        for (Map.Entry entry22 : unionCounter.entrySet()) {
            if (((Integer)entry22.getValue()).intValue() != S.size()) continue;
            candidates.add(entry22.getKey());
        }
        List<Double> list = euclid.getQueryInfo(query);
        entry22 = candidates.iterator();
        while (entry22.hasNext()) {
            int i = (Integer)entry22.next();
            neighbors.add(i);
            distances.add(euclid.dist(i, query, list, this.vecs, this.cache));
        }
        IndexTable it = new IndexTable(distances);
        it.apply(neighbors);
        it.apply(distances);
        int maxIndx = ArrayUtils.bsIndex2Insert(Collections.binarySearch(distances, range));
        neighbors.subList(maxIndx, neighbors.size()).clear();
        distances.subList(maxIndx, distances.size()).clear();
    }

    @Override
    public void search(Vec query, int numNeighbors, List<Integer> neighbors, List<Double> distances) {
        int l;
        int n = this.vecs.size();
        int k1 = (int)((double)(this.m * numNeighbors) * (FastMath.log(n) - FastMath.log(numNeighbors)));
        int[][] C2 = new int[this.L][n];
        double[][] q_bar = new double[this.m][this.L];
        for (int j = 0; j < this.m; ++j) {
            for (int l2 = 0; l2 < this.L; ++l2) {
                q_bar[j][l2] = query.dot(this.u[j][l2]);
            }
        }
        ArrayList S = new ArrayList();
        for (int l2 = 0; l2 < this.L; ++l2) {
            S.add(new HashSet());
        }
        ArrayList q_iters = new ArrayList(this.m);
        for (int j = 0; j < this.m; ++j) {
            ArrayList<Iterator<Pair<Double, Integer>>> iter_m = new ArrayList<Iterator<Pair<Double, Integer>>>(this.L);
            for (l = 0; l < this.L; ++l) {
                iter_m.add(this.T[j][l].nnWalk(q_bar[j][l]));
            }
            q_iters.add(iter_m);
        }
        ArrayList P = new ArrayList();
        for (int l3 = 0; l3 < this.L; ++l3) {
            P.add(new PriorityQueue((o1, o2) -> Double.compare((Double)o1.getX(), (Double)o2.getX())));
        }
        for (int j = 0; j < this.m; ++j) {
            for (l = 0; l < this.L; ++l) {
                Pair pair = (Pair)((Iterator)((List)q_iters.get(j)).get(l)).next();
                double priority = Math.abs((Double)pair.getFirstItem() - q_bar[j][l]);
                ((PriorityQueue)P.get(l)).add(new Tuple3(priority, j, pair.getSecondItem()));
            }
        }
        for (int i = 0; i < k1; ++i) {
            for (l = 0; l < this.L; ++l) {
                Set set = (Set)S.get(l);
                PriorityQueue P_l = (PriorityQueue)P.get(l);
                if (set.size() >= numNeighbors) continue;
                Tuple3 ph = (Tuple3)P_l.poll();
                int j = (Integer)ph.getY();
                int h_jl = (Integer)ph.getZ();
                Pair next_ph = (Pair)((Iterator)((List)q_iters.get(j)).get(l)).next();
                double priority = Math.abs((Double)next_ph.getFirstItem() - q_bar[j][l]);
                ((PriorityQueue)P.get(l)).add(new Tuple3(priority, j, next_ph.getSecondItem()));
                int[] nArray = C2[l];
                int n2 = h_jl;
                nArray[n2] = nArray[n2] + 1;
                if (C2[l][h_jl] != this.m) continue;
                set.add(h_jl);
            }
            if (i != k1 - 1 || S.stream().mapToInt(s -> s.size()).min().getAsInt() >= numNeighbors) continue;
            k1 *= 2;
        }
        neighbors.clear();
        distances.clear();
        HashSet candidates = new HashSet();
        for (Set set : S) {
            candidates.addAll(set);
        }
        List<Double> qi = euclid.getQueryInfo(query);
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            neighbors.add(i);
            distances.add(euclid.dist(i, query, qi, this.vecs, this.cache));
        }
        IndexTable indexTable = new IndexTable(distances);
        indexTable.apply(neighbors);
        indexTable.apply(distances);
        neighbors.subList(numNeighbors, neighbors.size()).clear();
        distances.subList(numNeighbors, distances.size()).clear();
    }

    @Override
    public V get(int indx) {
        return (V)((Vec)this.vecs.get(indx));
    }

    @Override
    public List<Double> getAccelerationCache() {
        return this.cache;
    }

    @Override
    public int size() {
        return this.vecs.size();
    }

    @Override
    public DCI<V> clone() {
        return new DCI<V>(this);
    }

    static class NearestIterator
    implements Serializable {
        public double[] keys;
        public int[] vals;

        public NearestIterator(double[] keys, int[] vals) {
            this.keys = keys;
            this.vals = vals;
            if (keys.length != vals.length) {
                throw new IllegalArgumentException("Keys and vales should have the same length");
            }
            IndexTable it = new IndexTable(keys);
            it.apply(keys);
            it.apply(vals);
        }

        public NearestIterator(NearestIterator toCopy) {
            this.keys = Arrays.copyOf(toCopy.keys, toCopy.keys.length);
            this.vals = Arrays.copyOf(toCopy.vals, toCopy.vals.length);
        }

        public NearestIterator() {
        }

        protected NearestIterator clone() {
            return new NearestIterator(this);
        }

        public Iterator<Pair<Double, Integer>> nnWalk(final double q) {
            return new Iterator<Pair<Double, Integer>>(){
                int upper;
                int lower;
                {
                    this.upper = ArrayUtils.bsIndex2Insert(Arrays.binarySearch(keys, q));
                    this.lower = this.upper - 1;
                }

                @Override
                public boolean hasNext() {
                    return this.lower >= 0 || this.upper < keys.length;
                }

                @Override
                public Pair<Double, Integer> next() {
                    Pair<Double, Integer> toRet = null;
                    if (this.lower < 0 && this.upper >= keys.length) {
                        throw new NoSuchElementException();
                    }
                    if (this.lower < 0) {
                        toRet = new Pair<Double, Integer>(keys[this.upper], vals[this.upper]);
                        ++this.upper;
                    } else if (this.upper >= keys.length) {
                        toRet = new Pair<Double, Integer>(keys[this.lower], vals[this.lower]);
                        --this.lower;
                    } else if (Math.abs(keys[this.upper] - q) < Math.abs(keys[this.lower] - q)) {
                        toRet = new Pair<Double, Integer>(keys[this.upper], vals[this.upper]);
                        ++this.upper;
                    } else {
                        toRet = new Pair<Double, Integer>(keys[this.lower], vals[this.lower]);
                        --this.lower;
                    }
                    return toRet;
                }
            };
        }
    }
}

