/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.DualTree;
import jsat.linear.vectorcollection.IncrementalCollection;
import jsat.linear.vectorcollection.IndexDistPair;
import jsat.linear.vectorcollection.IndexNode;
import jsat.utils.BooleanList;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.IndexTable;
import jsat.utils.IntList;
import jsat.utils.ModifiableCountDownLatch;
import jsat.utils.Pair;
import jsat.utils.SimpleList;
import jsat.utils.concurrent.ParallelUtils;
import jsat.utils.random.RandomUtil;

public class SVPTree<V extends Vec>
implements IncrementalCollection<V>,
DualTree<V> {
    private static final long serialVersionUID = -7271540108746353762L;
    private DistanceMetric dm;
    private List<Double> distCache;
    private List<V> allVecs;
    protected volatile TreeNode root;
    private int size;
    private int maxLeafSize = 5;

    @Override
    public IndexNode getRoot() {
        return this.root;
    }

    public SVPTree(List<V> list, DistanceMetric dm, boolean parallel) {
        this.build(parallel, list, dm);
    }

    public SVPTree(List<V> list, DistanceMetric dm) {
        this(list, dm, false);
    }

    public SVPTree() {
        this(new EuclideanDistance());
    }

    public SVPTree(DistanceMetric dm) {
        this.dm = dm;
        if (!dm.isSubadditive()) {
            throw new RuntimeException("VPTree only supports metrics that support the triangle inequality");
        }
        this.size = 0;
        this.allVecs = new ArrayList<V>();
        if (dm.supportsAcceleration()) {
            this.distCache = new DoubleList();
        }
    }

    protected SVPTree(SVPTree<V> toClone) {
        this.dm = toClone.dm.clone();
        this.root = this.cloneChangeContext(toClone.root);
        this.size = toClone.size;
        this.maxLeafSize = toClone.maxLeafSize;
        if (toClone.allVecs != null) {
            this.allVecs = new ArrayList<V>(toClone.allVecs);
        }
        if (toClone.distCache != null) {
            this.distCache = new DoubleList(toClone.distCache);
        }
    }

    @Override
    public List<Double> getAccelerationCache() {
        return this.distCache;
    }

    @Override
    public double dist(int self_index, int other_index, DualTree<V> other) {
        return this.dm.dist(self_index, (Vec)other.get(other_index), this.dm.getQueryInfo((Vec)other.get(other_index)), (List<? extends Vec>)this.allVecs, this.distCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(boolean parallel, List<V> list, DistanceMetric dm) {
        this.setDistanceMetric(dm);
        if (!dm.isSubadditive()) {
            throw new RuntimeException("VPTree only supports metrics that support the triangle inequality");
        }
        Random rand = RandomUtil.getRandom();
        this.size = list.size();
        this.allVecs = list;
        this.distCache = dm.getAccelerationCache(this.allVecs, parallel);
        SimpleList<Pair<Double, Integer>> tmpList = new SimpleList<Pair<Double, Integer>>(list.size());
        for (int i = 0; i < this.allVecs.size(); ++i) {
            tmpList.add(new Pair<Double, Integer>(-1.0, i));
        }
        if (!parallel) {
            this.root = this.makeVPTree(tmpList);
        } else {
            ExecutorService threadpool = ParallelUtils.getNewExecutor(parallel);
            ModifiableCountDownLatch mcdl = new ModifiableCountDownLatch(1);
            this.root = this.makeVPTree(tmpList, threadpool, mcdl);
            mcdl.countDown();
            try {
                mcdl.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SVPTree.class.getName()).log(Level.SEVERE, null, ex);
                System.err.println("Falling back to single threaded VPTree constructor");
                tmpList.clear();
                for (int i = 0; i < list.size(); ++i) {
                    tmpList.add(new Pair<Double, Integer>(-1.0, i));
                }
                this.root = this.makeVPTree(tmpList);
            }
            finally {
                threadpool.shutdownNow();
            }
        }
    }

    @Override
    public void setDistanceMetric(DistanceMetric dm) {
        this.dm = dm;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.dm;
    }

    private TreeNode cloneChangeContext(TreeNode toClone) {
        if (toClone != null) {
            if (toClone instanceof VPLeaf) {
                return new VPLeaf((VPLeaf)toClone);
            }
            return new VPNode((VPNode)toClone);
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(int indx) {
        return (V)((Vec)this.allVecs.get(indx));
    }

    @Override
    public void insert(V x) {
        int indx = this.size++;
        this.allVecs.add(x);
        if (this.distCache != null) {
            this.distCache.addAll(this.dm.getQueryInfo((Vec)x));
        }
        if (this.root == null) {
            ArrayList<Pair<Double, Integer>> list = new ArrayList<Pair<Double, Integer>>();
            list.add(new Pair<Double, Integer>((Double)Double.MAX_VALUE, indx));
            this.root = new VPLeaf(list);
            return;
        }
        this.root.insert(indx, Double.MAX_VALUE);
        if (this.root instanceof VPLeaf) {
            VPLeaf leaf = (VPLeaf)this.root;
            if (leaf.points.size() > this.maxLeafSize * this.maxLeafSize) {
                int orig_leaf_isze = this.maxLeafSize;
                this.maxLeafSize *= this.maxLeafSize;
                ArrayList<Pair<Double, Integer>> S = new ArrayList<Pair<Double, Integer>>();
                for (int i = 0; i < leaf.points.size(); ++i) {
                    S.add(new Pair<Double, Integer>((Double)Double.MAX_VALUE, leaf.points.getI(i)));
                }
                this.root = this.makeVPTree(S);
                this.maxLeafSize = orig_leaf_isze;
            }
        }
    }

    @Override
    public void search(Vec query, double range, List<Integer> neighbors, List<Double> distances) {
        List<Double> qi = this.dm.getQueryInfo(query);
        this.root.searchRange(VecPaired.extractTrueVec(query), range, neighbors, distances, 0.0, qi);
        IndexTable it = new IndexTable(distances);
        it.apply(neighbors);
        it.apply(distances);
    }

    @Override
    public void search(Vec query, int numNeighbors, List<Integer> neighbors, List<Double> distances) {
        BoundedSortedList<IndexDistPair> boundedList = new BoundedSortedList<IndexDistPair>(numNeighbors, numNeighbors);
        List<Double> qi = this.dm.getQueryInfo(query);
        this.root.searchKNN(VecPaired.extractTrueVec(query), numNeighbors, boundedList, 0.0, qi);
        for (IndexDistPair pm : boundedList) {
            neighbors.add(pm.getIndex());
            distances.add(pm.getDist());
        }
    }

    private int sortSplitSet(List<Pair<Double, Integer>> S, VPNode node) {
        for (Pair<Double, Integer> S1 : S) {
            S1.setFirstItem(this.dm.dist(node.p, S1.getSecondItem(), this.allVecs, this.distCache));
        }
        Collections.sort(S, (o1, o2) -> Double.compare((Double)o1.getFirstItem(), (Double)o2.getFirstItem()));
        int splitIndex = this.splitListIndex(S);
        node.left_low = S.get(0).getFirstItem();
        node.left_high = S.get(splitIndex).getFirstItem();
        node.right_low = S.get(splitIndex + 1).getFirstItem();
        node.right_high = S.get(S.size() - 1).getFirstItem();
        return splitIndex;
    }

    protected int splitListIndex(List<Pair<Double, Integer>> S) {
        return S.size() / 2;
    }

    public int getMaxLeafSize() {
        return this.maxLeafSize;
    }

    public void setMaxLeafSize(int maxLeafSize) {
        this.maxLeafSize = Math.max(5, maxLeafSize);
    }

    private TreeNode makeVPTree(List<Pair<Double, Integer>> S) {
        if (S.isEmpty()) {
            return null;
        }
        if (S.size() <= this.maxLeafSize) {
            VPLeaf leaf = new VPLeaf(S);
            return leaf;
        }
        int vpIndex = this.selectVantagePointIndex(S);
        VPNode node = new VPNode(S.get(vpIndex).getSecondItem());
        node.parent_dist = S.get(vpIndex).getFirstItem();
        int splitIndex = this.sortSplitSet(S, node);
        node.right = this.makeVPTree(S.subList(splitIndex + 1, S.size()));
        if (node.right != null) {
            node.right.parent = node;
        }
        node.left = this.makeVPTree(S.subList(0, splitIndex + 1));
        if (node.left != null) {
            node.left.parent = node;
        }
        return node;
    }

    private TreeNode makeVPTree(List<Pair<Double, Integer>> S, ExecutorService threadpool, ModifiableCountDownLatch mcdl) {
        if (S.isEmpty()) {
            return null;
        }
        if (S.size() <= this.maxLeafSize) {
            VPLeaf leaf = new VPLeaf(S);
            return leaf;
        }
        int vpIndex = this.selectVantagePointIndex(S);
        VPNode node = new VPNode(S.get(vpIndex).getSecondItem());
        node.parent_dist = S.get(vpIndex).getFirstItem();
        int splitIndex = this.sortSplitSet(S, node);
        mcdl.countUp();
        List<Pair<Double, Integer>> rightS = S.subList(splitIndex + 1, S.size());
        List<Pair<Double, Integer>> leftS = S.subList(0, splitIndex + 1);
        threadpool.submit(() -> {
            node.right = this.makeVPTree(rightS, threadpool, mcdl);
            if (node.right != null) {
                node.right.parent = node;
            }
            mcdl.countDown();
        });
        node.left = this.makeVPTree(leftS, threadpool, mcdl);
        if (node.left != null) {
            node.left.parent = node;
        }
        return node;
    }

    private int selectVantagePointIndex(List<Pair<Double, Integer>> S) {
        int vpIndex = RandomUtil.getLocalRandom().nextInt(S.size());
        return vpIndex;
    }

    @Override
    public SVPTree<V> clone() {
        return new SVPTree<V>(this);
    }

    private class VPLeaf
    extends TreeNode {
        IntList points;
        DoubleList bounds;

        public VPLeaf(List<Pair<Double, Integer>> points) {
            this.points = new IntList(points.size());
            this.bounds = new DoubleList(points.size());
            for (int i = 0; i < points.size(); ++i) {
                this.points.add(points.get(i).getSecondItem());
                this.bounds.add(points.get(i).getFirstItem());
            }
        }

        public VPLeaf(VPLeaf toCopy) {
            this.bounds = new DoubleList(toCopy.bounds);
            this.points = new IntList(toCopy.points);
        }

        @Override
        public void insert(int x_indx, double dist_to_parent) {
            this.points.add(x_indx);
            this.bounds.add(dist_to_parent);
        }

        @Override
        public void searchKNN(Vec query, int k, BoundedSortedList<IndexDistPair> list, double x, List<Double> qi) {
            double dist = -1.0;
            double tau = list.isEmpty() ? Double.MAX_VALUE : ((IndexDistPair)list.get(list.size() - 1)).getDist();
            for (int i = 0; i < this.points.size(); ++i) {
                double d;
                int point_i = this.points.getI(i);
                double bound_i = this.bounds.getD(i);
                if (list.size() < k) {
                    list.add(new IndexDistPair(point_i, SVPTree.this.dm.dist(point_i, query, qi, SVPTree.this.allVecs, SVPTree.this.distCache)));
                    tau = ((IndexDistPair)list.get(list.size() - 1)).getDist();
                    continue;
                }
                if (!(bound_i - tau <= x) || !(x <= bound_i + tau)) continue;
                dist = SVPTree.this.dm.dist(point_i, query, qi, SVPTree.this.allVecs, SVPTree.this.distCache);
                if (!(d < tau)) continue;
                list.add(new IndexDistPair(point_i, dist));
                tau = ((IndexDistPair)list.get(list.size() - 1)).getDist();
            }
        }

        @Override
        public void searchRange(Vec query, double range, List<Integer> neighbors, List<Double> distances, double x, List<Double> qi) {
            double dist = Double.MAX_VALUE;
            for (int i = 0; i < this.points.size(); ++i) {
                double d;
                int point_i = this.points.getI(i);
                double bound_i = this.bounds.getD(i);
                if (!(bound_i - range <= x) || !(x <= bound_i + range)) continue;
                dist = SVPTree.this.dm.dist(point_i, query, qi, SVPTree.this.allVecs, SVPTree.this.distCache);
                if (!(d < range)) continue;
                neighbors.add(point_i);
                distances.add(dist);
            }
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public TreeNode clone() {
            return new VPLeaf(this);
        }

        public VPNode getParrent() {
            return this.parent;
        }

        public double maxNodeDistance(IndexNode other) {
            return Double.POSITIVE_INFINITY;
        }

        public double minNodeDistance(IndexNode other) {
            return 0.0;
        }

        @Override
        public double minNodeDistance(int other) {
            return 0.0;
        }

        @Override
        public double getParentDistance() {
            return this.furthestDescendantDistance();
        }

        @Override
        public double furthestPointDistance() {
            return this.furthestDescendantDistance();
        }

        @Override
        public double furthestDescendantDistance() {
            if (this.bounds.isEmpty()) {
                return 0.0;
            }
            return this.bounds.max();
        }

        @Override
        public int numChildren() {
            return 0;
        }

        @Override
        public IndexNode getChild(int indx) {
            throw new IndexOutOfBoundsException("Leaf nodes have no children");
        }

        @Override
        public Vec getVec(int indx) {
            return SVPTree.this.get(indx);
        }

        @Override
        public int numPoints() {
            return this.points.size();
        }

        @Override
        public int getPoint(int indx) {
            return this.points.getI(indx);
        }
    }

    private class VPNode
    extends TreeNode {
        int p;
        double left_low;
        double left_high;
        double right_low;
        double right_high;
        TreeNode right;
        TreeNode left;
        double parent_dist;

        public VPNode(int p) {
            this.p = p;
        }

        public VPNode(VPNode toCopy) {
            this(toCopy.p);
            this.left_low = toCopy.left_low;
            this.left_high = toCopy.left_high;
            this.right_low = toCopy.right_low;
            this.right_high = toCopy.right_high;
            this.left = sVPTree.cloneChangeContext(toCopy.left);
            this.right = sVPTree.cloneChangeContext(toCopy.right);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void insert(int x_indx, double dist_to_parent) {
            TreeNode child;
            double dist = SVPTree.this.dm.dist(this.p, x_indx, (List<? extends Vec>)SVPTree.this.allVecs, (List<Double>)SVPTree.this.distCache);
            if (dist * 2.0 < this.left_high + this.right_low) {
                this.left_high = Math.max(this.left_high, dist);
                this.left_low = Math.min(this.left_low, dist);
                child = this.left = this.maybeExpandChild(this.left);
            } else {
                this.right_high = Math.max(this.right_high, dist);
                this.right_low = Math.min(this.right_low, dist);
                child = this.right = this.maybeExpandChild(this.right);
            }
            child.insert(x_indx, dist);
        }

        private TreeNode maybeExpandChild(TreeNode child) {
            if (child instanceof VPLeaf) {
                IntList childs_children = ((VPLeaf)child).points;
                if (childs_children.size() <= SVPTree.this.maxLeafSize * SVPTree.this.maxLeafSize) {
                    return child;
                }
                ArrayList<Pair<Double, Integer>> S = new ArrayList<Pair<Double, Integer>>(childs_children.size());
                Iterator iterator = childs_children.iterator();
                while (iterator.hasNext()) {
                    int indx = (Integer)iterator.next();
                    S.add(new Pair<Double, Integer>((Double)Double.MAX_VALUE, indx));
                }
                int vpIndex = SVPTree.this.selectVantagePointIndex(S);
                VPNode node = new VPNode((Integer)((Pair)S.get(vpIndex)).getSecondItem());
                node.parent_dist = (Double)((Pair)S.get(vpIndex)).getFirstItem();
                node.parent = ((VPLeaf)child).parent;
                Collections.swap(S, 0, vpIndex);
                int splitIndex = SVPTree.this.sortSplitSet(S.subList(1, S.size()), node) + 1;
                node.right = new VPLeaf(S.subList(splitIndex + 1, S.size()));
                node.right.parent = node;
                node.left = new VPLeaf(S.subList(1, splitIndex + 1));
                node.left.parent = node;
                return node;
            }
            return child;
        }

        private boolean searchInLeft(double x, double tau) {
            if (this.left == null) {
                return false;
            }
            return this.left_low - tau <= x && x <= this.left_high + tau;
        }

        private boolean searchInRight(double x, double tau) {
            if (this.right == null) {
                return false;
            }
            return this.right_low - tau <= x && x <= this.right_high + tau;
        }

        @Override
        public void searchKNN(Vec query, int k, BoundedSortedList<IndexDistPair> list, double x, List<Double> qi) {
            ArrayDeque<VPNode> curNode_stack = new ArrayDeque<VPNode>();
            DoubleList distToParrent_stack = new DoubleList();
            BooleanList search_left_stack = new BooleanList();
            curNode_stack.add(this);
            while (!curNode_stack.isEmpty()) {
                double tau;
                VPNode node;
                if (curNode_stack.size() > search_left_stack.size()) {
                    node = (VPNode)curNode_stack.peek();
                    x = SVPTree.this.dm.dist(node.p, query, qi, SVPTree.this.allVecs, SVPTree.this.distCache);
                    distToParrent_stack.push(x);
                    if (list.size() < k || x < ((IndexDistPair)list.get(k - 1)).getDist()) {
                        list.add(new IndexDistPair(node.p, x));
                    }
                    tau = ((IndexDistPair)list.get(list.size() - 1)).getDist();
                    double middle = (node.left_high + node.right_low) * 0.5;
                    boolean leftFirst = x < middle;
                    search_left_stack.add(!leftFirst);
                    if (leftFirst) {
                        if (!node.searchInLeft(x, tau) && list.size() >= k) continue;
                        if (node.left.isLeaf()) {
                            node.left.searchKNN(query, k, list, x, qi);
                            continue;
                        }
                        curNode_stack.push((VPNode)node.left);
                        continue;
                    }
                    if (!node.searchInRight(x, tau) && list.size() >= k) continue;
                    if (node.right.isLeaf()) {
                        node.right.searchKNN(query, k, list, x, qi);
                        continue;
                    }
                    curNode_stack.push((VPNode)node.right);
                    continue;
                }
                node = (VPNode)curNode_stack.pop();
                x = distToParrent_stack.pop();
                tau = ((IndexDistPair)list.get(list.size() - 1)).getDist();
                Boolean finishLeft = search_left_stack.pop();
                if (finishLeft.booleanValue()) {
                    if (!node.searchInLeft(x, tau) && list.size() >= k) continue;
                    if (node.left.isLeaf()) {
                        node.left.searchKNN(query, k, list, x, qi);
                        continue;
                    }
                    curNode_stack.push((VPNode)node.left);
                    continue;
                }
                if (!node.searchInRight(x, tau) && list.size() >= k) continue;
                if (node.right.isLeaf()) {
                    node.right.searchKNN(query, k, list, x, qi);
                    continue;
                }
                curNode_stack.push((VPNode)node.right);
            }
        }

        public void searchKNN_recurse(Vec query, int k, BoundedSortedList<IndexDistPair> list, double x, List<Double> qi) {
            x = SVPTree.this.dm.dist(this.p, query, qi, SVPTree.this.allVecs, SVPTree.this.distCache);
            if (list.size() < k || x < ((IndexDistPair)list.get(k - 1)).getDist()) {
                list.add(new IndexDistPair(this.p, x));
            }
            double tau = ((IndexDistPair)list.get(list.size() - 1)).getDist();
            double middle = (this.left_high + this.right_low) * 0.5;
            if (x < middle) {
                if (this.searchInLeft(x, tau) || list.size() < k) {
                    this.left.searchKNN(query, k, list, x, qi);
                }
                if (this.searchInRight(x, tau = ((IndexDistPair)list.get(list.size() - 1)).getDist()) || list.size() < k) {
                    this.right.searchKNN(query, k, list, x, qi);
                }
            } else {
                if (this.searchInRight(x, tau) || list.size() < k) {
                    this.right.searchKNN(query, k, list, x, qi);
                }
                if (this.searchInLeft(x, tau = ((IndexDistPair)list.get(list.size() - 1)).getDist()) || list.size() < k) {
                    this.left.searchKNN(query, k, list, x, qi);
                }
            }
        }

        @Override
        public void searchRange(Vec query, double range, List<Integer> neighbors, List<Double> distances, double x, List<Double> qi) {
            x = SVPTree.this.dm.dist(this.p, query, qi, SVPTree.this.allVecs, SVPTree.this.distCache);
            if (x <= range) {
                neighbors.add(this.p);
                distances.add(x);
            }
            if (this.searchInLeft(x, range)) {
                this.left.searchRange(query, range, neighbors, distances, x, qi);
            }
            if (this.searchInRight(x, range)) {
                this.right.searchRange(query, range, neighbors, distances, x, qi);
            }
        }

        @Override
        public TreeNode clone() {
            return new VPNode(this);
        }

        public VPNode getParrent() {
            return this.parent;
        }

        public double maxNodeDistance(IndexNode other) {
            if (other instanceof VPNode) {
                VPNode o = (VPNode)other;
                Vec ov = o.getVec(o.p);
                List<Double> qi = SVPTree.this.dm.getQueryInfo(ov);
                return SVPTree.this.dm.dist(this.p, ov, qi, SVPTree.this.allVecs, SVPTree.this.distCache) + this.right_high + o.right_high;
            }
            return Double.POSITIVE_INFINITY;
        }

        public double minNodeDistance(IndexNode other) {
            if (other instanceof VPNode) {
                VPNode o = (VPNode)other;
                Vec ov = o.getVec(o.p);
                List<Double> qi = SVPTree.this.dm.getQueryInfo(ov);
                return Math.max(SVPTree.this.dm.dist(this.p, ov, qi, SVPTree.this.allVecs, SVPTree.this.distCache) - this.right_high - o.right_high, 0.0);
            }
            return 0.0;
        }

        public double[] minMaxDistance(IndexNode other) {
            if (other instanceof VPNode) {
                VPNode o = (VPNode)other;
                Vec ov = o.getVec(o.p);
                List<Double> qi = SVPTree.this.dm.getQueryInfo(ov);
                double d = SVPTree.this.dm.dist(this.p, ov, qi, SVPTree.this.allVecs, SVPTree.this.distCache);
                return new double[]{Math.max(d - this.right_high - o.right_high, 0.0), d + this.right_high + o.right_high};
            }
            return new double[]{0.0, Double.POSITIVE_INFINITY};
        }

        @Override
        public double minNodeDistance(int other) {
            return Math.max(SVPTree.this.dm.dist(this.p, other, (List<? extends Vec>)SVPTree.this.allVecs, (List<Double>)SVPTree.this.distCache) - this.right_low, 0.0);
        }

        @Override
        public double getParentDistance() {
            return this.parent_dist;
        }

        @Override
        public double furthestPointDistance() {
            return 0.0;
        }

        @Override
        public double furthestDescendantDistance() {
            return this.right_high;
        }

        @Override
        public int numChildren() {
            return 2;
        }

        @Override
        public IndexNode getChild(int indx) {
            switch (indx) {
                case 0: {
                    return this.left;
                }
                case 1: {
                    return this.right;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Vec getVec(int indx) {
            return SVPTree.this.get(indx);
        }

        @Override
        public int numPoints() {
            return 0;
        }

        @Override
        public int getPoint(int indx) {
            throw new IndexOutOfBoundsException("VPNode has only one point, can't access index " + indx);
        }
    }

    private abstract class TreeNode
    implements Cloneable,
    Serializable,
    IndexNode {
        VPNode parent;

        private TreeNode() {
        }

        public abstract void insert(int var1, double var2);

        public abstract void searchKNN(Vec var1, int var2, BoundedSortedList<IndexDistPair> var3, double var4, List<Double> var6);

        public abstract void searchRange(Vec var1, double var2, List<Integer> var4, List<Double> var5, double var6, List<Double> var8);

        public abstract boolean isLeaf();

        public abstract TreeNode clone();
    }
}

