/*
 * Decompiled with CFR 0.152.
 */
package jsat.math;

import java.io.Serializable;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.math.FunctionVec;

public interface Function
extends Serializable {
    default public double f(double ... x) {
        return this.f(DenseVector.toDenseVec(x));
    }

    default public double f(Vec x) {
        return this.f(x, false);
    }

    public double f(Vec var1, boolean var2);

    public static FunctionVec forwardDifference(Function f) {
        FunctionVec fP = (x, s, parallel) -> {
            if (s == null) {
                s = x.clone();
                s.zeroOut();
            }
            double sqrtEps = Math.sqrt(2.0E-16);
            double f_x = f.f(x, parallel);
            Vec x_ph = x.clone();
            for (int i = 0; i < x.length(); ++i) {
                double h = Math.max(Math.abs(x.get(i)) * sqrtEps, 1.0E-5);
                x_ph.set(i, x.get(i) + h);
                double f_xh = f.f(x_ph, parallel);
                s.set(i, (f_xh - f_x) / h);
                x_ph.set(i, x.get(i));
            }
            return s;
        };
        return fP;
    }
}

