/*
 * Decompiled with CFR 0.152.
 */
package jsat.math;

public class TrigMath {
    public static double coth(double x) {
        double eX = Math.exp(x);
        double eNX = Math.exp(-x);
        return (eX + eNX) / (eX - eNX);
    }

    public static double sech(double x) {
        return 2.0 / (Math.exp(x) + Math.exp(-x));
    }

    public static double csch(double x) {
        return 2.0 / (Math.exp(x) - Math.exp(-x));
    }

    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double acosh(double x) {
        if (x < 1.0) {
            return Double.NaN;
        }
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static double atanh(double x) {
        if (Math.abs(x) >= 1.0) {
            return Double.NaN;
        }
        return 0.5 * Math.log((x + 1.0) / (x - 1.0));
    }

    public static double asech(double x) {
        if (x <= 0.0 || x > 1.0) {
            return Double.NaN;
        }
        return Math.log((1.0 + Math.sqrt(1.0 - x * x)) / x);
    }

    public static double acsch(double x) {
        return Math.log(1.0 / x + Math.sqrt(1.0 + x * x) / Math.abs(x));
    }

    public static double acotch(double x) {
        if (Math.abs(x) <= 1.0) {
            return Double.NaN;
        }
        return 0.5 * Math.log((x + 1.0) / (x - 1.0));
    }
}

