/*
 * Decompiled with CFR 0.152.
 */
package jsat.regression;

import java.util.Collections;
import java.util.Iterator;
import jsat.regression.RegressionDataSet;
import jsat.regression.UpdateableRegressor;
import jsat.utils.IntList;
import jsat.utils.ListUtils;

public abstract class BaseUpdateableRegressor
implements UpdateableRegressor {
    private static final long serialVersionUID = -679467882721432240L;
    private int epochs = 1;

    public void setEpochs(int epochs) {
        if (epochs < 1) {
            throw new IllegalArgumentException("epochs must be a positive value");
        }
        this.epochs = epochs;
    }

    public int getEpochs() {
        return this.epochs;
    }

    @Override
    public void train(RegressionDataSet dataSet, boolean parallel) {
        this.train(dataSet);
    }

    @Override
    public void train(RegressionDataSet dataSet) {
        BaseUpdateableRegressor.trainEpochs(dataSet, this, this.epochs);
    }

    public static void trainEpochs(RegressionDataSet dataSet, UpdateableRegressor toTrain, int epochs) {
        if (epochs < 1) {
            throw new IllegalArgumentException("epochs must be positive");
        }
        toTrain.setUp(dataSet.getCategories(), dataSet.getNumNumericalVars());
        IntList randomOrder = new IntList(dataSet.size());
        ListUtils.addRange(randomOrder, 0, dataSet.size(), 1);
        for (int epoch = 0; epoch < epochs; ++epoch) {
            Collections.shuffle(randomOrder);
            Iterator iterator = randomOrder.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                toTrain.update(dataSet.getDataPoint(i), dataSet.getWeight(i), dataSet.getTargetValue(i));
            }
        }
    }

    @Override
    public abstract UpdateableRegressor clone();
}

