/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;

public class IntSetFixedSize
extends AbstractSet<Integer>
implements Serializable {
    private static final long serialVersionUID = 7743166074116253587L;
    private static final int STOP = -1;
    private int nnz = 0;
    private int first = -1;
    private boolean[] has;
    private int[] prev;
    private int[] next;

    public IntSetFixedSize(int size) {
        this.has = new boolean[size];
        this.prev = new int[size];
        this.next = new int[size];
        this.first = -1;
    }

    @Override
    public boolean add(Integer e) {
        return this.add((int)e);
    }

    @Override
    public boolean add(int e) {
        if (e < 0 || e >= this.has.length) {
            throw new IllegalArgumentException("Input must be in range [0, " + this.has.length + ") not " + e);
        }
        if (this.contains(e)) {
            return false;
        }
        if (this.nnz == 0) {
            this.first = e;
            this.prev[e] = -1;
            this.next[e] = -1;
        } else {
            this.prev[this.first] = e;
            this.next[e] = this.first;
            this.prev[e] = -1;
            this.first = e;
        }
        ++this.nnz;
        this.has[e] = true;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Integer) {
            return this.remove_int((Integer)o);
        }
        return super.remove(o);
    }

    public boolean remove(int val) {
        return this.remove_int(val);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            int val = (Integer)o;
            return this.contains(val);
        }
        return false;
    }

    public boolean contains(int val) {
        if (val < 0 || val >= this.has.length) {
            return false;
        }
        return this.has[val];
    }

    private boolean remove_int(int index) {
        if (this.contains(index)) {
            if (this.first == index) {
                this.first = this.next[index];
            } else {
                this.next[this.prev[index]] = this.next[index];
            }
            if (this.next[index] != -1) {
                this.prev[this.next[index]] = this.prev[index];
            }
            this.next[index] = -1;
            this.has[index] = false;
            --this.nnz;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        Iterator<Integer> iterator = new Iterator<Integer>(){
            int prev = -1;
            int runner = IntSetFixedSize.access$000(IntSetFixedSize.this);

            @Override
            public boolean hasNext() {
                return this.runner != -1;
            }

            @Override
            public Integer next() {
                this.prev = this.runner;
                this.runner = IntSetFixedSize.this.next[this.runner];
                return this.prev;
            }

            @Override
            public void remove() {
                IntSetFixedSize.this.remove_int(this.prev);
            }
        };
        return iterator;
    }

    @Override
    public int size() {
        return this.nnz;
    }

    static /* synthetic */ int access$000(IntSetFixedSize x0) {
        return x0.first;
    }
}

