/*
 * Decompiled with CFR 0.152.
 */
package mgo.evolution.algorithm;

import cats.Invariant;
import cats.Semigroupal;
import cats.implicits$;
import cats.kernel.Order;
import java.io.Serializable;
import mgo.evolution.C;
import mgo.evolution.D;
import mgo.evolution.algorithm.GenomeVectorDouble$;
import mgo.evolution.algorithm.NSGA3Operations;
import mgo.evolution.algorithm.NSGA3Operations$DiscreteUnitSimplex$;
import mgo.evolution.algorithm.NSGA3Operations$Fraction$;
import mgo.evolution.algorithm.NSGA3Operations$Point$;
import mgo.evolution.algorithm.NSGA3Operations$ReferencePoints$;
import mgo.evolution.algorithm.package$package$;
import mgo.evolution.breeding$;
import mgo.evolution.elitism$;
import mgo.tools.CanContainNaN$;
import mgo.tools.ImplementEqualMethod$;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.CombinatoricsUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

public final class NSGA3Operations$
implements Serializable {
    public static final NSGA3Operations$ReferencePoints$ ReferencePoints;
    public static final NSGA3Operations$Fraction$ Fraction;
    public static final NSGA3Operations$Point$ Point;
    public static final NSGA3Operations$DiscreteUnitSimplex$ DiscreteUnitSimplex;
    public static final NSGA3Operations$ MODULE$;

    private NSGA3Operations$() {
    }

    static {
        MODULE$ = new NSGA3Operations$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NSGA3Operations$.class);
    }

    public int numberOfReferencePoints(int divisions, int dimension) {
        return (int)CombinatoricsUtils.binomialCoefficient(dimension + divisions - 1, divisions);
    }

    public Vector<Vector<Object>> simplexRefPoints(int divisions, int dimension) {
        return (Vector)NSGA3Operations$DiscreteUnitSimplex$.MODULE$.apply(dimension, divisions).points().map((Function1 & Serializable)_$17 -> _$17.toDoubleVector());
    }

    public <S, I, G> Function3<S, Vector<I>, Random, Vector<G>> adaptiveBreeding(Function1<I, Vector<Object>> fitness, Function1<I, G> genome, Function1<G, double[]> continuousValues, Function1<G, Option<Object>> continuousOperator, Function1<G, int[]> discreteValues, Function1<G, Option<Object>> discreteOperator, Vector<C> continuous, Vector<D> discrete, Function4<double[], Option<Object>, int[], Option<Object>, G> buildGenome, Option<Function1<G, Object>> reject, double operatorExploration, int lambda) {
        return (Function3 & Serializable)(s, population, rng) -> {
            Map<Object, Object> continuousOperatorStatistics = package$package$.MODULE$.operatorProportions(genome.andThen(continuousOperator), population);
            Map<Object, Object> discreteOperatorStatistics = package$package$.MODULE$.operatorProportions(genome.andThen(discreteOperator), population);
            Function1 genomeValue = genome.andThen((Function1)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply((Object)continuousValues, (Object)discreteValues)).tupled((Invariant)implicits$.MODULE$.catsStdMonadForFunction1(), (Semigroupal)implicits$.MODULE$.catsStdMonadForFunction1()));
            int breededsize = lambda == -1 ? 2 * population.size() : lambda;
            return (Vector)breeding$.MODULE$.breed(this.breedTwo$1(genomeValue, continuousOperatorStatistics, discreteOperatorStatistics, continuous, discrete, operatorExploration, buildGenome), breededsize, reject).apply(s, population, rng);
        };
    }

    public int adaptiveBreeding$default$12() {
        return -1;
    }

    public <S, I> Function4<S, Vector<I>, Vector<I>, Random, Tuple2<S, Vector<I>>> elitism(Function1<I, Vector<Object>> fitness, Function1<I, Tuple2<double[], int[]>> values, NSGA3Operations.ReferencePoints references, int mu) {
        return (Function4 & Serializable)(s, population, candidates, rng) -> Tuple2$.MODULE$.apply(s, MODULE$.eliteWithReference(GenomeVectorDouble$.MODULE$.filterNaN(elitism$.MODULE$.keepFirst(values, population, candidates, ImplementEqualMethod$.MODULE$.given_ImplementEqualMethod_T1_T2(ImplementEqualMethod$.MODULE$.given_ImplementEqualMethod_IArray(x -> Predef$.MODULE$.identity((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x)))), ImplementEqualMethod$.MODULE$.given_ImplementEqualMethod_IArray(x -> Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x)))))), fitness, CanContainNaN$.MODULE$.given_CanContainNaN_Vector(CanContainNaN$.MODULE$.given_CanContainNaN_Double())), fitness, references, mu, (Random)rng));
    }

    public <I> Vector<Tuple3<Vector<I>, Vector<Vector<Object>>, Vector<Object>>> successiveFronts(Vector<I> population, Function1<I, Vector<Object>> fitness) {
        if (population.isEmpty()) {
            return package$.MODULE$.Vector().empty();
        }
        Vector fitnesses = (Vector)population.map(fitness);
        Map fitnessmap = ((IterableOnceOps)population.zip((IterableOnce)fitnesses)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Vector frontnums = (Vector)((Tuple3)package$.MODULE$.Iterator().iterate((Object)Tuple3$.MODULE$.apply(population, (Object)package$.MODULE$.Vector().empty(), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable)state -> this.extractNextFront$1(fitnessmap, (Tuple3)state)).takeWhile((Function1 & Serializable)_$18 -> ((IterableOnceOps)_$18._1()).nonEmpty()).toSeq().last())._2();
        return (Vector)((StrictOptimizedIterableOps)((IterableOps)((IterableOps)frontnums.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).zip((IterableOnce)fitnesses)).zipWithIndex()).groupBy((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22;
            Tuple2 tuple23 = x$1;
            if (tuple23 != null && (tuple22 = (Tuple2)tuple23._1()) != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                int d = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return d;
            }
            throw new MatchError((Object)tuple23);
        }).toVector().sortBy((Function1 & Serializable)_$19 -> BoxesRunTime.unboxToInt((Object)_$19._1()), implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForInt()))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Iterable v = (Iterable)tuple2._2();
                return Tuple3$.MODULE$.apply((Object)((IterableOnceOps)v.map((Function1 & Serializable)_$20 -> ((Tuple2)((Tuple2)_$20._1())._1())._1())).toVector(), (Object)((IterableOnceOps)v.map((Function1 & Serializable)_$21 -> (Vector)((Tuple2)_$21._1())._2())).toVector(), (Object)((IterableOnceOps)v.unzip(Predef$.MODULE$.$conforms())._2()).toVector());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <S, I> Vector<I> eliteWithReference(Vector<I> population, Function1<I, Vector<Object>> fitness, NSGA3Operations.ReferencePoints references, int mu, Random rng) {
        if (population.size() <= 1) {
            return population;
        }
        Vector<Tuple3<Vector<I>, Vector<Vector<Object>>, Vector<Object>>> allfronts = this.successiveFronts(population, fitness);
        if (allfronts.size() == 0) {
            return population;
        }
        Vector fronts = (Vector)allfronts.map((Function1 & Serializable)_$22 -> (Vector)_$22._1());
        Vector fitnesses = (Vector)allfronts.map((Function1 & Serializable)_$23 -> (Vector)_$23._2());
        Vector frontindices = (Vector)allfronts.map((Function1 & Serializable)_$24 -> (Vector)_$24._3());
        Vector allfitnesses = (Vector)fitnesses.reduce((Function2 & Serializable)(_$25, _$26) -> (Vector)_$25.$plus$plus((IterableOnce)_$26));
        if (BoxesRunTime.unboxToInt((Object)((IterableOnceOps)allfitnesses.map((Function1 & Serializable)_$27 -> _$27.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / allfitnesses.length() != BoxesRunTime.unboxToInt((Object)((IterableOnceOps)references.references().map((Function1 & Serializable)_$28 -> _$28.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / references.references().length()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Incompatible dimension between objectives and reference points");
        }
        int targetSize = mu;
        if (BoxesRunTime.unboxToInt((Object)((IterableOnceOps)fronts.map((Function1 & Serializable)_$29 -> _$29.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) < targetSize) {
            return (Vector)fronts.flatten(Predef$.MODULE$.$conforms());
        }
        ArrayBuffer res = new ArrayBuffer();
        ArrayBuffer cumsizes = new ArrayBuffer();
        cumsizes.append((Object)BoxesRunTime.boxToInteger((int)0));
        ArrayBuffer cumpops = new ArrayBuffer();
        cumpops.append((Object)package$.MODULE$.Vector().empty());
        fronts.foreach((Function1 & Serializable)i -> {
            if (res.size() < targetSize) {
                res.appendAll((IterableOnce)i);
            }
            cumsizes.append((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)cumsizes.last()) + i.size())));
            return (ArrayBuffer)cumpops.append(((IterableOps)cumpops.last()).$plus$plus((IterableOnce)i));
        });
        if (res.size() == targetSize) {
            return res.toVector();
        }
        int lastfrontindex = ((Tuple2)((IterableOnceOps)((StrictOptimizedIterableOps)cumsizes.tail()).zipWithIndex()).find((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int d = tuple2._1$mcI$sp();
                return d > targetSize;
            }
            throw new MatchError((Object)tuple2);
        }).get())._2$mcI$sp();
        Vector lastfrontinds = (Vector)frontindices.apply(lastfrontindex);
        Vector provpop = lastfrontindex > 0 ? (Vector)((ArrayBuffer)cumpops.tail()).apply(lastfrontindex - 1) : package$.MODULE$.Vector().empty();
        Tuple2<Vector<Vector<Object>>, Vector<Vector<Object>>> tuple2 = this.normalize((Vector<Vector<Object>>)allfitnesses, references);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector normfitnesses = (Vector)tuple2._1();
        Vector normreferences = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)normfitnesses, (Object)normreferences);
        Vector normfitnesses2 = (Vector)tuple22._1();
        Vector normreferences2 = (Vector)tuple22._2();
        Vector<I> additionalPoints = this.referenceNichingSelection((Vector<Vector<Object>>)this.filter$1(normfitnesses2, lastfrontinds), (Vector<Vector<Object>>)normreferences2, this.filter$1(population, lastfrontinds), targetSize - provpop.size(), rng);
        return (Vector)provpop.$plus$plus(additionalPoints);
    }

    public Tuple2<Vector<Vector<Object>>, Vector<Vector<Object>>> normalize(Vector<Vector<Object>> fitnesses, NSGA3Operations.ReferencePoints references) {
        Tuple2<Vector<Vector<Object>>, Vector<Vector<Object>>> tuple2 = this.translateAndMaxPoints(fitnesses);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector translated = (Vector)tuple2._1();
        Vector maxpoints = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)translated, (Object)maxpoints);
        Vector translated2 = (Vector)tuple22._1();
        Vector maxpoints2 = (Vector)tuple22._2();
        Vector<Object> intercepts = this.simplexIntercepts((Vector<Vector<Object>>)maxpoints2);
        return Tuple2$.MODULE$.apply(this.normalizeMax((Vector<Vector<Object>>)translated2, intercepts), this.computeReferencePoints(references, intercepts));
    }

    public Tuple2<Vector<Vector<Object>>, Vector<Vector<Object>>> translateAndMaxPoints(Vector<Vector<Object>> fitnesses) {
        int d = ((Vector)fitnesses.apply(0)).length();
        Vector idealValues = (Vector)((StrictOptimizedIterableOps)fitnesses.transpose(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)_$31 -> BoxesRunTime.unboxToDouble((Object)_$31.min(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble()))));
        Vector translated = (Vector)fitnesses.map((Function1 & Serializable)_$32 -> (Vector)((StrictOptimizedIterableOps)_$32.zip((IterableOnce)idealValues)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double f = tuple2._1$mcD$sp();
                double mi = tuple2._2$mcD$sp();
                return f - mi;
            }
            throw new MatchError((Object)tuple2);
        }));
        Vector weights = (Vector)package$.MODULE$.Vector().tabulate(d, d, (Function2)(JFunction2.mcDII.sp & Serializable)(x$1, x$2) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x$1, x$2);
            if (sp2 != null) {
                int j;
                int i = sp2._1$mcI$sp();
                if (i == (j = sp2._2$mcI$sp())) {
                    return 1.0;
                }
                return 1.0E-6;
            }
            throw new MatchError((Object)sp2);
        });
        return Tuple2$.MODULE$.apply((Object)translated, (Object)this.maxPoints$2(weights, translated));
    }

    public Vector<Object> simplexIntercepts(Vector<Vector<Object>> maxPoints) {
        Vector dimflatness = (Vector)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)maxPoints.transpose(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)_$38 -> BoxesRunTime.unboxToDouble((Object)_$38.max(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble()))))).zip((IterableOnce)((StrictOptimizedIterableOps)maxPoints.transpose(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)_$39 -> BoxesRunTime.unboxToDouble((Object)_$39.min(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble())))))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double ma = tuple2._1$mcD$sp();
                double mi = tuple2._2$mcD$sp();
                return ma - mi;
            }
            throw new MatchError((Object)tuple2);
        });
        Vector modifinds = (Vector)((StrictOptimizedIterableOps)dimflatness.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double delta = tuple2._1$mcD$sp();
                int d = tuple2._2$mcI$sp();
                if (delta != 0.0) {
                    return None$.MODULE$;
                }
                Vector norms = (Vector)maxPoints.map((Function1 & Serializable)_$40 -> BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((StrictOptimizedIterableOps)_$40.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        double x = tuple2._1$mcD$sp();
                        int dd = tuple2._2$mcI$sp();
                        if (dd == d) {
                            return 0.0;
                        }
                        return x * x;
                    }
                    throw new MatchError((Object)tuple2);
                })).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(norms.min(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble())), norms.max(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble())));
                double mi = tuple22._1$mcD$sp();
                double ma = tuple22._2$mcD$sp();
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)norms.indexOf((Object)BoxesRunTime.boxToDouble((double)mi))), (Object)BoxesRunTime.boxToInteger((int)norms.indexOf((Object)BoxesRunTime.boxToDouble((double)ma)))));
            }
            throw new MatchError((Object)tuple2);
        });
        Vector correctedPoints = (Vector)((StrictOptimizedIterableOps)maxPoints.zipWithIndex()).map((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Vector p = (Vector)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return (Vector)((StrictOptimizedIterableOps)p.zip((IterableOnce)modifinds)).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        double d = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                        Option option = (Option)tuple2._2();
                        double x = d;
                        if (None$.MODULE$.equals(option)) {
                            return x;
                        }
                        double x2 = d;
                        if (option instanceof Some && (tuple22 = (Tuple2)((Some)option).value()) != null) {
                            int imin = tuple22._1$mcI$sp();
                            if (imin == i) {
                                return (double)2 * x2;
                            }
                            double x3 = d;
                            int imax = tuple22._2$mcI$sp();
                            if (imax == i) {
                                return x3 / (double)2;
                            }
                        }
                        double x4 = d;
                        return x4;
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
        Vector lastPoint = (Vector)correctedPoints.apply(correctedPoints.length() - 1);
        int dim = lastPoint.size();
        Vector translated = (Vector)correctedPoints.map((Function1 & Serializable)_$41 -> (Vector)((StrictOptimizedIterableOps)_$41.zip((IterableOnce)lastPoint)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double xij = tuple2._1$mcD$sp();
                double x1j = tuple2._2$mcD$sp();
                return xij - x1j;
            }
            throw new MatchError((Object)tuple2);
        }));
        IndexedSeq coefs = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), dim).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)translated.dropRight(1).map((Function1 & Serializable)_$42 -> (double[])_$42.toArray(ClassTag$.MODULE$.apply(Double.TYPE)))).toArray(ClassTag$.MODULE$.apply(Double.TYPE).wrap()));
            return new LUDecomposition(MatrixUtils.createRealMatrix((double[][])ArrayOps$.MODULE$.$plus$plus$extension(object, Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new double[][]{(double[])Array$.MODULE$.tabulate(dim, (Function1)(JFunction1.mcDI.sp & Serializable)j -> {
                if (j == i) {
                    return 1.0;
                }
                return 0.0;
            }, ClassTag$.MODULE$.apply(Double.TYPE))}), ClassTag$.MODULE$.apply(Double.TYPE).wrap()), ClassTag$.MODULE$.apply(Double.TYPE).wrap()))).getDeterminant();
        });
        Vector intercepts = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), dim).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> BoxesRunTime.unboxToDouble((Object)lastPoint.apply(i)) + BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IndexedSeqOps)((IterableOps)((IterableOps)coefs.zip((IterableOnce)lastPoint)).zipWithIndex()).filter((Function1 & Serializable)c -> BoxesRunTime.unboxToInt((Object)c._2()) != i)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                double c = tuple2._1$mcD$sp();
                double x = tuple2._2$mcD$sp();
                return c * x / BoxesRunTime.unboxToDouble((Object)coefs.apply(i));
            }
            throw new MatchError((Object)tuple22);
        })).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).toVector();
        if (intercepts.exists((Function1)(JFunction1.mcZD.sp & Serializable)_$43 -> Predef$.MODULE$.double2Double(_$43).isNaN())) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Simplex intercepts have NaN");
        }
        return intercepts;
    }

    public Vector<Vector<Object>> normalizeMax(Vector<Vector<Object>> points, Vector<Object> maxvals) {
        return (Vector)((IterableOps)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)points.transpose(Predef$.MODULE$.$conforms())).zip(maxvals)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Vector p = (Vector)tuple2._1();
                double m = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                return (Vector)p.map((Function1)(JFunction1.mcDD.sp & Serializable)_$44 -> _$44 / m);
            }
            throw new MatchError((Object)tuple2);
        })).transpose(Predef$.MODULE$.$conforms());
    }

    public Vector<Vector<Object>> computeReferencePoints(NSGA3Operations.ReferencePoints references, Vector<Object> intercepts) {
        NSGA3Operations.ReferencePoints referencePoints = references;
        if (referencePoints != null) {
            NSGA3Operations.ReferencePoints referencePoints2 = NSGA3Operations$ReferencePoints$.MODULE$.unapply(referencePoints);
            Vector<Vector<Object>> vector = referencePoints2._1();
            boolean bl = referencePoints2._2();
            Vector<Vector<Object>> r = vector;
            if (!bl) {
                return this.normalizeMax(r, intercepts);
            }
            Vector<Vector<Object>> r2 = vector;
            if (bl) {
                return r2;
            }
        }
        throw new MatchError((Object)referencePoints);
    }

    public <S, I> Vector<I> referenceNichingSelection(Vector<Vector<Object>> normalizedFitnesses, Vector<Vector<Object>> normalizedReferences, Vector<I> population, int pointsNumber, Random rng) {
        Map<I, Tuple2<Object, Object>> assocMap = this.associateReferencePoints(normalizedFitnesses, normalizedReferences, population);
        Tuple2<Map<I, Tuple2<Object, Object>>, Vector<Tuple2<I, Object>>> tuple2 = this.pointsSelection(assocMap, package$.MODULE$.Vector().empty(), pointsNumber, rng);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map finalAssocMap = (Map)tuple2._1();
        Vector selected = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)finalAssocMap, (Object)selected);
        Map finalAssocMap2 = (Map)tuple22._1();
        Vector selected2 = (Vector)tuple22._2();
        return (Vector)selected2.map((Function1 & Serializable)_$45 -> _$45._1());
    }

    public <I> Map<I, Tuple2<Object, Object>> associateReferencePoints(Vector<Vector<Object>> points, Vector<Vector<Object>> references, Vector<I> population) {
        if (!BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)references.map((Function1 & Serializable)_$46 -> ((SeqOps)_$46.filter((Function1)(JFunction1.mcZD.sp & Serializable)_$47 -> Predef$.MODULE$.double2Double(_$47).isNaN())).isEmpty())).reduce((Function2 & Serializable)(_$48, _$49) -> NSGA3Operations$.associateReferencePoints$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)_$48), BoxesRunTime.unboxToBoolean((Object)_$49))))) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Ref points have NaN");
        }
        Vector refnormsquared = (Vector)references.map((Function1 & Serializable)_$50 -> BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)_$50.map((Function1)(JFunction1.mcDD.sp & Serializable)x -> x * x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        return ((IterableOnceOps)((StrictOptimizedIterableOps)points.zip(population)).map((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Vector point = (Vector)tuple2._1();
                Object individual = tuple2._2();
                IndexedSeq dists = references.indices().map((Function1)(JFunction1.mcDI.sp & Serializable)i -> {
                    Vector projected = this.proj$1(references, refnormsquared, i, point);
                    return scala.math.package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((StrictOptimizedIterableOps)point.zip((IterableOnce)projected)).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            double x = tuple2._1$mcD$sp();
                            double y = tuple2._2$mcD$sp();
                            return (x - y) * (x - y);
                        }
                        throw new MatchError((Object)tuple2);
                    })).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
                });
                double mindist = BoxesRunTime.unboxToDouble((Object)dists.min(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble())));
                return Tuple2$.MODULE$.apply(individual, (Object)Tuple2$.MODULE$.apply(((IndexedSeqOps)((IndexedSeqOps)((IterableOps)dists.zipWithIndex()).filter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        double d = tuple2._1$mcD$sp();
                        return d == mindist;
                    }
                    throw new MatchError((Object)tuple2);
                })).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        int j = tuple2._2$mcI$sp();
                        return j;
                    }
                    throw new MatchError((Object)tuple2);
                })).head(), (Object)BoxesRunTime.boxToDouble((double)mindist)));
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <I> Tuple2<Map<I, Tuple2<Object, Object>>, Vector<Tuple2<I, Object>>> pointsSelection(Map<I, Tuple2<Object, Object>> associationMap, Vector<Tuple2<I, Object>> selected, int toselect, Random rng) {
        int n;
        int n2;
        while ((n2 = (n = toselect)) != 0) {
            Map selectedRefCount = ((IterableOnceOps)selected.groupBy((Function1 & Serializable)_$52 -> BoxesRunTime.unboxToInt((Object)_$52._2())).toSeq().map((Function1 & Serializable)g -> Tuple2$.MODULE$.apply(g._1(), (Object)BoxesRunTime.boxToInteger((int)((SeqOps)g._2()).size())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map refCount = ((IterableOnceOps)((StrictOptimizedIterableOps)((IterableOnceOps)associationMap.toSeq().map((Function1 & Serializable)_$53 -> ((Tuple2)_$53._2())._1$mcI$sp())).toVector().distinct()).map((Function1 & Serializable)j -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)j)), selectedRefCount.getOrElse((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)j)), NSGA3Operations$::$anonfun$42$$anonfun$1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Tuple2 tuple2 = (Tuple2)refCount.toVector().minBy((Function1 & Serializable)_$54 -> _$54._2$mcI$sp(), implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForInt()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int jmin = tuple2._1$mcI$sp();
            int jmin2 = jmin;
            Map candidatePoints = (Map)associationMap.filter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    int j = tuple2._1$mcI$sp();
                    return j == jmin2;
                }
                throw new MatchError((Object)tuple22);
            });
            Object newpoint = refCount.apply$mcII$sp(jmin2) == 0 ? ((Tuple2)candidatePoints.toVector().minBy((Function1 & Serializable)_$55 -> ((Tuple2)_$55._2())._2$mcD$sp(), implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble())))._1() : ((Tuple2)candidatePoints.toVector().apply(rng.nextInt(candidatePoints.toVector().size())))._1();
            Map map = (Map)associationMap.filter((Function1 & Serializable)_$56 -> !BoxesRunTime.equals((Object)_$56._1(), (Object)newpoint));
            Vector vector = (Vector)selected.$plus$plus((IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(newpoint, (Object)BoxesRunTime.boxToInteger((int)jmin2))})));
            int n3 = toselect - 1;
            associationMap = map;
            selected = vector;
            toselect = n3;
        }
        return Tuple2$.MODULE$.apply(associationMap, selected);
    }

    public static final /* synthetic */ NSGA3Operations.Fraction mgo$evolution$algorithm$NSGA3Operations$Point$$_$$plus$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            NSGA3Operations.Fraction f1 = (NSGA3Operations.Fraction)tuple2._1();
            NSGA3Operations.Fraction f2 = (NSGA3Operations.Fraction)tuple2._2();
            return f1.$plus(f2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ NSGA3Operations.Fraction mgo$evolution$algorithm$NSGA3Operations$Point$$_$$minus$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            NSGA3Operations.Fraction f1 = (NSGA3Operations.Fraction)tuple2._1();
            NSGA3Operations.Fraction f2 = (NSGA3Operations.Fraction)tuple2._2();
            return f1.$minus(f2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double mgo$evolution$algorithm$NSGA3Operations$Point$$_$toDoubleVector$$anonfun$1(NSGA3Operations.Fraction _$6) {
        return _$6.toDouble();
    }

    public static final /* synthetic */ boolean mgo$evolution$algorithm$NSGA3Operations$Point$$_$isPositive$$anonfun$1(NSGA3Operations.Fraction _$7) {
        return _$7.isPositive();
    }

    private static final /* synthetic */ boolean isPositive$$anonfun$2(boolean _$8, boolean _$9) {
        return _$8 && _$9;
    }

    public static /* bridge */ /* synthetic */ boolean mgo$evolution$algorithm$NSGA3Operations$Point$$_$isPositive$$anonfun$adapted$1(Object _$8, Object _$9) {
        return NSGA3Operations$.isPositive$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)_$8), BoxesRunTime.unboxToBoolean((Object)_$9));
    }

    public static final /* synthetic */ NSGA3Operations.Fraction mgo$evolution$algorithm$NSGA3Operations$Point$$_$isOnSimplex$$anonfun$1(NSGA3Operations.Fraction _$10, NSGA3Operations.Fraction _$11) {
        return _$10.$plus(_$11);
    }

    public static final /* synthetic */ NSGA3Operations.Point mgo$evolution$algorithm$NSGA3Operations$DiscreteUnitSimplex$$_$embeddedPoints$$anonfun$1(int i$1, NSGA3Operations.Point _$12) {
        return _$12.embedded(i$1);
    }

    public static /* bridge */ /* synthetic */ NSGA3Operations.Fraction mgo$evolution$algorithm$NSGA3Operations$DiscreteUnitSimplex$$$_$_$$anonfun$adapted$3(int divisions$4, Object _$13) {
        return NSGA3Operations$Fraction$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)_$13), divisions$4);
    }

    public static final /* synthetic */ NSGA3Operations.Point mgo$evolution$algorithm$NSGA3Operations$DiscreteUnitSimplex$$$_$_$$anonfun$10(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            NSGA3Operations.Fraction f1 = (NSGA3Operations.Fraction)tuple2._1();
            NSGA3Operations.Fraction f2 = (NSGA3Operations.Fraction)tuple2._2();
            return NSGA3Operations$Point$.MODULE$.apply((Vector<NSGA3Operations.Fraction>)((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NSGA3Operations.Fraction[]{f1, f2}))));
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* bridge */ /* synthetic */ NSGA3Operations.Point mgo$evolution$algorithm$NSGA3Operations$DiscreteUnitSimplex$$$_$apply$$anonfun$adapted$1(int divisions$5, Object k) {
        return NSGA3Operations$Point$.MODULE$.apply((Vector<NSGA3Operations.Fraction>)((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NSGA3Operations.Fraction[]{NSGA3Operations$Fraction$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)k), divisions$5)}))));
    }

    public static final /* synthetic */ NSGA3Operations.Point mgo$evolution$algorithm$NSGA3Operations$DiscreteUnitSimplex$$$_$_$$anonfun$11(NSGA3Operations.Point origin$1, NSGA3Operations.Point _$14) {
        return _$14.$minus(origin$1);
    }

    public static final /* synthetic */ IterableOnce mgo$evolution$algorithm$NSGA3Operations$DiscreteUnitSimplex$$$_$_$$anonfun$12(Vector emb1$1, NSGA3Operations.Point origin$2, NSGA3Operations.Point vi) {
        return (IterableOnce)((StrictOptimizedIterableOps)emb1$1.map((Function1 & Serializable)_$15 -> _$15.$minus(origin$2))).map((Function1 & Serializable)vj -> origin$2.$plus(vi).$plus((NSGA3Operations.Point)vj));
    }

    public static final /* synthetic */ boolean mgo$evolution$algorithm$NSGA3Operations$DiscreteUnitSimplex$$$_$_$$anonfun$13(NSGA3Operations.Point _$16) {
        return _$16.isOnSimplex();
    }

    private final Function3 breedTwo$1(Function1 genomeValue$1, Map continuousOperatorStatistics$1, Map discreteOperatorStatistics$1, Vector continuous$7, Vector discrete$9, double operatorExploration$3, Function4 buildGenome$2) {
        return GenomeVectorDouble$.MODULE$.applyDynamicOperators(breeding$.MODULE$.randomSelection(), genomeValue$1, (Map<Object, Object>)continuousOperatorStatistics$1, (Map<Object, Object>)discreteOperatorStatistics$1, (Vector<C>)continuous$7, (Vector<D>)discrete$9, operatorExploration$3, buildGenome$2);
    }

    private final Function1 compfitness$1(Map fitnessmap$1) {
        return (Function1 & Serializable)i -> (Vector)fitnessmap$1.apply(i);
    }

    private final Tuple3 extractNextFront$1(Map fitnessmap$3, Tuple3 state) {
        Tuple3 tuple3 = state;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Vector currentPop = (Vector)tuple3._1();
        Vector frontnums = (Vector)tuple3._2();
        int currentFrontNum = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)currentPop, (Object)frontnums, (Object)BoxesRunTime.boxToInteger((int)currentFrontNum));
        Vector currentPop2 = (Vector)tuple32._1();
        Vector frontnums2 = (Vector)tuple32._2();
        int currentFrontNum2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Vector currentFront = elitism$.MODULE$.keepFirstFront(currentPop2, this.compfitness$1(fitnessmap$3));
        return Tuple3$.MODULE$.apply(currentPop2.filter((Function1 & Serializable)i -> !currentFront.contains(i)), frontnums2.$plus$plus((IterableOnce)currentFront.map((Function1 & Serializable)i -> Tuple2$.MODULE$.apply(i, (Object)BoxesRunTime.boxToInteger((int)currentFrontNum2)))), (Object)BoxesRunTime.boxToInteger((int)(currentFrontNum2 + 1)));
    }

    private final Vector filter$1(Vector v, Vector indices) {
        return (Vector)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)v.zipWithIndex()).filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return indices.contains((Object)BoxesRunTime.boxToInteger((int)i));
            }
            throw new MatchError((Object)tuple2);
        })).map((Function1 & Serializable)_$30 -> _$30._1());
    }

    private static final /* synthetic */ Vector maxPoints$2$$anonfun$3(Vector values$tailLocal1$2, int _$37) {
        return (Vector)values$tailLocal1$2.apply(_$37);
    }

    private final Vector maxPoints$2(Vector weights$1, Vector values) {
        Vector maxinds;
        while ((maxinds = (Vector)weights$1.map((Function1 & Serializable)ei -> ((Tuple2)((IterableOnceOps)((StrictOptimizedIterableOps)values.map((Function1 & Serializable)xi -> BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((StrictOptimizedIterableOps)xi.zip((IterableOnce)ei)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double xij = tuple2._1$mcD$sp();
                double eij = tuple2._2$mcD$sp();
                return xij * eij;
            }
            throw new MatchError((Object)tuple2);
        })).max(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble()))))).zipWithIndex()).maxBy((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double dd = tuple2._1$mcD$sp();
                return dd;
            }
            throw new MatchError((Object)tuple2);
        }, implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble())))._2$mcI$sp())).toSet().size() < maxinds.size()) {
            Seq ginds = maxinds.groupBy((Function1)(JFunction1.mcII.sp & Serializable)i -> i).toSeq();
            int removedind = BoxesRunTime.unboxToInt((Object)((Tuple2)ginds.apply(((SeqOps)ginds.map((Function1 & Serializable)_$33 -> ((SeqOps)_$33._2()).size())).indexWhere((Function1)(JFunction1.mcZI.sp & Serializable)_$34 -> _$34 > 1)))._1());
            values = (Vector)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)values.zipWithIndex()).filter((Function1 & Serializable)_$35 -> BoxesRunTime.unboxToInt((Object)_$35._2()) != removedind)).map((Function1 & Serializable)_$36 -> (Vector)_$36._1());
        }
        return (Vector)maxinds.map((Function1 & Serializable)_$37 -> NSGA3Operations$.maxPoints$2$$anonfun$3(values, BoxesRunTime.unboxToInt((Object)_$37)));
    }

    private static final /* synthetic */ boolean associateReferencePoints$$anonfun$2(boolean _$48, boolean _$49) {
        return _$48 && _$49;
    }

    private final Vector proj$1(Vector references$3, Vector refnormsquared$1, int dim, Vector x) {
        RealMatrix w = MatrixUtils.createColumnRealMatrix((double[])((IterableOnceOps)references$3.apply(dim)).toArray(ClassTag$.MODULE$.apply(Double.TYPE)));
        Object object = Predef$.MODULE$.doubleArrayOps(w.multiply(MatrixUtils.createRowRealMatrix((double[])x.toArray(ClassTag$.MODULE$.apply(Double.TYPE)))).multiply(w).getColumn(0));
        return Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcDD.sp & Serializable)_$51 -> _$51 / BoxesRunTime.unboxToDouble((Object)refnormsquared$1.apply(dim)), ClassTag$.MODULE$.apply(Double.TYPE))).toVector();
    }

    private static final int $anonfun$42$$anonfun$1() {
        return 0;
    }
}

