/*
 * Decompiled with CFR 0.152.
 */
package mgo.evolution.algorithm;

import java.io.Serializable;
import mgo.evolution.C;
import mgo.evolution.algorithm.GenomeVectorDouble$;
import mgo.evolution.algorithm.package$package$;
import mgo.evolution.elitism$;
import mgo.tools.CanContainNaN;
import mgo.tools.ImplementEqualMethod$;
import mgo.tools.Lazy;
import mgo.tools.RejectionSampler;
import mgo.tools.RejectionSampler$;
import mgo.tools.clustering.EMGMM$;
import mgo.tools.clustering.GMM;
import mgo.tools.clustering.GMM$;
import mgo.tools.clustering.HDBScan$;
import monocle.PLens;
import org.apache.commons.math3.distribution.MixtureMultivariateNormalDistribution;
import org.apache.commons.math3.stat.correlation.Covariance;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.IArray;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class PPSEOperation$
implements Serializable {
    public static final PPSEOperation$ MODULE$ = new PPSEOperation$();

    private PPSEOperation$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PPSEOperation$.class);
    }

    public double[] randomUnscaledContinuousValues(int genomeLength, Random rng) {
        return (double[])IArray.package.IArray$.MODULE$.map(IArray.package.IArray$.MODULE$.fill(genomeLength, () -> PPSEOperation$.randomUnscaledContinuousValues$$anonfun$1(rng), ClassTag$.MODULE$.apply(Function0.class)), (Function1 & Serializable)_$10 -> _$10.apply$mcD$sp(), ClassTag$.MODULE$.apply(Double.TYPE));
    }

    public RejectionSampler toSampler(Function0<Tuple2<double[], Lazy<Object>>> sample, Option<Function1<double[], Object>> reject, Vector<C> continuous, Random rng) {
        return new RejectionSampler(sample, (Function1<double[], Object>)(Function1 & Serializable)x -> this.acceptFunction$1((Option)reject, (Vector)continuous, (double[])x));
    }

    public RejectionSampler gmmToSampler(GMM gmm, Option<Function1<double[], Object>> reject, Vector<C> continuous, Random rng) {
        MixtureMultivariateNormalDistribution distribution = GMM$.MODULE$.toDistribution(gmm, rng);
        return this.toSampler((Function0<Tuple2<double[], Lazy<Object>>>)(Function0 & Serializable)() -> this.sample$2(distribution), reject, continuous, rng);
    }

    public <S, I, G> Function3<S, Vector<I>, Random, Vector<G>> breeding(Vector<C> continuous, Function1<Tuple2<double[], Object>, G> buildGenome, int lambda, Option<Function1<double[], Object>> reject, Function1<S, Option<GMM>> gmm, int warmupSampler) {
        return (Function3 & Serializable)(s2, population, rng) -> {
            Option option = (Option)gmm.apply(s2);
            if (None$.MODULE$.equals(option)) {
                RejectionSampler sampler = this.toSampler((Function0<Tuple2<double[], Lazy<Object>>>)(Function0 & Serializable)() -> this.sample$3((Vector)continuous, (Random)rng), reject, continuous, (Random)rng);
                RejectionSampler.State samplerState = RejectionSampler$.MODULE$.warmup(sampler, warmupSampler, RejectionSampler$.MODULE$.warmup$default$3());
                return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), lambda).map((Function1 & Serializable)_$13 -> this.breeding$$anonfun$3$$anonfun$1(buildGenome, (Vector)continuous, (Random)rng, BoxesRunTime.unboxToInt((Object)_$13))).toVector();
            }
            if (option instanceof Some) {
                RejectionSampler.State samplerState;
                GMM gmmValue = (GMM)((Some)option).value();
                RejectionSampler sampler = this.gmmToSampler(gmmValue, reject, continuous, (Random)rng);
                Tuple2<RejectionSampler.State, Tuple2<double[], Object>[]> tuple2 = RejectionSampler$.MODULE$.sampleArray(sampler, lambda, samplerState = RejectionSampler$.MODULE$.warmup(sampler, warmupSampler, RejectionSampler$.MODULE$.warmup$default$3()), RejectionSampler$.MODULE$.sampleArray$default$4());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object[] sampled = (Tuple2[])tuple2._2();
                Object[] sampled2 = sampled;
                Vector breed = (Vector)IArray.package.IArray$.MODULE$.wrapRefArray(sampled2).toVector().map((Function1 & Serializable)s -> buildGenome.apply((Object)Tuple2$.MODULE$.apply(s._1(), s._2())));
                return breed;
            }
            throw new MatchError((Object)option);
        };
    }

    public <S, I, P> Function4<S, Vector<I>, Vector<I>, Random, Tuple2<S, Vector<I>>> elitism(Function1<I, Tuple2<double[], Object>> values, Function1<I, P> phenotype, Function1<P, Vector<Object>> pattern, Vector<C> continuous, Option<Function1<double[], Object>> reject, PLens<S, S, Map<Vector<Object>, Object>, Map<Vector<Object>, Object>> likelihoodRatioMap, PLens<S, S, Map<Vector<Object>, Object>, Map<Vector<Object>, Object>> hitmap, PLens<S, S, Option<GMM>, Option<GMM>> gmm, int iterations, double tolerance, double dilation, int maxRareSample, int minClusterSize, double regularisationEpsilon, Option<Function1<double[], Object>> density, CanContainNaN<P> evidence$1) {
        return (Function4 & Serializable)(state, population, candidates, rng) -> {
            Map map;
            Map map2;
            int[][] nArray;
            Tuple2[] tuple2Array;
            int[][] nArray2;
            Vector newPopulation = (Vector)elitism$.MODULE$.keepNiches(phenotype.andThen(pattern), (Function1 & Serializable)i -> this.keepRandom$1((Random)rng, (Vector)i), ImplementEqualMethod$.MODULE$.given_ImplementEqualMethod_Vector(x -> Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x))))).apply(population.$plus$plus((IterableOnce)this.offSpringWithNoNan$1((Vector)candidates, phenotype, evidence$1)));
            double[][] dArray = this.genomes$3(values, newPopulation);
            Tuple3 tuple3 = this.updateState$1(dArray, nArray2 = this.patterns$3(phenotype, pattern, newPopulation), tuple2Array = (Tuple2[])((IterableOnceOps)this.offSpringWithNoNan$1((Vector)candidates, phenotype, evidence$1).map(values)).toArray(ClassTag$.MODULE$.apply(Tuple2.class)), nArray = this.patterns$3(phenotype, pattern, this.offSpringWithNoNan$1((Vector)candidates, phenotype, evidence$1)), map2 = (Map)likelihoodRatioMap.get(state), map = (Map)hitmap.get(state), maxRareSample, regularisationEpsilon, iterations, tolerance, dilation, minClusterSize, (Option)density, (Vector)continuous, (Random)rng);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Map elitedHitMap = (Map)tuple3._1();
            Map elitedDensity = (Map)tuple3._2();
            Option elitedGMM = (Option)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)elitedHitMap, (Object)elitedDensity, (Object)elitedGMM);
            Map elitedHitMap2 = (Map)tuple32._1();
            Map elitedDensity2 = (Map)tuple32._2();
            Option elitedGMM2 = (Option)tuple32._3();
            return Tuple2$.MODULE$.apply(this.state2$1(gmm, elitedGMM2, likelihoodRatioMap, elitedDensity2, hitmap, elitedHitMap2, state), (Object)newPopulation);
        };
    }

    public GMM fitGMM(double[][] points, double regularisationEpsilon, int iterations, double tolerance, int minClusterSize) {
        Tuple2 tuple2 = this.clusterize$1(points, minClusterSize);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[][] clusterMeans = (double[][])tuple2._1();
        double[][][] clusterCovariances = (double[][][])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)clusterMeans, (Object)clusterCovariances);
        double[][] clusterMeans2 = (double[][])tuple22._1();
        double[][][] clusterCovariances2 = (double[][][])tuple22._2();
        double[] clusterWeights = (double[])Array$.MODULE$.fill(clusterMeans2.length, () -> PPSEOperation$.$anonfun$32(clusterMeans2), ClassTag$.MODULE$.apply(Double.TYPE));
        int n = clusterMeans2.length;
        double d = EMGMM$.MODULE$.fit$default$9();
        Seq<Object> seq = EMGMM$.MODULE$.fit$default$10();
        return (GMM)EMGMM$.MODULE$.fit(points, clusterMeans2, clusterCovariances2, clusterWeights, n, iterations, tolerance, regularisationEpsilon, d, seq)._1();
    }

    private static final Function0 randomUnscaledContinuousValues$$anonfun$1(Random rng$2) {
        return (Function0 & Serializable)() -> rng$2.nextDouble();
    }

    private final boolean acceptPoint$1(double[] x) {
        return IArray.package.IArray$.MODULE$.forall((Object)x, (Function1)(JFunction1.mcZD.sp & Serializable)_$11 -> _$11 <= 1.0) && IArray.package.IArray$.MODULE$.forall((Object)x, (Function1)(JFunction1.mcZD.sp & Serializable)_$12 -> _$12 >= 0.0);
    }

    private static final boolean rejectValue$1$$anonfun$2() {
        return false;
    }

    private final boolean rejectValue$1(Option reject$3, double[] x$1, Vector continuous$7) {
        return BoxesRunTime.unboxToBoolean((Object)reject$3.map((Function1 & Serializable)r -> BoxesRunTime.unboxToBoolean((Object)r.apply((Object)package$package$.MODULE$.scaleContinuousValues(x$1, (Vector<C>)continuous$7)))).getOrElse(PPSEOperation$::rejectValue$1$$anonfun$2));
    }

    private final boolean acceptFunction$1(Option reject$2, Vector continuous$6, double[] x) {
        return this.acceptPoint$1(x) && !this.rejectValue$1(reject$2, x, continuous$6);
    }

    private static final double sample$2$$anonfun$1(MixtureMultivariateNormalDistribution distribution$2, double[] x$3) {
        return distribution$2.density(x$3);
    }

    private final Tuple2 sample$2(MixtureMultivariateNormalDistribution distribution$1) {
        double[] x = distribution$1.sample();
        return Tuple2$.MODULE$.apply(IArray.package.IArray$.MODULE$.unsafeFromArray((Object)x), new Lazy(() -> PPSEOperation$.sample$2$$anonfun$1(distribution$1, x)));
    }

    private static final double sample$3$$anonfun$1() {
        return 1.0;
    }

    private final Tuple2 sample$3(Vector continuous$10, Random rng$4) {
        return Tuple2$.MODULE$.apply((Object)this.randomUnscaledContinuousValues(continuous$10.size(), rng$4), new Lazy(PPSEOperation$::sample$3$$anonfun$1));
    }

    private final /* synthetic */ Object breeding$$anonfun$3$$anonfun$1(Function1 buildGenome$2, Vector continuous$11, Random rng$5, int _$13) {
        Tuple2 tuple2 = this.sample$3(continuous$11, rng$5);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[] g = (double[])tuple2._1();
        Lazy d = (Lazy)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)g, (Object)d);
        double[] g2 = (double[])tuple22._1();
        Lazy d2 = (Lazy)tuple22._2();
        return buildGenome$2.apply((Object)Tuple2$.MODULE$.apply((Object)g2, d2.value()));
    }

    private static final int $anonfun$21() {
        return 0;
    }

    private final GMM fittedGMM$1(double[][] rareIndividuals$1, int minClusterSize$2, double regularisationEpsilon$2, int iterations$2, double tolerance$2) {
        if (rareIndividuals$1.length < minClusterSize$2) {
            return GMM$.MODULE$.empty();
        }
        return this.fitGMM(rareIndividuals$1, regularisationEpsilon$2, iterations$2, tolerance$2, minClusterSize$2);
    }

    private final GMM gmmWithOutliers$1(double[][] rareIndividuals$2, double regularisationEpsilon$3, int minClusterSize$3, int iterations$3, double tolerance$3) {
        return EMGMM$.MODULE$.integrateOutliers(rareIndividuals$2, this.fittedGMM$1(rareIndividuals$2, minClusterSize$3, regularisationEpsilon$3, iterations$3, tolerance$3), regularisationEpsilon$3);
    }

    private final Option computeGMM$1(double[][] genomes, int[][] patterns, Map hitMap, int maxRareSample, double regularisationEpsilon, int iterations, double tolerance, double dilation, int minClusterSize, Random random) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])genomes);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object, (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])patterns)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)p -> {
            int hits = BoxesRunTime.unboxToInt((Object)hitMap.getOrElse((Object)Predef$.MODULE$.wrapIntArray((int[])p._2()).toVector(), PPSEOperation$::$anonfun$21));
            return hits <= maxRareSample;
        }));
        double[][] rareIndividuals = (double[][])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$14 -> (double[])_$14._1(), ClassTag$.MODULE$.apply(Double.TYPE).wrap());
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])rareIndividuals);
        None$ res = ArrayOps$.MODULE$.isEmpty$extension(object4) ? None$.MODULE$ : Some$.MODULE$.apply((Object)GMM$.MODULE$.dilate(this.gmmWithOutliers$1(rareIndividuals, regularisationEpsilon, minClusterSize, iterations, tolerance), dilation));
        return res;
    }

    private static final int updateHits$1$$anonfun$1$$anonfun$1() {
        return 0;
    }

    private final Map updateHits$1(Map m, Vector p) {
        return (Map)m.updatedWith((Object)p, (Function1 & Serializable)v -> Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)v.getOrElse(PPSEOperation$::updateHits$1$$anonfun$1$$anonfun$1)) + 1))));
    }

    private static final double $anonfun$27() {
        return 1.0;
    }

    private final Seq offSpringDensities$1(Tuple2[] offspringGenomes$3, int[][] offspringPatterns$3, Option inputDensity$2, Vector continuous$13) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])offspringGenomes$3);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object, (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])offspringPatterns$3)));
        Map groupedGenomes = ArrayOps$.MODULE$.groupMap$extension(object2, (Function1 & Serializable)_$15 -> (int[])_$15._2(), (Function1 & Serializable)_$16 -> (Tuple2)_$16._1(), ClassTag$.MODULE$.apply(Tuple2.class));
        return groupedGenomes.view().mapValues((Function1 & Serializable)v -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])v);
            return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                double[] dArray = (double[])x$1._1();
                double d = BoxesRunTime.unboxToDouble((Object)x$1._2());
                double inputDensityValue = BoxesRunTime.unboxToDouble((Object)inputDensity$2.map((Function1 & Serializable)df -> {
                    double[] scaled = package$package$.MODULE$.scaleContinuousValues(dArray, (Vector<C>)continuous$13);
                    return BoxesRunTime.unboxToDouble((Object)df.apply((Object)scaled));
                }).getOrElse(PPSEOperation$::$anonfun$27));
                return inputDensityValue / d;
            }, ClassTag$.MODULE$.apply(Double.TYPE))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        }).toSeq();
    }

    private static final double updatePatternDensity$1$$anonfun$1$$anonfun$1() {
        return 0.0;
    }

    private final Map updatePatternDensity$1(Map map, int[] pattern, double density) {
        return (Map)map.updatedWith((Object)Predef$.MODULE$.wrapIntArray(pattern).toVector(), (Function1 & Serializable)v -> Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)v.getOrElse(PPSEOperation$::updatePatternDensity$1$$anonfun$1$$anonfun$1)) + density))));
    }

    private final Map newLikelihoodRatioMap$1(Tuple2[] offspringGenomes$2, int[][] offspringPatterns$2, Option inputDensity$1, Vector continuous$12, Map likelihoodRatioMap$4) {
        return (Map)this.offSpringDensities$1(offspringGenomes$2, offspringPatterns$2, inputDensity$1, continuous$12).foldLeft((Object)likelihoodRatioMap$4, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Map map = (Map)tuple2._1();
                if (tuple22 != null) {
                    int[] pattern = (int[])tuple22._1();
                    double density = BoxesRunTime.unboxToDouble((Object)tuple22._2());
                    return this.updatePatternDensity$1(map, pattern, density);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final Option newGMM$1(double[][] genomes$2, int[][] patterns$2, Map newHitMap$1, int maxRareSample$3, double regularisationEpsilon$4, int iterations$4, double tolerance$4, double dilation$2, int minClusterSize$4, Random random$1) {
        return this.computeGMM$1(genomes$2, patterns$2, newHitMap$1, maxRareSample$3, regularisationEpsilon$4, iterations$4, tolerance$4, dilation$2, minClusterSize$4, random$1);
    }

    private final Tuple3 updateState$1(double[][] genomes, int[][] patterns, Tuple2[] offspringGenomes, int[][] offspringPatterns, Map likelihoodRatioMap, Map hitMap, int maxRareSample, double regularisationEpsilon, int iterations, double tolerance, double dilation, int minClusterSize, Option inputDensity, Vector continuous, Random random) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])offspringPatterns);
        Map newHitMap = (Map)ArrayOps$.MODULE$.foldLeft$extension(object, (Object)hitMap, (Function2 & Serializable)(m, p) -> this.updateHits$1((Map)m, Predef$.MODULE$.wrapIntArray(p).toVector()));
        return Tuple3$.MODULE$.apply((Object)newHitMap, (Object)this.newLikelihoodRatioMap$1(offspringGenomes, offspringPatterns, inputDensity, continuous, likelihoodRatioMap), (Object)this.newGMM$1(genomes, patterns, newHitMap, maxRareSample, regularisationEpsilon, iterations, tolerance, dilation, minClusterSize, random));
    }

    private final Vector offSpringWithNoNan$1(Vector candidates$1, Function1 phenotype$5, CanContainNaN evidence$1$1) {
        return GenomeVectorDouble$.MODULE$.filterNaN(candidates$1, phenotype$5, evidence$1$1);
    }

    private final Vector keepRandom$1(Random rng$6, Vector i) {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{i.apply(rng$6.nextInt(i.size()))}));
    }

    private final double[][] genomes$3(Function1 values$2, Vector p) {
        return (double[][])((IterableOnceOps)((StrictOptimizedIterableOps)p.map(values$2)).map((Function1 & Serializable)_$17 -> (double[])mgo.tools.package$package$.MODULE$.unsafeToArray(_$17._1()))).toArray(ClassTag$.MODULE$.apply(Double.TYPE).wrap());
    }

    private final int[][] patterns$3(Function1 phenotype$7, Function1 pattern$5, Vector p) {
        return (int[][])((IterableOnceOps)p.map(phenotype$7.andThen(pattern$5).andThen((Function1 & Serializable)_$18 -> (int[])_$18.toArray(ClassTag$.MODULE$.apply(Integer.TYPE))))).toArray(ClassTag$.MODULE$.apply(Integer.TYPE).wrap());
    }

    private static final Option state2$1$$anonfun$1$$anonfun$1(Option gmm$6) {
        return gmm$6;
    }

    private final Object state2$1(PLens gmm$5, Option elitedGMM$1, PLens likelihoodRatioMap$6, Map elitedDensity$1, PLens hitmap$4, Map elitedHitMap$1, Object state$1) {
        return gmm$5.modify((Function1 & Serializable)gmm -> elitedGMM$1.orElse(() -> PPSEOperation$.state2$1$$anonfun$1$$anonfun$1(gmm))).andThen(likelihoodRatioMap$6.replace((Object)elitedDensity$1)).andThen(hitmap$4.replace((Object)elitedHitMap$1)).apply(state$1);
    }

    private final double[][] covariance$1(double[][] x) {
        return new Covariance(x).getCovarianceMatrix().getData();
    }

    private final double[] computeCentroid$1(double[][] points) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])points);
        Object object2 = Predef$.MODULE$.refArrayOps(ArrayOps$.MODULE$.transpose$extension(object, Predef$.MODULE$.$conforms()));
        return (double[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x -> BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(x).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)((double[])x).length, ClassTag$.MODULE$.apply(Double.TYPE));
    }

    private final Tuple2 clusterize$1(double[][] x2, int minPoints) {
        double[][][] clusters = HDBScan$.MODULE$.clusterize(x2, minPoints);
        Object object = Predef$.MODULE$.refArrayOps((Object[])clusters);
        double[][] centroids = (double[][])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)points -> this.computeCentroid$1((double[][])points), ClassTag$.MODULE$.apply(Double.TYPE).wrap());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])clusters);
        double[][][] covariances = (double[][][])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x -> this.covariance$1((double[][])x), ClassTag$.MODULE$.apply(Double.TYPE).wrap().wrap());
        return Tuple2$.MODULE$.apply((Object)centroids, (Object)covariances);
    }

    private static final double $anonfun$32(double[][] clusterMeans$1) {
        return 1.0 / (double)clusterMeans$1.length;
    }
}

