/*
 * Decompiled with CFR 0.152.
 */
package mgo.tools.neuralnetwork;

import java.io.Serializable;
import mgo.tools.network.DirectedEdges;
import mgo.tools.network.Network$;
import mgo.tools.neuralnetwork.Feedforward;
import mgo.tools.neuralnetwork.HeterogeneousActivationFunction;
import mgo.tools.neuralnetwork.HomogeneousActivationFunction;
import mgo.tools.neuralnetwork.NeuralNetwork;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

public final class NeuralNetwork$
implements Serializable {
    public static final NeuralNetwork$ MODULE$ = new NeuralNetwork$();

    private NeuralNetwork$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NeuralNetwork$.class);
    }

    public <N, S, W> Feedforward<S, W> feedforwardSparse(IndexedSeq<N> _nodes, IndexedSeq<Object> _inputnodes, IndexedSeq<Object> _outputnodes, Seq<Tuple3<Object, Object, W>> _edges, Function1<Iterable<Tuple2<S, W>>, S> _activationfunction, IndexedSeq<S> _state) {
        Predef$.MODULE$.require(_inputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$2 -> _$2 < _nodes.length()), NeuralNetwork$::feedforwardSparse$$anonfun$2);
        Predef$.MODULE$.require(_outputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$3 -> _$3 < _nodes.length()), NeuralNetwork$::feedforwardSparse$$anonfun$4);
        Predef$.MODULE$.require(_edges.forall((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                int u = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int v = BoxesRunTime.unboxToInt((Object)tuple3._2());
                return u < _nodes.length() && v < _nodes.length();
            }
            throw new MatchError((Object)tuple3);
        }), NeuralNetwork$::feedforwardSparse$$anonfun$6);
        return new NeuralNetwork<N, S, W>(_nodes, _edges, _state, _inputnodes, _outputnodes, _activationfunction){
            private final DirectedEdges network;
            private final Vector state;
            private final Vector inputNeurons;
            private final Vector outputNeurons;
            private final Function1 activationFunction;
            {
                this.network = Network$.MODULE$.directedSparse(_nodes$4, _edges$1);
                this.state = _state$1.toVector();
                this.inputNeurons = _inputnodes$1.toVector();
                this.outputNeurons = _outputnodes$1.toVector();
                this.activationFunction = _activationfunction$1;
            }

            public DirectedEdges network() {
                return this.network;
            }

            public Vector state() {
                return this.state;
            }

            public Vector inputNeurons() {
                return this.inputNeurons;
            }

            public Vector outputNeurons() {
                return this.outputNeurons;
            }

            public Function1 activationFunction() {
                return this.activationFunction;
            }
        };
    }

    public <N, S, W> Feedforward<S, W> feedforwardSparse(IndexedSeq<N> _nodes, IndexedSeq<Object> _inputnodes, IndexedSeq<Object> _outputnodes, Seq<Tuple3<Object, Object, W>> _edges, IndexedSeq<Function1<Iterable<Tuple2<S, W>>, S>> _activationfunction, IndexedSeq<S> _state) {
        Predef$.MODULE$.require(_inputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$4 -> _$4 < _nodes.length()), NeuralNetwork$::feedforwardSparse$$anonfun$8);
        Predef$.MODULE$.require(_outputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$5 -> _$5 < _nodes.length()), NeuralNetwork$::feedforwardSparse$$anonfun$10);
        Predef$.MODULE$.require(_edges.forall((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                int u = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int v = BoxesRunTime.unboxToInt((Object)tuple3._2());
                return u < _nodes.length() && v < _nodes.length();
            }
            throw new MatchError((Object)tuple3);
        }), NeuralNetwork$::feedforwardSparse$$anonfun$12);
        return new NeuralNetwork<N, S, W>(_nodes, _edges, _state, _inputnodes, _outputnodes, _activationfunction){
            private final DirectedEdges network;
            private final Vector state;
            private final Vector inputNeurons;
            private final Vector outputNeurons;
            private final IndexedSeq activationFunction;
            {
                this.network = Network$.MODULE$.directedSparse(_nodes$8, _edges$2);
                this.state = _state$2.toVector();
                this.inputNeurons = _inputnodes$2.toVector();
                this.outputNeurons = _outputnodes$2.toVector();
                this.activationFunction = _activationfunction$2;
            }

            public DirectedEdges network() {
                return this.network;
            }

            public Vector state() {
                return this.state;
            }

            public Vector inputNeurons() {
                return this.inputNeurons;
            }

            public Vector outputNeurons() {
                return this.outputNeurons;
            }

            public IndexedSeq activationFunction() {
                return this.activationFunction;
            }
        };
    }

    public <N, S, W> Feedforward<S, W> feedforwardDense(IndexedSeq<N> _nodes, IndexedSeq<Object> _inputnodes, IndexedSeq<Object> _outputnodes, Vector<Vector<W>> _edges, Function1<Iterable<Tuple2<S, W>>, S> _activationfunction, IndexedSeq<S> _state) {
        Predef$.MODULE$.require(_edges.length() == _nodes.length() && _edges.forall((Function1 & Serializable)row -> row.length() == _nodes.length()), NeuralNetwork$::feedforwardDense$$anonfun$2);
        Predef$.MODULE$.require(_inputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$6 -> _$6 < _nodes.length()), NeuralNetwork$::feedforwardDense$$anonfun$4);
        Predef$.MODULE$.require(_outputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$7 -> _$7 < _nodes.length()), NeuralNetwork$::feedforwardDense$$anonfun$6);
        return new NeuralNetwork<N, S, W>(_nodes, _edges, _state, _inputnodes, _outputnodes, _activationfunction){
            private final DirectedEdges network;
            private final Vector state;
            private final Vector inputNeurons;
            private final Vector outputNeurons;
            private final Function1 activationFunction;
            {
                this.network = (DirectedEdges)((Object)Network$.MODULE$.directedDense(_nodes$12, _edges$3));
                this.state = _state$3.toVector();
                this.inputNeurons = _inputnodes$3.toVector();
                this.outputNeurons = _outputnodes$3.toVector();
                this.activationFunction = _activationfunction$3;
            }

            public DirectedEdges network() {
                return this.network;
            }

            public Vector state() {
                return this.state;
            }

            public Vector inputNeurons() {
                return this.inputNeurons;
            }

            public Vector outputNeurons() {
                return this.outputNeurons;
            }

            public Function1 activationFunction() {
                return this.activationFunction;
            }
        };
    }

    public <N, S, W> HomogeneousActivationFunction<S, W> recurrentSparse(IndexedSeq<N> _nodes, IndexedSeq<Object> _inputnodes, IndexedSeq<Object> _outputnodes, Seq<Tuple3<Object, Object, W>> _edges, Function1<Iterable<Tuple2<S, W>>, S> _activationfunction, Function2<S, S, Object> _change, IndexedSeq<S> _state) {
        Predef$.MODULE$.require(_inputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$8 -> _$8 < _nodes.length()), NeuralNetwork$::recurrentSparse$$anonfun$2);
        Predef$.MODULE$.require(_outputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$9 -> _$9 < _nodes.length()), NeuralNetwork$::recurrentSparse$$anonfun$4);
        Predef$.MODULE$.require(_edges.forall((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                int u = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int v = BoxesRunTime.unboxToInt((Object)tuple3._2());
                return u < _nodes.length() && v < _nodes.length();
            }
            throw new MatchError((Object)tuple3);
        }), NeuralNetwork$::recurrentSparse$$anonfun$6);
        return new NeuralNetwork<N, S, W>(_nodes, _edges, _state, _inputnodes, _outputnodes, _activationfunction, _change){
            private final Function2 _change$2;
            private final DirectedEdges network;
            private final Vector state;
            private final Vector inputNeurons;
            private final Vector outputNeurons;
            private final Function1 activationFunction;
            {
                this._change$2 = _change$1;
                this.network = Network$.MODULE$.directedSparse(_nodes$16, _edges$4);
                this.state = _state$4.toVector();
                this.inputNeurons = _inputnodes$4.toVector();
                this.outputNeurons = _outputnodes$4.toVector();
                this.activationFunction = _activationfunction$4;
            }

            public DirectedEdges network() {
                return this.network;
            }

            public Vector state() {
                return this.state;
            }

            public Vector inputNeurons() {
                return this.inputNeurons;
            }

            public Vector outputNeurons() {
                return this.outputNeurons;
            }

            public Function1 activationFunction() {
                return this.activationFunction;
            }

            public double change(Object newstate, Object oldstate) {
                return BoxesRunTime.unboxToDouble((Object)this._change$2.apply(newstate, oldstate));
            }
        };
    }

    public <N, S, W> HeterogeneousActivationFunction<S, W> recurrentSparse(IndexedSeq<N> _nodes, IndexedSeq<Object> _inputnodes, IndexedSeq<Object> _outputnodes, Seq<Tuple3<Object, Object, W>> _edges, IndexedSeq<Function1<Iterable<Tuple2<S, W>>, S>> _activationfunction, Function2<S, S, Object> _change, IndexedSeq<S> _state) {
        Predef$.MODULE$.require(_inputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$10 -> _$10 < _nodes.length()), NeuralNetwork$::recurrentSparse$$anonfun$8);
        Predef$.MODULE$.require(_outputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$11 -> _$11 < _nodes.length()), NeuralNetwork$::recurrentSparse$$anonfun$10);
        Predef$.MODULE$.require(_edges.forall((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                int u = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int v = BoxesRunTime.unboxToInt((Object)tuple3._2());
                return u < _nodes.length() && v < _nodes.length();
            }
            throw new MatchError((Object)tuple3);
        }), NeuralNetwork$::recurrentSparse$$anonfun$12);
        return new NeuralNetwork<N, S, W>(_nodes, _edges, _state, _inputnodes, _outputnodes, _activationfunction, _change){
            private final Function2 _change$4;
            private final DirectedEdges network;
            private final Vector state;
            private final Vector inputNeurons;
            private final Vector outputNeurons;
            private final IndexedSeq activationFunction;
            {
                this._change$4 = _change$3;
                this.network = Network$.MODULE$.directedSparse(_nodes$20, _edges$5);
                this.state = _state$5.toVector();
                this.inputNeurons = _inputnodes$5.toVector();
                this.outputNeurons = _outputnodes$5.toVector();
                this.activationFunction = _activationfunction$5;
            }

            public DirectedEdges network() {
                return this.network;
            }

            public Vector state() {
                return this.state;
            }

            public Vector inputNeurons() {
                return this.inputNeurons;
            }

            public Vector outputNeurons() {
                return this.outputNeurons;
            }

            public IndexedSeq activationFunction() {
                return this.activationFunction;
            }

            public double change(Object newstate, Object oldstate) {
                return BoxesRunTime.unboxToDouble((Object)this._change$4.apply(newstate, oldstate));
            }
        };
    }

    public <N, S, W> HomogeneousActivationFunction<S, W> recurrentDense(IndexedSeq<N> _nodes, IndexedSeq<Object> _inputnodes, IndexedSeq<Object> _outputnodes, Vector<Vector<W>> _edges, Function1<Iterable<Tuple2<S, W>>, S> _activationfunction, Function2<S, S, Object> _change, IndexedSeq<S> _state) {
        Predef$.MODULE$.require(_edges.length() == _nodes.length() && _edges.forall((Function1 & Serializable)row -> row.length() == _nodes.length()), NeuralNetwork$::recurrentDense$$anonfun$2);
        Predef$.MODULE$.require(_inputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$12 -> _$12 < _nodes.length()), NeuralNetwork$::recurrentDense$$anonfun$4);
        Predef$.MODULE$.require(_outputnodes.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$13 -> _$13 < _nodes.length()), NeuralNetwork$::recurrentDense$$anonfun$6);
        return new NeuralNetwork<N, S, W>(_nodes, _edges, _state, _inputnodes, _outputnodes, _activationfunction, _change){
            private final Function2 _change$6;
            private final DirectedEdges network;
            private final Vector state;
            private final Vector inputNeurons;
            private final Vector outputNeurons;
            private final Function1 activationFunction;
            {
                this._change$6 = _change$5;
                this.network = (DirectedEdges)((Object)Network$.MODULE$.directedDense(_nodes$24, _edges$6));
                this.state = _state$6.toVector();
                this.inputNeurons = _inputnodes$6.toVector();
                this.outputNeurons = _outputnodes$6.toVector();
                this.activationFunction = _activationfunction$6;
            }

            public DirectedEdges network() {
                return this.network;
            }

            public Vector state() {
                return this.state;
            }

            public Vector inputNeurons() {
                return this.inputNeurons;
            }

            public Vector outputNeurons() {
                return this.outputNeurons;
            }

            public Function1 activationFunction() {
                return this.activationFunction;
            }

            public double change(Object newstate, Object oldstate) {
                return BoxesRunTime.unboxToDouble((Object)this._change$6.apply(newstate, oldstate));
            }
        };
    }

    private static final Object feedforwardSparse$$anonfun$2() {
        return "_inputnodes refer to nodes whose indices are bigger than _nodes";
    }

    private static final Object feedforwardSparse$$anonfun$4() {
        return "_outputnodes refer to nodes whose indices are bigger than _nodes";
    }

    private static final Object feedforwardSparse$$anonfun$6() {
        return "_edges refer to nodes whose indices are bigger than _nodes";
    }

    private static final Object feedforwardSparse$$anonfun$8() {
        return "_inputnodes refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object feedforwardSparse$$anonfun$10() {
        return "_outputnodes refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object feedforwardSparse$$anonfun$12() {
        return "_edges refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object feedforwardDense$$anonfun$2() {
        return "_edges matrix size doesn't conform to _nodes size";
    }

    private static final Object feedforwardDense$$anonfun$4() {
        return "_inputnodes refer to nodes whose indices are bigger than _nodes";
    }

    private static final Object feedforwardDense$$anonfun$6() {
        return "_outputnodes refer to nodes whose indices are bigger than _nodes";
    }

    private static final Object recurrentSparse$$anonfun$2() {
        return "_inputnodes refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object recurrentSparse$$anonfun$4() {
        return "_outputnodes refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object recurrentSparse$$anonfun$6() {
        return "_edges refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object recurrentSparse$$anonfun$8() {
        return "_inputnodes refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object recurrentSparse$$anonfun$10() {
        return "_outputnodes refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object recurrentSparse$$anonfun$12() {
        return "_edges refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object recurrentDense$$anonfun$2() {
        return "_edges matrix size doesn't conform to _nodes size";
    }

    private static final Object recurrentDense$$anonfun$4() {
        return "_inputnodes refer to nodes whose indices are bigger than _nodes.length";
    }

    private static final Object recurrentDense$$anonfun$6() {
        return "_outputnodes refer to nodes whose indices are bigger than _nodes.length";
    }
}

