/*
 * Decompiled with CFR 0.152.
 */
package mgo.tools.neuralnetwork;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public interface Recurrent<S, W> {
    public static Vector activate$(Recurrent $this, int steps, Seq inputValues) {
        return $this.activate(steps, inputValues);
    }

    default public Vector<S> activate(int steps, Seq<S> inputValues) {
        return this.activateRec(steps, this.updateState((Iterable<S>)this.state(), (Iterable<Tuple2<Object, S>>)((Iterable)this.inputNeurons().zip(inputValues))));
    }

    private Vector<S> activateRec(int steps, Vector<S> state) {
        while (steps > 0) {
            int n = steps - 1;
            Vector<S> vector = this.activateOnce(state);
            steps = n;
            state = vector;
        }
        return state;
    }

    public static Tuple3 activateUntilStable$(Recurrent $this, int maxsteps, double stabilityThreshold, Seq inputValues) {
        return $this.activateUntilStable(maxsteps, stabilityThreshold, inputValues);
    }

    default public Tuple3<Object, Object, Vector<S>> activateUntilStable(int maxsteps, double stabilityThreshold, Seq<S> inputValues) {
        return this.activateUntilStableRec(maxsteps, stabilityThreshold, this.updateState((Iterable<S>)this.state(), (Iterable<Tuple2<Object, S>>)((Iterable)this.inputNeurons().zip(inputValues))), this.activateUntilStableRec$default$4(), this.activateUntilStableRec$default$5());
    }

    private Tuple3<Object, Object, Vector<S>> activateUntilStableRec(int maxsteps, double stabilityThreshold, Vector<S> state, int steps, double avgchange) {
        while (steps < maxsteps) {
            Vector<S> nextstate = this.activateOnce(state);
            double newavgchange = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)nextstate.zip(state)).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(sum, twostates) -> this.$anonfun$3(BoxesRunTime.unboxToDouble((Object)sum), (Tuple2)twostates))) / (double)state.length();
            if (newavgchange < stabilityThreshold) {
                return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)steps), (Object)BoxesRunTime.boxToDouble((double)newavgchange), nextstate);
            }
            Vector<S> vector = nextstate;
            int n = steps + 1;
            double d = newavgchange;
            state = vector;
            steps = n;
            avgchange = d;
        }
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)steps), (Object)BoxesRunTime.boxToDouble((double)avgchange), state);
    }

    private int activateUntilStableRec$default$4() {
        return 0;
    }

    private double activateUntilStableRec$default$5() {
        return 0.0;
    }

    public static Vector activateOnce$(Recurrent $this, Vector state) {
        return $this.activateOnce(state);
    }

    default public Vector<S> activateOnce(Vector<S> state) {
        return (Vector)((StrictOptimizedIterableOps)state.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object stateval = tuple2._1();
                int neuron = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Vector<Tuple2<S, W>> iaw = this.inputsAndWeights(neuron, (IndexedSeq<S>)state);
                if (iaw.isEmpty()) {
                    return stateval;
                }
                return this.activate(neuron, (Iterable<Tuple2<S, W>>)iaw);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static Vector propagate$(Recurrent $this, int steps, Seq inputValues) {
        return $this.propagate(steps, inputValues);
    }

    default public Vector<S> propagate(int steps, Seq<S> inputValues) {
        return this.propagateRec(steps, this.updateState((Iterable<S>)this.state(), (Iterable<Tuple2<Object, S>>)((Iterable)this.inputNeurons().zip(inputValues))), (IndexedSeq<Object>)this.inputNeurons());
    }

    private Vector<S> propagateRec(int steps, Vector<S> state, IndexedSeq<Object> currentNeurons) {
        while (steps > 0) {
            Tuple2<Vector<S>, Vector<Object>> tuple2 = this.propagateOnce((IndexedSeq<S>)state, (IndexedSeq<Object>)currentNeurons);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Vector nextState = (Vector)tuple2._1();
            Vector nextNeurons = (Vector)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)nextState, (Object)nextNeurons);
            Vector nextState2 = (Vector)tuple22._1();
            Vector nextNeurons2 = (Vector)tuple22._2();
            int n = steps - 1;
            Vector vector = nextState2;
            Vector vector2 = nextNeurons2;
            steps = n;
            state = vector;
            currentNeurons = vector2;
        }
        return state;
    }

    public static Tuple3 propagateUntilStable$(Recurrent $this, int maxsteps, double stabilityThreshold, Seq inputValues) {
        return $this.propagateUntilStable(maxsteps, stabilityThreshold, inputValues);
    }

    default public Tuple3<Object, Object, Vector<S>> propagateUntilStable(int maxsteps, double stabilityThreshold, Seq<S> inputValues) {
        return this.propagateUntilStableRec(maxsteps, stabilityThreshold, this.updateState((Iterable<S>)this.state(), (Iterable<Tuple2<Object, S>>)((Iterable)this.inputNeurons().zip(inputValues))), (IndexedSeq<Object>)this.inputNeurons(), this.propagateUntilStableRec$default$5(), this.propagateUntilStableRec$default$6());
    }

    public static Tuple3 propagateUntilStableRec$(Recurrent $this, int maxsteps, double stabilityThreshold, Vector state, IndexedSeq currentNeurons, int step, double avgchange) {
        return $this.propagateUntilStableRec(maxsteps, stabilityThreshold, state, (IndexedSeq<Object>)currentNeurons, step, avgchange);
    }

    default public Tuple3<Object, Object, Vector<S>> propagateUntilStableRec(int maxsteps, double stabilityThreshold, Vector<S> state, IndexedSeq<Object> currentNeurons, int step, double avgchange) {
        double newavgchange;
        if (step >= maxsteps) {
            return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)step), (Object)BoxesRunTime.boxToDouble((double)avgchange), state);
        }
        Tuple2<Vector<S>, Vector<Object>> tuple2 = this.propagateOnce((IndexedSeq<S>)state, currentNeurons);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector nextState = (Vector)tuple2._1();
        Vector nextNeurons = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)nextState, (Object)nextNeurons);
        Vector nextState2 = (Vector)tuple22._1();
        Vector nextNeurons2 = (Vector)tuple22._2();
        double d = newavgchange = nextNeurons2.isEmpty() ? 0.0 : BoxesRunTime.unboxToDouble((Object)nextNeurons2.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDI.sp & Serializable)(sum, neuron) -> sum + this.change(nextState2.apply(neuron), state.apply(neuron)))) / (double)nextNeurons2.length();
        if (newavgchange < stabilityThreshold) {
            return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)step), (Object)BoxesRunTime.boxToDouble((double)newavgchange), (Object)nextState2);
        }
        return this.propagateUntilStableRec(maxsteps, stabilityThreshold, nextState2, (IndexedSeq<Object>)nextNeurons2, step + 1, newavgchange);
    }

    public static int propagateUntilStableRec$default$5$(Recurrent $this) {
        return $this.propagateUntilStableRec$default$5();
    }

    default public int propagateUntilStableRec$default$5() {
        return 0;
    }

    public static double propagateUntilStableRec$default$6$(Recurrent $this) {
        return $this.propagateUntilStableRec$default$6();
    }

    default public double propagateUntilStableRec$default$6() {
        return 0.0;
    }

    public static Tuple2 propagateOnce$(Recurrent $this, IndexedSeq state, IndexedSeq currentNeurons) {
        return $this.propagateOnce(state, (IndexedSeq<Object>)currentNeurons);
    }

    default public Tuple2<Vector<S>, Vector<Object>> propagateOnce(IndexedSeq<S> state, IndexedSeq<Object> currentNeurons) {
        Vector nextNeurons = ((IterableOnceOps)currentNeurons.toSet().flatMap((Function1 & Serializable)n -> this.$anonfun$5(BoxesRunTime.unboxToInt((Object)n)))).toVector();
        Vector nextValues = (Vector)nextNeurons.map((Function1 & Serializable)n -> this.$anonfun$6(state, BoxesRunTime.unboxToInt((Object)n)));
        return Tuple2$.MODULE$.apply(this.updateState((Iterable<S>)state, (Iterable<Tuple2<Object, S>>)((Iterable)nextNeurons.zip((IterableOnce)nextValues))), (Object)nextNeurons);
    }

    public S activate(int var1, Iterable<Tuple2<S, W>> var2);

    public Vector<S> state();

    public Vector<Object> inputNeurons();

    public Vector<Tuple2<S, W>> inputsAndWeights(int var1, IndexedSeq<S> var2);

    public Vector<S> updateState(Iterable<S> var1, Iterable<Tuple2<Object, S>> var2);

    public Vector<Object> outNeighbours(int var1);

    public double change(S var1, S var2);

    private /* synthetic */ double $anonfun$3(double sum, Tuple2 twostates) {
        return sum + this.change(twostates._1(), twostates._2());
    }

    private /* synthetic */ IterableOnce $anonfun$5(int n) {
        return this.outNeighbours(n);
    }

    private /* synthetic */ Object $anonfun$6(IndexedSeq state$5, int n) {
        Vector<Tuple2<S, W>> iaw = this.inputsAndWeights(n, state$5);
        if (iaw.isEmpty()) {
            return state$5.apply(n);
        }
        return this.activate(n, (Iterable<Tuple2<S, W>>)iaw);
    }
}

