/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.pbs;

import gridscale.cluster.BatchScheduler;
import gridscale.cluster.HeadNode;
import gridscale.pbs.package;
import gridscale.pbs.package$;
import java.io.Serializable;
import org.openmole.plugin.environment.batch.environment.AccessControl;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.plugin.environment.batch.environment.SerializedJob;
import org.openmole.plugin.environment.batch.storage.HierarchicalStorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageInterface;
import org.openmole.plugin.environment.gridscale.GridScaleJobService$;
import org.openmole.plugin.environment.pbs.PBSEnvironment;
import org.openmole.plugin.environment.pbs.PBSEnvironment$;
import org.openmole.plugin.environment.ssh.RuntimeInstallation;
import org.openmole.plugin.environment.ssh.SharedStorage;
import org.openmole.plugin.environment.ssh.SharedStorage$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class PBSJobService<S> {
    private final S s;
    private final RuntimeInstallation<?> installation;
    private final PBSEnvironment.Parameters parameters;
    private final HeadNode headnode;
    private final AccessControl accessControl;
    private final HierarchicalStorageInterface<S> hierarchicalStorageInterface;
    private final BatchEnvironment.Services services;

    public PBSJobService(S s, String tmpDirectory, RuntimeInstallation<?> installation, PBSEnvironment.Parameters parameters, HeadNode headnode, AccessControl accessControl, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, BatchEnvironment.Services services) {
        this.s = s;
        this.installation = installation;
        this.parameters = parameters;
        this.headnode = headnode;
        this.accessControl = accessControl;
        this.hierarchicalStorageInterface = hierarchicalStorageInterface;
        this.services = services;
    }

    public AccessControl accessControl() {
        return this.accessControl;
    }

    public BatchScheduler.BatchJob submit(SerializedJob serializedJob, String outputPath, String jobDirectory, Object priority) {
        String workDirectory = (String)this.parameters.workDirectory().getOrElse(PBSJobService::$anonfun$1);
        SharedStorage.JobScript remoteScript = this.buildScript$1(jobDirectory, workDirectory, priority, serializedJob, outputPath);
        package.PBSJobDescription description = package.PBSJobDescription$.MODULE$.apply("/bin/bash " + remoteScript.path(), jobDirectory, this.parameters.queue(), this.parameters.wallTime(), this.parameters.memory(), this.parameters.nodes(), this.parameters.coreByNode().orElse(this::$anonfun$2), this.parameters.flavour());
        PBSEnvironment$.MODULE$.Log().log(PBSEnvironment$.MODULE$.Log().FINE(), () -> PBSJobService.submit$$anonfun$1(description, remoteScript));
        BatchScheduler.BatchJob id = (BatchScheduler.BatchJob)this.accessControl().apply((Function1 & Serializable)contextual$1 -> package$.MODULE$.submit(this.headnode, description), PBSJobService.given_Priority$1(priority));
        PBSEnvironment$.MODULE$.Log().log(PBSEnvironment$.MODULE$.Log().FINE(), () -> PBSJobService.submit$$anonfun$2(id));
        return id;
    }

    public byte state(BatchScheduler.BatchJob id, Object priority) {
        return BoxesRunTime.unboxToByte((Object)this.accessControl().apply((Function1 & Serializable)contextual$2 -> GridScaleJobService$.MODULE$.translateStatus(package$.MODULE$.state(this.headnode, id)), PBSJobService.given_Priority$2(priority)));
    }

    public void delete(BatchScheduler.BatchJob id, Object priority) {
        this.accessControl().apply((Function1)(JProcedure1 & Serializable)contextual$3 -> package$.MODULE$.clean(this.headnode, id), PBSJobService.given_Priority$3(priority));
    }

    public Tuple2<String, String> stdOutErr(BatchScheduler.BatchJob id, Object priority) {
        return (Tuple2)this.accessControl().apply((Function1 & Serializable)contextual$4 -> Tuple2$.MODULE$.apply((Object)package$.MODULE$.stdOut(this.headnode, id), (Object)package$.MODULE$.stdErr(this.headnode, id)), PBSJobService.given_Priority$4(priority));
    }

    private static final Object given_Priority$1(Object priority$1) {
        return priority$1;
    }

    private static final String $anonfun$1() {
        return "/tmp";
    }

    private final SharedStorage.JobScript buildScript$1(String jobDirectory$1, String workDirectory$1, Object priority$2, SerializedJob serializedJob, String outputPath) {
        return SharedStorage$.MODULE$.buildScript((Function1 & Serializable)runtime -> this.installation.apply(runtime), jobDirectory$1, workDirectory$1, this.parameters.openMOLEMemory(), serializedJob, outputPath, this.s, this.parameters.modules(), SharedStorage$.MODULE$.buildScript$default$9(), this.services.newFile(), this.services.preference(), this.hierarchicalStorageInterface, this.hierarchicalStorageInterface, PBSJobService.given_Priority$1(priority$2));
    }

    private final Option $anonfun$2() {
        return this.parameters.runtimeSetting().flatMap((Function1 & Serializable)_$1 -> _$1.threads());
    }

    private static final String submit$$anonfun$1(package.PBSJobDescription description$1, SharedStorage.JobScript remoteScript$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Submitting PBS job, PBS script:\n                 |" + package.impl$.MODULE$.toScript(description$1, "uniqId") + "\n                 |bash script:\n                 |" + remoteScript$1));
    }

    private static final String submit$$anonfun$2(BatchScheduler.BatchJob id$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Submitted PBS job with PBS script:\n                 |uniqId: " + id$1.uniqId() + "\n                 |job id: " + id$1.jobId()));
    }

    private static final Object given_Priority$2(Object priority$3) {
        return priority$3;
    }

    private static final Object given_Priority$3(Object priority$4) {
        return priority$4;
    }

    private static final Object given_Priority$4(Object priority$5) {
        return priority$5;
    }
}

