/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.client.core.git;

import org.openmole.gui.client.core.git.GitPrivateKeyAuthenticationGUI;
import org.openmole.gui.client.ext.AuthenticationPlugin;
import org.openmole.gui.client.ext.AuthenticationPluginFactory;
import org.openmole.gui.client.ext.NotificationService;
import org.openmole.gui.client.ext.ServerAPI;
import org.openmole.gui.shared.data.GitPrivateKeyAuthenticationData;
import org.openmole.gui.shared.data.GitPrivateKeyAuthenticationData$;
import org.openmole.gui.shared.data.Test;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;

public class GitPrivateKeyAuthenticationFactory
implements AuthenticationPluginFactory {
    private final ServerAPI api;

    public GitPrivateKeyAuthenticationFactory(ServerAPI api) {
        this.api = api;
    }

    public AuthenticationPlugin<GitPrivateKeyAuthenticationData> buildEmpty() {
        return new GitPrivateKeyAuthenticationGUI(this.api, GitPrivateKeyAuthenticationData$.MODULE$.empty());
    }

    public AuthenticationPlugin<GitPrivateKeyAuthenticationData> build(GitPrivateKeyAuthenticationData data) {
        return new GitPrivateKeyAuthenticationGUI(this.api, data);
    }

    public String name() {
        return "Git SSH Private key";
    }

    public Future<Seq<GitPrivateKeyAuthenticationData>> getData(Option<String> basePath, NotificationService notificationAPI) {
        return this.api.gitAuthentications(basePath);
    }

    public Future<Seq<Test>> test(GitPrivateKeyAuthenticationData data, Option<String> basePath, NotificationService notificationAPI) {
        return this.api.testGitAuthentication(data, basePath);
    }

    public Future<BoxedUnit> remove(GitPrivateKeyAuthenticationData data, Option<String> basePath, NotificationService notificationAPI) {
        return this.api.removeGitAuthentication(data, true, basePath);
    }
}

