/*
 * Decompiled with CFR 0.152.
 */
package miniclust.message;

import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.commons.codec.digest.Blake3;
import scala.Function1;
import scala.NamedTuple$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.package$;
import scala.util.Try$;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.apache.ApacheHttpClient;

public final class Tool$
implements Serializable {
    public static final Tool$ MODULE$ = new Tool$();

    private Tool$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Tool$.class);
    }

    public String hashString(String input) {
        byte[] hashBytes = Blake3.hash(input.getBytes(StandardCharsets.UTF_8));
        Object object = Predef$.MODULE$.byteArrayOps(hashBytes);
        return new StringBuilder(7).append("blake3:").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)_$1))})), ClassTag$.MODULE$.apply(String.class))).mkString()).toString();
    }

    public Tuple2<String, String> splitHash(String hash) {
        int i = hash.indexOf(":");
        if (i == -1) {
            return Tuple2$.MODULE$.apply((Object)"", (Object)hash);
        }
        return Tuple2$.MODULE$.apply((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hash), i), (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(hash), i + 1));
    }

    public String hashFile(File input) {
        Blake3 hasher = Blake3.initHash();
        byte[] buffer = new byte[65536];
        try (FileInputStream is = new FileInputStream(input);){
            int bytesRead = 0;
            while ((bytesRead = is.read(buffer)) != -1) {
                hasher.update(buffer, 0, bytesRead);
            }
        }
        byte[] hash = hasher.doFinalize(32);
        Object object = Predef$.MODULE$.byteArrayOps(hash);
        return new StringBuilder(7).append("blake3:").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)_$2))})), ClassTag$.MODULE$.apply(String.class))).mkString()).toString();
    }

    public Configuration jsonConfiguration() {
        return Configuration$.MODULE$.default().withDiscriminator("type").withDefaults().withoutStrictDecoding().withKebabCaseMemberNames().withKebabCaseConstructorNames();
    }

    public Option<String> queryExternalIP() {
        Option option;
        try (SdkHttpClient client = ApacheHttpClient.builder().connectionTimeout(Duration.ofSeconds(20L)).socketTimeout(Duration.ofSeconds(20L)).build();){
            option = Try$.MODULE$.apply(() -> Tool$.queryExternalIP$$anonfun$1(client)).toOption();
        }
        return option;
    }

    public String exceptionToString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public Tuple2<Object, Object> diskUsage(File file) {
        NamedTuple$ namedTuple$;
        long totalSpace = file.getTotalSpace();
        long usableSpace = file.getUsableSpace();
        NamedTuple$ NamedTuple$_this = namedTuple$ = NamedTuple$.MODULE$;
        Tuple2.mcJJ.sp x$proxy1 = new Tuple2.mcJJ.sp(totalSpace, usableSpace);
        return x$proxy1;
    }

    public long totalMemory() {
        String script = "awk '/MemTotal/ {print $2}' /proc/meminfo";
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(package$.MODULE$.stringSeqToProcess((Seq)((SeqOps)new .colon.colon((Object)"bash", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)script, (List)Nil$.MODULE$))))).$bang$bang().trim()));
    }

    public long availableMemory() {
        String script = "awk '/MemAvailable/ {print $2}' /proc/meminfo";
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(package$.MODULE$.stringSeqToProcess((Seq)((SeqOps)new .colon.colon((Object)"bash", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)script, (List)Nil$.MODULE$))))).$bang$bang().trim()));
    }

    public int machineCores() {
        String script = "nproc";
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(package$.MODULE$.stringSeqToProcess((Seq)((SeqOps)new .colon.colon((Object)"bash", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)script, (List)Nil$.MODULE$))))).$bang$bang().trim()));
    }

    public double machineLoad() {
        String script = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |cores=$(nproc)\n        |load_avg=$(cut -d ' ' -f1 /proc/loadavg)\n        |cpu_avg_pct=$(awk -v load=\"$load_avg\" -v cores=\"$cores\" 'BEGIN { printf(\"%.2f\", (load / cores) * 100) }')\n        |echo $cpu_avg_pct"));
        return StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(package$.MODULE$.stringSeqToProcess((Seq)((SeqOps)new .colon.colon((Object)"bash", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)script, (List)Nil$.MODULE$))))).$bang$bang().trim()));
    }

    private static final /* synthetic */ boolean queryExternalIP$$anonfun$1$$anonfun$1(char _$3) {
        return _$3 != '\n';
    }

    private static final String queryExternalIP$$anonfun$1(SdkHttpClient client$1) {
        HttpExecuteRequest httpRequest = HttpExecuteRequest.builder().request((SdkHttpRequest)SdkHttpRequest.builder().uri(URI.create("http://checkip.amazonaws.com")).method(SdkHttpMethod.GET).build()).build();
        HttpExecuteResponse response = client$1.prepareRequest(httpRequest).call();
        byte[] entity = ((InputStream)response.responseBody().get()).readAllBytes();
        return StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(new String(entity)), (Function1 & Serializable)_$3 -> Tool$.queryExternalIP$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$3)));
    }
}

