/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.async;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncRequestBodySplitConfiguration;
import software.amazon.awssdk.core.async.CloseableAsyncRequestBody;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.internal.async.SplittingPublisher;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class BufferedSplittableAsyncRequestBody
implements AsyncRequestBody {
    private final AsyncRequestBody delegate;

    private BufferedSplittableAsyncRequestBody(AsyncRequestBody delegate) {
        this.delegate = delegate;
    }

    public static BufferedSplittableAsyncRequestBody create(AsyncRequestBody delegate) {
        Validate.paramNotNull(delegate, "delegate");
        return new BufferedSplittableAsyncRequestBody(delegate);
    }

    @Override
    public Optional<Long> contentLength() {
        return this.delegate.contentLength();
    }

    @Override
    public SdkPublisher<CloseableAsyncRequestBody> splitCloseable(AsyncRequestBodySplitConfiguration splitConfiguration) {
        return SplittingPublisher.builder().asyncRequestBody(this).splitConfiguration(splitConfiguration).retryableSubAsyncRequestBodyEnabled(true).build();
    }

    @Override
    public void subscribe(Subscriber<? super ByteBuffer> s) {
        this.delegate.subscribe(s);
    }

    @Override
    public String body() {
        return this.delegate.body();
    }
}

