/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.endpointdiscovery.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.endpointdiscovery.providers.EndpointDiscoveryProvider;
import software.amazon.awssdk.utils.Logger;

@SdkProtectedApi
public class EndpointDiscoveryProviderChain
implements EndpointDiscoveryProvider {
    private static final Logger log = Logger.loggerFor(EndpointDiscoveryProviderChain.class);
    private final List<EndpointDiscoveryProvider> providers;

    public EndpointDiscoveryProviderChain(EndpointDiscoveryProvider ... providers) {
        this.providers = new ArrayList<EndpointDiscoveryProvider>(providers.length);
        Collections.addAll(this.providers, providers);
    }

    @Override
    public boolean resolveEndpointDiscovery() {
        for (EndpointDiscoveryProvider provider : this.providers) {
            try {
                return provider.resolveEndpointDiscovery();
            }
            catch (Exception e) {
                log.debug(() -> String.format("Unable to load endpoint discovery from %s:%s", provider.toString(), e.getMessage()));
            }
        }
        return false;
    }
}

