/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.SplittingTransformerConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.internal.async.ByteArraySplittingTransformer;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
public final class ByteArrayAsyncResponseTransformer<ResponseT>
implements AsyncResponseTransformer<ResponseT, ResponseBytes<ResponseT>> {
    private volatile CompletableFuture<ByteBuffer> cf;
    private volatile ResponseT response;

    @Override
    public CompletableFuture<ResponseBytes<ResponseT>> prepare() {
        this.cf = new CompletableFuture();
        return this.cf.thenApply(buffer -> ResponseBytes.fromByteBufferUnsafe(this.response, buffer));
    }

    @Override
    public void onResponse(ResponseT response) {
        this.response = response;
    }

    @Override
    public void onStream(SdkPublisher<ByteBuffer> publisher) {
        publisher.subscribe(new BaosSubscriber(this.cf));
    }

    @Override
    public void exceptionOccurred(Throwable throwable) {
        this.cf.completeExceptionally(throwable);
    }

    @Override
    public AsyncResponseTransformer.SplitResult<ResponseT, ResponseBytes<ResponseT>> split(SplittingTransformerConfiguration splitConfig) {
        CompletableFuture future = new CompletableFuture();
        ByteArraySplittingTransformer transformer = new ByteArraySplittingTransformer(this, future);
        return (AsyncResponseTransformer.SplitResult)AsyncResponseTransformer.SplitResult.builder().publisher(transformer).resultFuture(future).build();
    }

    @Override
    public String name() {
        return AsyncResponseTransformer.TransformerType.BYTES.getName();
    }

    static class DirectAccessByteArrayOutputStream
    extends ByteArrayOutputStream {
        DirectAccessByteArrayOutputStream() {
        }

        ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }
    }

    static class BaosSubscriber
    implements Subscriber<ByteBuffer> {
        private final CompletableFuture<ByteBuffer> resultFuture;
        private DirectAccessByteArrayOutputStream directAccessOutputStream = new DirectAccessByteArrayOutputStream();
        private Subscription subscription;

        BaosSubscriber(CompletableFuture<ByteBuffer> resultFuture) {
            this.resultFuture = resultFuture;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.subscription != null) {
                s.cancel();
                return;
            }
            this.subscription = s;
            this.subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            FunctionalUtils.invokeSafely(() -> {
                if (byteBuffer.hasArray()) {
                    this.directAccessOutputStream.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                } else {
                    this.directAccessOutputStream.write(BinaryUtils.copyBytesFrom(byteBuffer));
                }
            });
        }

        @Override
        public void onError(Throwable throwable) {
            this.directAccessOutputStream = null;
            this.resultFuture.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            this.resultFuture.complete(this.directAccessOutputStream.toByteBuffer());
        }
    }
}

