/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.NonRetryableException;
import software.amazon.awssdk.core.internal.async.ByteBuffersAsyncRequestBody;
import software.amazon.awssdk.core.internal.async.SubAsyncRequestBody;
import software.amazon.awssdk.core.internal.async.SubAsyncRequestBodyConfiguration;
import software.amazon.awssdk.core.internal.util.NoopSubscription;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkInternalApi
public final class RetryableSubAsyncRequestBody
implements SubAsyncRequestBody {
    private static final Logger log = Logger.loggerFor(RetryableSubAsyncRequestBody.class);
    private final SubAsyncRequestBodyConfiguration configuration;
    private final int partNumber;
    private final boolean contentLengthKnown;
    private final String sourceBodyName;
    private volatile long bufferedLength = 0L;
    private volatile ByteBuffersAsyncRequestBody bufferedAsyncRequestBody;
    private List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private final AtomicBoolean subscribeCalled = new AtomicBoolean(false);
    private final SimplePublisher<ByteBuffer> delegate = new SimplePublisher();
    private final Consumer<Long> onNumBytesReceived;
    private final Consumer<Long> onNumBytesConsumed;
    private final Object buffersLock = new Object();

    public RetryableSubAsyncRequestBody(SubAsyncRequestBodyConfiguration configuration) {
        this.configuration = Validate.paramNotNull(configuration, "configuration");
        this.partNumber = configuration.partNumber();
        this.contentLengthKnown = configuration.contentLengthKnown();
        this.sourceBodyName = configuration.sourceBodyName();
        this.onNumBytesReceived = configuration.onNumBytesReceived();
        this.onNumBytesConsumed = configuration.onNumBytesConsumed();
    }

    @Override
    public Optional<Long> contentLength() {
        return this.contentLengthKnown ? Optional.of(this.configuration.maxLength()) : Optional.of(this.bufferedLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ByteBuffer data) {
        log.trace(() -> String.format("Sending bytebuffer %s to part number %d", data, this.partNumber));
        long length = data.remaining();
        this.bufferedLength += length;
        this.onNumBytesReceived.accept(length);
        this.delegate.send(data.asReadOnlyBuffer()).whenComplete((r, t) -> {
            if (t != null) {
                this.delegate.error((Throwable)t);
            }
        });
        Object object = this.buffersLock;
        synchronized (object) {
            this.buffers.add(data.asReadOnlyBuffer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        log.debug(() -> "Received complete() for part number: " + this.partNumber);
        Object object = this.buffersLock;
        synchronized (object) {
            this.bufferedAsyncRequestBody = ByteBuffersAsyncRequestBody.of(this.buffers, this.bufferedLength);
        }
        this.delegate.complete().exceptionally(e -> {
            this.delegate.error((Throwable)e);
            return null;
        });
    }

    @Override
    public long maxLength() {
        return this.configuration.maxLength();
    }

    @Override
    public long receivedBytesLength() {
        return this.bufferedLength;
    }

    @Override
    public void subscribe(Subscriber<? super ByteBuffer> s) {
        log.debug(() -> "Subscribe for part number: " + this.partNumber);
        if (this.subscribeCalled.compareAndSet(false, true)) {
            this.delegate.subscribe(s);
        } else {
            log.debug(() -> "Resubscribe for part number " + this.partNumber);
            if (this.bufferedAsyncRequestBody == null) {
                s.onSubscribe(new NoopSubscription(s));
                s.onError(NonRetryableException.create("A retry was attempted, but data is not buffered successfully for retry for partNumber: " + this.partNumber));
                return;
            }
            this.bufferedAsyncRequestBody.subscribe(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block5: {
            try {
                log.debug(() -> "Closing current body " + this.partNumber);
                this.onNumBytesConsumed.accept(this.bufferedLength);
                if (this.bufferedAsyncRequestBody == null) break block5;
                Object object = this.buffersLock;
                synchronized (object) {
                    this.buffers.clear();
                    this.buffers = null;
                }
                this.bufferedAsyncRequestBody.close();
                this.bufferedAsyncRequestBody = null;
            }
            catch (Throwable e) {
                log.warn(() -> String.format("Unexpected error thrown from cleaning up AsyncRequestBody for part number %d, resource may be leaked", this.partNumber));
            }
        }
    }

    @Override
    public int partNumber() {
        return this.partNumber;
    }

    @Override
    public String body() {
        return this.sourceBodyName;
    }
}

