/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.useragent;

import java.util.Arrays;
import java.util.List;
import java.util.jar.JarInputStream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.internal.useragent.UserAgentConstant;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class UserAgentLangValues {
    private static final Logger log = Logger.loggerFor(UserAgentLangValues.class);

    private UserAgentLangValues() {
    }

    public static List<String> getAdditionalJvmLanguages() {
        return Arrays.asList(UserAgentLangValues.scalaVersion(), UserAgentLangValues.kotlinVersion());
    }

    public static String scalaVersion() {
        String scalaVersion = "";
        try {
            Class<?> scalaProperties = Class.forName("scala.util.Properties");
            scalaVersion = "scala";
            String version = (String)scalaProperties.getMethod("versionNumberString", new Class[0]).invoke(null, new Object[0]);
            scalaVersion = UserAgentConstant.concat(scalaVersion, version, "/");
        }
        catch (ClassNotFoundException scalaProperties) {
        }
        catch (Exception e) {
            log.trace(() -> "Exception attempting to get Scala version.", e);
        }
        return scalaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String kotlinVersion() {
        String kotlinVersion = "";
        JarInputStream kotlinJar = null;
        try {
            Class<?> kotlinUnit = Class.forName("kotlin.Unit");
            kotlinVersion = "kotlin";
            kotlinJar = new JarInputStream(kotlinUnit.getProtectionDomain().getCodeSource().getLocation().openStream());
            String version = kotlinJar.getManifest().getMainAttributes().getValue("Implementation-Version");
            kotlinVersion = UserAgentConstant.concat(kotlinVersion, version, "/");
            IoUtils.closeQuietlyV2(kotlinJar, log);
        }
        catch (ClassNotFoundException kotlinUnit) {
            IoUtils.closeQuietlyV2(kotlinJar, log);
        }
        catch (Exception e) {
            log.trace(() -> "Exception attempting to get Kotlin version.", e);
        }
        finally {
            IoUtils.closeQuietlyV2(kotlinJar, log);
        }
        return kotlinVersion;
    }
}

