/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.Chunk;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.ChunkExtensionProvider;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.ChunkHeaderProvider;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.Resettable;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.TrailerProvider;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class ChunkedEncodedInputStream
extends InputStream {
    private static final Logger LOG = Logger.loggerFor(ChunkedEncodedInputStream.class);
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] END = new byte[0];
    private static final byte[] SEMICOLON = new byte[]{59};
    private static final byte[] EQUALS = new byte[]{61};
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] COMMA = new byte[]{44};
    private final InputStream inputStream;
    private final int chunkSize;
    private final ChunkHeaderProvider header;
    private final List<ChunkExtensionProvider> extensions = new ArrayList<ChunkExtensionProvider>();
    private final List<TrailerProvider> trailers = new ArrayList<TrailerProvider>();
    private Chunk currentChunk;
    private boolean isFinished = false;

    private ChunkedEncodedInputStream(Builder builder) {
        this.inputStream = Validate.notNull(builder.inputStream, "Input-Stream cannot be null!", new Object[0]);
        this.chunkSize = Validate.isPositive(builder.chunkSize, "Chunk-size must be greater than 0!");
        this.header = Validate.notNull(builder.header, "Header cannot be null!", new Object[0]);
        this.extensions.addAll(Validate.notNull(builder.extensions, "Extensions cannot be null!", new Object[0]));
        this.trailers.addAll(Validate.notNull(builder.trailers, "Trailers cannot be null!", new Object[0]));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int read() throws IOException {
        return this.currentChunk().stream().read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.currentChunk().stream().read(b, off, len);
    }

    private Chunk currentChunk() throws IOException {
        if (this.currentChunk == null || !this.currentChunk.hasRemaining() && !this.isFinished) {
            this.currentChunk = this.getChunk(this.inputStream);
        }
        return this.currentChunk;
    }

    private Chunk getChunk(InputStream stream) throws IOException {
        byte[] chunkData;
        int read;
        LOG.debug(() -> "Reading next chunk.");
        if (this.currentChunk != null) {
            this.currentChunk.close();
        }
        if ((read = this.read(stream, chunkData = new byte[this.chunkSize], this.chunkSize)) > 0) {
            return this.getNextChunk(ByteBuffer.wrap(chunkData, 0, read));
        }
        LOG.debug(() -> "End of backing stream reached. Reading final chunk.");
        this.isFinished = true;
        return this.getFinalChunk();
    }

    private int read(InputStream inputStream, byte[] buf, int maxBytesToRead) throws IOException {
        int read;
        int offset = 0;
        do {
            read = inputStream.read(buf, offset, maxBytesToRead - offset);
            assert (read != 0);
            if (read <= 0) continue;
            offset += read;
        } while (read > 0 && offset < maxBytesToRead);
        return offset;
    }

    private Chunk getNextChunk(ByteBuffer data) {
        LengthAwareSequenceInputStream newChunkData = LengthAwareSequenceInputStream.builder().add(this.createChunkStream(data)).add(CRLF).build();
        return Chunk.create(newChunkData, newChunkData.size);
    }

    private Chunk getFinalChunk() throws IOException {
        LengthAwareSequenceInputStream chunkData = LengthAwareSequenceInputStream.builder().add(this.createChunkStream(ByteBuffer.wrap(END))).add(this.createTrailerStream()).add(CRLF).build();
        return Chunk.create(chunkData, chunkData.size);
    }

    private LengthAwareSequenceInputStream createChunkStream(ByteBuffer chunkData) {
        return LengthAwareSequenceInputStream.builder().add(this.createHeaderStream(chunkData.asReadOnlyBuffer())).add(this.createExtensionsStream(chunkData.asReadOnlyBuffer())).add(CRLF).add(new ByteArrayInputStream(chunkData.array(), chunkData.arrayOffset(), chunkData.remaining())).build();
    }

    private ByteArrayInputStream createHeaderStream(ByteBuffer chunkData) {
        return new ByteArrayInputStream(this.header.get(chunkData));
    }

    private LengthAwareSequenceInputStream createExtensionsStream(ByteBuffer chunkData) {
        LengthAwareSequenceInputStream.Builder result = LengthAwareSequenceInputStream.builder();
        for (ChunkExtensionProvider chunkExtensionProvider : this.extensions) {
            Pair<byte[], byte[]> ext = chunkExtensionProvider.get(chunkData);
            result.add(SEMICOLON);
            result.add(ext.left());
            result.add(EQUALS);
            result.add(ext.right());
        }
        return result.build();
    }

    private LengthAwareSequenceInputStream createTrailerStream() throws IOException {
        LengthAwareSequenceInputStream.Builder result = LengthAwareSequenceInputStream.builder();
        for (TrailerProvider trailer : this.trailers) {
            Pair<String, List<String>> tlr = trailer.get();
            result.add(tlr.left().getBytes(StandardCharsets.UTF_8));
            result.add(COLON);
            for (String trailerValue : tlr.right()) {
                result.add(trailerValue.getBytes(StandardCharsets.UTF_8));
                result.add(COMMA);
            }
            result.replaceLast(new ByteArrayInputStream(CRLF), COMMA.length);
        }
        return result.build();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.trailers.forEach(Resettable::reset);
        this.extensions.forEach(Resettable::reset);
        this.header.reset();
        this.inputStream.reset();
        this.isFinished = false;
        this.currentChunk = null;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private static class LengthAwareSequenceInputStream
    extends SequenceInputStream {
        private final int size;

        private LengthAwareSequenceInputStream(Builder builder) {
            super(Collections.enumeration(builder.streams));
            this.size = builder.size;
        }

        private static Builder builder() {
            return new Builder();
        }

        private static class Builder {
            private final List<InputStream> streams = new ArrayList<InputStream>();
            private int size = 0;

            private Builder() {
            }

            public Builder add(ByteArrayInputStream stream) {
                this.streams.add(stream);
                this.size += stream.available();
                return this;
            }

            public Builder add(byte[] stream) {
                return this.add(new ByteArrayInputStream(stream));
            }

            public Builder add(LengthAwareSequenceInputStream stream) {
                this.streams.add(stream);
                this.size += stream.size;
                return this;
            }

            public Builder replaceLast(ByteArrayInputStream stream, int lastLength) {
                this.streams.set(this.streams.size() - 1, stream);
                this.size -= lastLength;
                this.size += stream.available();
                return this;
            }

            public LengthAwareSequenceInputStream build() {
                return new LengthAwareSequenceInputStream(this);
            }
        }
    }

    public static class Builder {
        private final List<ChunkExtensionProvider> extensions = new ArrayList<ChunkExtensionProvider>();
        private final List<TrailerProvider> trailers = new ArrayList<TrailerProvider>();
        private InputStream inputStream;
        private int chunkSize;
        private ChunkHeaderProvider header = chunk -> Integer.toHexString(chunk.remaining()).getBytes(StandardCharsets.UTF_8);

        public InputStream inputStream() {
            return this.inputStream;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder header(ChunkHeaderProvider header) {
            this.header = header;
            return this;
        }

        public Builder extensions(List<ChunkExtensionProvider> extensions) {
            this.extensions.clear();
            extensions.forEach(this::addExtension);
            return this;
        }

        public Builder addExtension(ChunkExtensionProvider extension) {
            this.extensions.add(Validate.notNull(extension, "ExtensionProvider cannot be null!", new Object[0]));
            return this;
        }

        public List<TrailerProvider> trailers() {
            return new ArrayList<TrailerProvider>(this.trailers);
        }

        public Builder trailers(List<TrailerProvider> trailers) {
            this.trailers.clear();
            trailers.forEach(this::addTrailer);
            return this;
        }

        public Builder addTrailer(TrailerProvider trailer) {
            this.trailers.add(Validate.notNull(trailer, "TrailerProvider cannot be null!", new Object[0]));
            return this;
        }

        public ChunkedEncodedInputStream build() {
            return new ChunkedEncodedInputStream(this);
        }
    }
}

