/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class ComputeOptimizerServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "compute-optimizer";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-east-1"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-northeast-3"), Region.of("ap-south-1"), Region.of("ap-south-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ap-southeast-3"), Region.of("ap-southeast-4"), Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-central-2"), Region.of("eu-north-1"), Region.of("eu-south-1"), Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("il-central-1"), Region.of("me-central-1"), Region.of("me-south-1"), Region.of("sa-east-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1"), Region.of("eu-isoe-west-1"), Region.of("us-isof-east-1"), Region.of("us-isof-south-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso-e", null), new DefaultServicePartitionMetadata("aws-iso-f", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put(ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), "af-south-1").put(ServiceEndpointKey.builder().region(Region.of("ap-east-1")).build(), "ap-east-1").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), "ap-northeast-1").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), "ap-northeast-2").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(), "ap-northeast-3").put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), "ap-south-1").put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), "ap-south-2").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), "ap-southeast-1").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), "ap-southeast-2").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).build(), "ap-southeast-3").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(), "ap-southeast-4").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), "ca-central-1").put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), "eu-central-1").put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), "eu-central-2").put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), "eu-north-1").put(ServiceEndpointKey.builder().region(Region.of("eu-south-1")).build(), "eu-south-1").put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), "eu-south-2").put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), "eu-west-1").put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), "eu-west-2").put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), "eu-west-3").put(ServiceEndpointKey.builder().region(Region.of("il-central-1")).build(), "il-central-1").put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), "me-central-1").put(ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), "me-south-1").put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), "sa-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), "us-east-2").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), "us-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), "us-west-2").put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), "cn-north-1").put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), "cn-northwest-1").put(ServiceEndpointKey.builder().region(Region.of("eu-isoe-west-1")).build(), "eu-isoe-west-1").put(ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), "us-isof-south-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), "us-gov-east-1").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), "us-gov-west-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().allowDuplicateKeys(true).put(ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), "compute-optimizer.af-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-east-1")).build(), "compute-optimizer.ap-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), "compute-optimizer.ap-northeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), "compute-optimizer.ap-northeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(), "compute-optimizer.ap-northeast-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), "compute-optimizer.ap-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), "compute-optimizer.ap-south-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), "compute-optimizer.ap-southeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), "compute-optimizer.ap-southeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).build(), "compute-optimizer.ap-southeast-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(), "compute-optimizer.ap-southeast-4.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), "compute-optimizer.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), "compute-optimizer.eu-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), "compute-optimizer.eu-central-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), "compute-optimizer.eu-north-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-south-1")).build(), "compute-optimizer.eu-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), "compute-optimizer.eu-south-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), "compute-optimizer.eu-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), "compute-optimizer.eu-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), "compute-optimizer.eu-west-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("il-central-1")).build(), "compute-optimizer.il-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), "compute-optimizer.me-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), "compute-optimizer.me-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), "compute-optimizer.sa-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), "compute-optimizer.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), "compute-optimizer.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), "compute-optimizer.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), "compute-optimizer.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), "compute-optimizer.cn-north-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), "compute-optimizer.cn-northwest-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("eu-isoe-west-1")).build(), "compute-optimizer.eu-isoe-west-1.cloud.adc-e.uk").put(ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), "compute-optimizer.us-isof-south-1.csp.hci.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), "compute-optimizer-fips.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), "compute-optimizer-fips.us-gov-west-1.amazonaws.com").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

