/*
 * Decompiled with CFR 0.152.
 */
package gridscale.slurm;

import gridscale.cluster.BatchScheduler;
import gridscale.cluster.BatchScheduler$;
import gridscale.cluster.Requirement$;
import gridscale.package;
import gridscale.slurm.SLURMJobDescription;
import gridscale.tools.package$package$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class impl$
implements Serializable {
    public static final impl$ MODULE$ = new impl$();

    private impl$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(impl$.class);
    }

    public String toScript(SLURMJobDescription description, String uniqId) {
        SeqOps seqOps;
        String header = "#!/bin/bash\n";
        Object[] objectArray = new Tuple2[13];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"-o ");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Some$.MODULE$.apply((Object)BatchScheduler$.MODULE$.output(uniqId)));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"-e ");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Some$.MODULE$.apply((Object)BatchScheduler$.MODULE$.error(uniqId)));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"-p ");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, description.partition());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"--mem=");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)description.memory().map((Function1 & Serializable)m -> package$package$.MODULE$.InformationDecorator(m).toMBString() + "M"));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"--nodes=");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)description.nodes().map((Function1 & Serializable)_$1 -> impl$.$anonfun$2(BoxesRunTime.unboxToInt((Object)_$1))));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"--ntasks=");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)description.ntasks().map((Function1 & Serializable)_$2 -> impl$.$anonfun$3(BoxesRunTime.unboxToInt((Object)_$2))));
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"--cpus-per-task=");
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)description.cpuPerTask().map((Function1 & Serializable)_$3 -> impl$.$anonfun$4(BoxesRunTime.unboxToInt((Object)_$3))));
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"--time=");
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)description.time().map((Function1 & Serializable)_$4 -> package$package$.MODULE$.TimeDecorator(_$4).toHHmmss()));
        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"--qos=");
        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, description.qos());
        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"-D ");
        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)Some$.MODULE$.apply((Object)description.workDirectory()));
        String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)"--reservation=");
        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, description.reservation());
        String string12 = (String)Predef$.MODULE$.ArrowAssoc((Object)"--wckey");
        objectArray[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string12, description.wckey());
        String string13 = (String)Predef$.MODULE$.ArrowAssoc((Object)"--exclusive=");
        objectArray[12] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string13, description.exclusive());
        Seq core = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        String gresList = description.gres().isEmpty() ? "" : description.gres().mkString("#SBATCH --gres=", "--gres=", "");
        List<String> list = description.constraints();
        String constraintsList = list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq(list), 0) == 0 ? "" : description.constraints().mkString("#SBATCH --constraint=\"", "&", "\"");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(header + "\n       |" + Requirement$.MODULE$.requirementsString(Requirement$.MODULE$.pairs2Requirements(core), "#SBATCH") + "\n       |" + gresList + "\n       |" + constraintsList + "\n       |\n       |" + description.command() + "\n       |"));
    }

    public String retrieveJobID(String submissionOutput) {
        return StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(submissionOutput.trim()))), (Function1 & Serializable)_$5 -> impl$.retrieveJobID$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$5)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public package.JobState translateStatus(int retCode, String status, Option<String> reason, String command) {
        String string = status;
        if ("COMPLETED".equals(string)) {
            return package.JobState$.Done;
        }
        if ("COMPLETED?".equals(string)) {
            if (retCode == 1) {
                return package.JobState$.Done;
            }
            if (retCode != 1) {
                return package.JobState$.Failed$.MODULE$.apply("Return code of scontrol was " + retCode);
            }
        }
        switch (string == null ? 0 : string.hashCode()) {
            case -2104233469: {
                if ("CONFIGURING".equals(string)) return package.JobState$.Submitted;
                throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
            }
            case -2026200673: {
                if ("RUNNING".equals(string)) return package.JobState$.Running;
                throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
            }
            case -1031784143: {
                if (!"CANCELLED".equals(string)) throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
                return package.JobState$.Failed$.MODULE$.apply("Job was canceled");
            }
            case -1013427397: {
                if (!"NODE_FAIL".equals(string)) throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
                return package.JobState$.Failed$.MODULE$.apply("The node running the job has failed");
            }
            case -595928767: {
                if (!"TIMEOUT".equals(string)) throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
                return package.JobState$.Failed$.MODULE$.apply("Job exceeded its allocated time");
            }
            case -56111178: {
                if ("COMPLETING".equals(string)) return package.JobState$.Running;
                throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
            }
            case 35394935: {
                String r;
                if (!"PENDING".equals(string)) throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
                Set failedReasons = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"launch_failed_requeued_held"}));
                Option<String> option = reason;
                if (!(option instanceof Some) || !failedReasons.contains((Object)(r = (String)((Some)option).value()))) return package.JobState$.Submitted;
                return package.JobState$.Failed$.MODULE$.apply("Launch failed: " + r + ".");
            }
            case 1124965819: {
                if ("SUSPENDED".equals(string)) return package.JobState$.Submitted;
                throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
            }
            case 1471291022: {
                if (!"PREEMPTED".equals(string)) throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
                return package.JobState$.Failed$.MODULE$.apply("Job was preempted");
            }
            case 2066319421: {
                if (!"FAILED".equals(string)) throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
                return package.JobState$.Failed$.MODULE$.apply("Job has failed");
            }
        }
        throw new RuntimeException("Unrecognized state " + status + " returned by " + command);
    }

    public package.JobState parseState(package.ExecutionResult cmdRet, String command) {
        String jobStateAttribute = "JobState";
        String reasonAttribute = "Reason";
        Object object = Predef$.MODULE$.refArrayOps((Object[])cmdRet.stdOut().split("\n"));
        Object[] lines = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$6 -> _$6.trim(), ClassTag$.MODULE$.apply(String.class));
        Object object2 = Predef$.MODULE$.refArrayOps(lines);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$7 -> _$7.matches(".*" + jobStateAttribute + "=.*")));
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)prop -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])prop.trim().split(" "));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$8 -> _$8.split("="), ClassTag$.MODULE$.apply(String.class).wrap()));
            Map parts = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)a -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)a[0]);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)a[1]);
            }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return Tuple2$.MODULE$.apply(parts.apply((Object)jobStateAttribute), (Object)parts.get((Object)reasonAttribute));
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple2 = (Tuple2)ArrayOps$.MODULE$.headOption$extension(object4).getOrElse(impl$::$anonfun$11);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String state = (String)tuple2._1();
        Option reason = (Option)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)state, (Object)reason);
        String state2 = (String)tuple22._1();
        Option reason2 = (Option)tuple22._2();
        return this.translateStatus(cmdRet.returnCode(), state2, (Option<String>)reason2, command);
    }

    public void processCancel(package.ExecutionResult cancelRet, BatchScheduler.BatchJob job) {
        package.ExecutionResult executionResult = cancelRet;
        if (executionResult != null) {
            String error;
            package.ExecutionResult executionResult2 = package.ExecutionResult$.MODULE$.unapply(executionResult);
            int n = executionResult2._1();
            String string = executionResult2._2();
            String string2 = executionResult2._3();
            if (0 == n) {
                return;
            }
            if (1 == n && (error = string2).matches(".*Invalid job id specified")) {
                throw new RuntimeException("Slurm JobService: " + job.jobId() + " is an invalid job id");
            }
        }
        throw new RuntimeException("Slurm JobService could not cancel job " + job.jobId());
    }

    private static final /* synthetic */ String $anonfun$2(int _$1) {
        return BoxesRunTime.boxToInteger((int)_$1).toString();
    }

    private static final /* synthetic */ String $anonfun$3(int _$2) {
        return BoxesRunTime.boxToInteger((int)_$2).toString();
    }

    private static final /* synthetic */ String $anonfun$4(int _$3) {
        return BoxesRunTime.boxToInteger((int)_$3).toString();
    }

    private static final /* synthetic */ boolean retrieveJobID$$anonfun$1(char _$5) {
        return _$5 != ' ';
    }

    private static final Tuple2 $anonfun$11() {
        return Tuple2$.MODULE$.apply((Object)"COMPLETED?", (Object)None$.MODULE$);
    }
}

