/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.Blake3;
import org.openmole.tool.hash.Hash;
import org.openmole.tool.hash.HashType;
import org.openmole.tool.hash.HashType$;
import org.openmole.tool.stream.StringInputStream;
import org.openmole.tool.stream.package$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Hash$
implements Mirror.Product,
Serializable {
    private static final byte[] HEX_CHAR_TABLE;
    private static final Ordering<Hash> ordering;
    public static final Hash$ MODULE$;

    private Hash$() {
    }

    static {
        MODULE$ = new Hash$();
        HEX_CHAR_TABLE = (byte[])((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'}))).map((Function1 & Serializable)_$1 -> this.$init$$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1))).toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
        ordering = scala.package$.MODULE$.Ordering().by((Function1 & Serializable)_$3 -> _$3.toString(), (Ordering)Ordering.String$.MODULE$);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Hash$.class);
    }

    public Hash apply(byte[] content) {
        return new Hash(content);
    }

    public Hash unapply(Hash x$1) {
        return x$1;
    }

    public byte[] HEX_CHAR_TABLE() {
        return HEX_CHAR_TABLE;
    }

    public String hexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        IntRef index = IntRef.create((int)0);
        Object object = Predef$.MODULE$.byteArrayOps(raw);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)v1 -> {
            Hash$.hexString$$anonfun$1(hex, index, BoxesRunTime.unboxToByte((Object)v1));
            return BoxedUnit.UNIT;
        });
        return new String(hex, "ASCII");
    }

    public Hash string(String s, HashType hashType) {
        return this.computeHash((InputStream)new StringInputStream(s), hashType);
    }

    public HashType string$default$2() {
        return HashType$.Blake3;
    }

    public Hash file(File file, HashType hashType) {
        Hash hash;
        try (FileInputStream is = new FileInputStream(file);){
            hash = this.computeHash(is, hashType);
        }
        return hash;
    }

    public HashType file$default$2() {
        return HashType$.Blake3;
    }

    public Hash computeHash(InputStream is, HashType hashType) {
        byte[] buffer = new byte[package$.MODULE$.DefaultBufferSize()];
        HashType hashType2 = hashType;
        HashType hashType3 = HashType$.SHA1;
        HashType hashType4 = hashType2;
        if (!(hashType3 != null ? !hashType3.equals(hashType4) : hashType4 != null)) {
            return this.digestAll$1(buffer, is, MessageDigest.getInstance("SHA-1"));
        }
        HashType hashType5 = HashType$.SHA256;
        HashType hashType6 = hashType2;
        if (!(hashType5 != null ? !hashType5.equals(hashType6) : hashType6 != null)) {
            return this.digestAll$1(buffer, is, MessageDigest.getInstance("SHA-256"));
        }
        HashType hashType7 = HashType$.Blake3;
        HashType hashType8 = hashType2;
        if (!(hashType7 != null ? !hashType7.equals(hashType8) : hashType8 != null)) {
            return this.blakeHash$1(buffer, is);
        }
        throw new MatchError((Object)hashType2);
    }

    public Ordering<Hash> ordering() {
        return ordering;
    }

    public Hash fromProduct(Product x$0) {
        byte[] byArray = (byte[])x$0.productElement(0);
        return new Hash(byArray);
    }

    private final /* synthetic */ byte $init$$$anonfun$1(char _$1) {
        return (byte)_$1;
    }

    private static final /* synthetic */ void hexString$$anonfun$1(byte[] hex$1, IntRef index$1, byte b) {
        int v = b & 0xFF;
        hex$1[index$1.elem] = MODULE$.HEX_CHAR_TABLE()[v >>> 4];
        ++index$1.elem;
        hex$1[index$1.elem] = MODULE$.HEX_CHAR_TABLE()[v & 0xF];
        ++index$1.elem;
    }

    private static final int digestAll$1$$anonfun$1(InputStream is$1, byte[] buffer$1) {
        return is$1.read(buffer$1);
    }

    private final Hash digestAll$1(byte[] buffer$2, InputStream is, MessageDigest digest) {
        scala.package$.MODULE$.Iterator().continually(() -> Hash$.digestAll$1$$anonfun$1(is, buffer$2)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable)_$2 -> _$2 != -1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)count -> digest.update(buffer$2, 0, count));
        return this.apply(digest.digest());
    }

    private final Hash blakeHash$1(byte[] buffer$4, InputStream is) {
        Blake3 hasher = Blake3.initHash();
        try {
            int bytesRead = 0;
            while ((bytesRead = is.read(buffer$4)) != -1) {
                hasher.update(buffer$4, 0, bytesRead);
            }
        }
        finally {
            is.close();
        }
        return this.apply(hasher.doFinalize(32));
    }
}

