/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.batch.environment;

import java.io.File;
import java.io.Serializable;
import org.openmole.core.communication.message.ExecutionMessage;
import org.openmole.core.communication.message.ExecutionMessage$;
import org.openmole.core.communication.message.FileMessage;
import org.openmole.core.communication.message.FileMessage$;
import org.openmole.core.communication.message.ReplicatedFile;
import org.openmole.core.communication.message.ReplicatedFile$;
import org.openmole.core.communication.message.RunnableTask;
import org.openmole.core.communication.storage.RemoteStorage;
import org.openmole.core.communication.storage.package;
import org.openmole.core.db.Replica;
import org.openmole.core.event.Event;
import org.openmole.core.event.EventDispatcher;
import org.openmole.core.exception.UserBadDataError;
import org.openmole.core.location.package$;
import org.openmole.core.pluginmanager.PluginManager$;
import org.openmole.core.preference.ClearPreferenceLocation;
import org.openmole.core.preference.ConfigurationString;
import org.openmole.core.preference.Preference;
import org.openmole.core.preference.PreferenceLocation$;
import org.openmole.core.workflow.execution.Environment;
import org.openmole.core.workflow.execution.ExecutionJob;
import org.openmole.core.workflow.execution.ExecutionState$;
import org.openmole.core.workflow.execution.RuntimeSetting;
import org.openmole.core.workflow.execution.RuntimeSetting$;
import org.openmole.core.workflow.job.JobGroup;
import org.openmole.core.workspace.TmpDirectory$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment$BeginDownload$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment$BeginUpload$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment$EndDownload$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment$EndUpload$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment$ExecutionJobRegistry$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment$Services$;
import org.openmole.plugin.environment.batch.environment.BatchExecutionJob;
import org.openmole.plugin.environment.batch.environment.BatchExecutionJob$;
import org.openmole.plugin.environment.batch.environment.Runtime;
import org.openmole.plugin.environment.batch.environment.Runtime$;
import org.openmole.plugin.environment.batch.environment.SerializedJob;
import org.openmole.plugin.environment.batch.environment.SerializedJob$;
import org.openmole.plugin.environment.batch.environment.UpdateInterval;
import org.openmole.plugin.environment.batch.environment.UpdateInterval$;
import org.openmole.plugin.environment.batch.refresh.JobManager$;
import org.openmole.plugin.environment.batch.refresh.Manage$;
import org.openmole.tool.cache.Lazy;
import org.openmole.tool.hash.Hash$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.IArray;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure$;
import scala.util.Random;
import scala.util.Success$;
import scala.util.Try;
import squants.Quantity;
import squants.information.Information;
import squants.information.InformationConversions$;
import squants.time.Time;
import squants.time.TimeConversions$;

public final class BatchEnvironment$
implements Serializable {
    public static final BatchEnvironment$BeginUpload$ BeginUpload;
    public static final BatchEnvironment$EndUpload$ EndUpload;
    public static final BatchEnvironment$BeginDownload$ BeginDownload;
    public static final BatchEnvironment$EndDownload$ EndDownload;
    private static final ClearPreferenceLocation<Information> MemorySizeForRuntime;
    private static final ClearPreferenceLocation<Time> SubmitRetryInterval;
    private static final ClearPreferenceLocation<Time> GetTokenInterval;
    private static final ClearPreferenceLocation<Time> MinUpdateInterval;
    private static final ClearPreferenceLocation<Time> IncrementUpdateInterval;
    private static final ClearPreferenceLocation<Time> MaxUpdateInterval;
    private static final ClearPreferenceLocation<Object> MaxUpdateErrorsInARow;
    private static final ClearPreferenceLocation<Object> downloadResultRetry;
    private static final ClearPreferenceLocation<Object> killJobRetry;
    private static final ClearPreferenceLocation<Object> cleanJobRetry;
    private static final ClearPreferenceLocation<Time> checkJobCanceledInterval;
    private static final ClearPreferenceLocation<Object> QualityHysteresis;
    private volatile Object runtimeLocation$lzy1;
    private volatile Object JVMLinuxX64Location$lzy1;
    public static final BatchEnvironment$Services$ Services;
    public static final BatchEnvironment$ExecutionJobRegistry$ ExecutionJobRegistry;
    public static final BatchEnvironment$ MODULE$;

    private BatchEnvironment$() {
    }

    static {
        MODULE$ = new BatchEnvironment$();
        MemorySizeForRuntime = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "MemorySizeForRuntime", MODULE$::$init$$$anonfun$1);
        SubmitRetryInterval = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "SubmitRetryInterval", MODULE$::$init$$$anonfun$2);
        GetTokenInterval = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "GetTokenInterval", MODULE$::$init$$$anonfun$3);
        MinUpdateInterval = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "MinUpdateInterval", MODULE$::$init$$$anonfun$4);
        IncrementUpdateInterval = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "IncrementUpdateInterval", MODULE$::$init$$$anonfun$5);
        MaxUpdateInterval = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "MaxUpdateInterval", MODULE$::$init$$$anonfun$6);
        MaxUpdateErrorsInARow = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "MaxUpdateErrorsInARow", MODULE$::$init$$$anonfun$7);
        downloadResultRetry = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "DownloadResultRetry", MODULE$::$init$$$anonfun$8);
        killJobRetry = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "KillJobRetry", MODULE$::$init$$$anonfun$9);
        cleanJobRetry = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "KillJobRetry", MODULE$::$init$$$anonfun$10);
        checkJobCanceledInterval = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "CheckJobCanceledInterval", MODULE$::$init$$$anonfun$11);
        QualityHysteresis = PreferenceLocation$.MODULE$.apply("BatchEnvironment", "QualityHysteresis", MODULE$::$init$$$anonfun$12);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BatchEnvironment$.class);
    }

    public String signalUpload(long id, Function0<String> upload, File file, BatchEnvironment environment, String storageId, EventDispatcher eventDispatcher) {
        String string;
        long size = org.openmole.tool.file.package$.MODULE$.FileDecorator(file).size();
        eventDispatcher.trigger((Object)environment, (Event)BatchEnvironment$BeginUpload$.MODULE$.apply(id, file, storageId));
        try {
            string = (String)upload.apply();
        }
        catch (Throwable e) {
            eventDispatcher.trigger((Object)environment, (Event)BatchEnvironment$EndUpload$.MODULE$.apply(id, file, storageId, (Try<String>)Failure$.MODULE$.apply(e), size));
            throw e;
        }
        String path = string;
        eventDispatcher.trigger((Object)environment, (Event)BatchEnvironment$EndUpload$.MODULE$.apply(id, file, storageId, (Try<String>)Success$.MODULE$.apply((Object)path), size));
        return path;
    }

    public <T> T signalDownload(long id, Function0<T> download, String path, BatchEnvironment environment, String storageId, File file, EventDispatcher eventDispatcher) {
        Object object;
        eventDispatcher.trigger((Object)environment, (Event)BatchEnvironment$BeginDownload$.MODULE$.apply(id, file, path, storageId));
        try {
            object = download.apply();
        }
        catch (Throwable e) {
            eventDispatcher.trigger((Object)environment, (Event)BatchEnvironment$EndDownload$.MODULE$.apply(id, file, path, storageId, (Option<Throwable>)Some$.MODULE$.apply((Object)e)));
            throw e;
        }
        Object res = object;
        eventDispatcher.trigger((Object)environment, (Event)BatchEnvironment$EndDownload$.MODULE$.apply(id, file, path, storageId, (Option<Throwable>)None$.MODULE$));
        return (T)res;
    }

    public ClearPreferenceLocation<Information> MemorySizeForRuntime() {
        return MemorySizeForRuntime;
    }

    public ClearPreferenceLocation<Time> SubmitRetryInterval() {
        return SubmitRetryInterval;
    }

    public ClearPreferenceLocation<Time> GetTokenInterval() {
        return GetTokenInterval;
    }

    public ClearPreferenceLocation<Time> MinUpdateInterval() {
        return MinUpdateInterval;
    }

    public ClearPreferenceLocation<Time> IncrementUpdateInterval() {
        return IncrementUpdateInterval;
    }

    public ClearPreferenceLocation<Time> MaxUpdateInterval() {
        return MaxUpdateInterval;
    }

    public ClearPreferenceLocation<Object> MaxUpdateErrorsInARow() {
        return MaxUpdateErrorsInARow;
    }

    public ClearPreferenceLocation<Object> downloadResultRetry() {
        return downloadResultRetry;
    }

    public ClearPreferenceLocation<Object> killJobRetry() {
        return killJobRetry;
    }

    public ClearPreferenceLocation<Object> cleanJobRetry() {
        return cleanJobRetry;
    }

    public ClearPreferenceLocation<Time> checkJobCanceledInterval() {
        return checkJobCanceledInterval;
    }

    public ClearPreferenceLocation<Object> QualityHysteresis() {
        return QualityHysteresis;
    }

    private File runtimeDirLocation() {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(package$.MODULE$.openMOLELocation()).$div("runtime");
    }

    public File runtimeLocation() {
        Object object = this.runtimeLocation$lzy1;
        if (object instanceof File) {
            return (File)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (File)this.runtimeLocation$lzyINIT1();
    }

    private Object runtimeLocation$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.runtimeLocation$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, BatchEnvironment.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    File file = null;
                    try {
                        file = org.openmole.tool.file.package$.MODULE$.FileDecorator(this.runtimeDirLocation()).$div("runtime.tar.gz");
                        object2 = file == null ? LazyVals.NullValue$.MODULE$ : file;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, BatchEnvironment.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.runtimeLocation$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, BatchEnvironment.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return file;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, BatchEnvironment.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public File JVMLinuxX64Location() {
        Object object = this.JVMLinuxX64Location$lzy1;
        if (object instanceof File) {
            return (File)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (File)this.JVMLinuxX64Location$lzyINIT1();
    }

    private Object JVMLinuxX64Location$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.JVMLinuxX64Location$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, BatchEnvironment.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    File file = null;
                    try {
                        file = org.openmole.tool.file.package$.MODULE$.FileDecorator(this.runtimeDirLocation()).$div("jvm-x64.tar.gz");
                        object2 = file == null ? LazyVals.NullValue$.MODULE$ : file;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, BatchEnvironment.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.JVMLinuxX64Location$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, BatchEnvironment.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return file;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, BatchEnvironment.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Information defaultRuntimeMemory(Preference preference) {
        return (Information)preference.apply(this.MemorySizeForRuntime(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Information$.MODULE$);
    }

    public Time getTokenInterval(Preference preference, Lazy<Random> randomProvider) {
        return (Time)((Quantity)preference.apply(this.GetTokenInterval(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Time$.MODULE$)).$times(((Random)randomProvider.apply()).nextDouble());
    }

    public Information openMOLEMemoryValue(Option<Information> openMOLEMemory, Preference preference) {
        Option<Information> option = openMOLEMemory;
        if (None$.MODULE$.equals(option)) {
            return (Information)preference.apply(this.MemorySizeForRuntime(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Information$.MODULE$);
        }
        if (option instanceof Some) {
            Information m = (Information)((Some)option).value();
            return m;
        }
        throw new MatchError(option);
    }

    public Vector<File> jobFiles(BatchExecutionJob job, BatchEnvironment environment) {
        return (Vector)((IterableOps)((IterableOps)((IterableOps)IArray.package.IArray$.MODULE$.wrapRefArray((Object[])job.files()).toVector().$plus$plus((IterableOnce)IArray.package.IArray$.MODULE$.wrapRefArray((Object[])job.plugins()))).$plus$plus(environment.environmentPlugins())).$plus$plus(environment.scriptPlugins())).$plus$plus((IterableOnce)((SeqOps)new .colon.colon((Object)environment.jvmLinuxX64(), (List)new .colon.colon((Object)environment.runtime(), (List)Nil$.MODULE$))));
    }

    public ReplicatedFile toReplicatedFile(Function2<File, package.TransferOptions, String> upload, Function1<String, Object> exist, Function1<String, BoxedUnit> remove, BatchEnvironment environment, String storageId, File file, package.TransferOptions transferOptions, BatchEnvironment.Services services) {
        if (!file.exists()) {
            throw new UserBadDataError("File " + file + " is required but doesn't exist.");
        }
        boolean isDir = file.isDirectory();
        File toReplicatePath = file.getCanonicalFile();
        Tuple2 tuple2 = isDir ? Tuple2$.MODULE$.apply((Object)services.fileService().archiveForDir(file, services.newFile(), services.fileServiceCache()), (Object)transferOptions.copy(transferOptions.copy$default$1(), true, transferOptions.copy$default$3())) : Tuple2$.MODULE$.apply((Object)file, (Object)transferOptions);
        File toReplicate = (File)tuple2._1();
        package.TransferOptions options = (package.TransferOptions)tuple2._2();
        int fileMode = org.openmole.tool.file.package$.MODULE$.FileDecorator(file).mode();
        String hash = services.fileService().hash(toReplicate, services.fileService().hash$default$2(), services.newFile(), services.fileServiceCache()).toString();
        Replica replica = services.replicaCatalog().uploadAndGet(() -> this.$anonfun$1(services, upload, toReplicate, options, environment, storageId), exist, remove, toReplicatePath, hash, storageId);
        return ReplicatedFile$.MODULE$.apply(file.getPath(), file.getName(), isDir, hash, replica.path(), fileMode);
    }

    public SerializedJob serializeJob(BatchEnvironment environment, Option<RuntimeSetting> runtimeSetting, BatchExecutionJob job, RemoteStorage remoteStorage, Function2<File, package.TransferOptions, ReplicatedFile> replicate, Function2<File, package.TransferOptions, String> upload, String storageId, boolean archiveResult, BatchEnvironment.Services services) {
        return (SerializedJob)TmpDirectory$.MODULE$.withTmpFile("job", ".tar", (Function1 & Serializable)jobFile -> {
            services.serializerService().serialize((Object)this.tasks$1(job, services), jobFile, true);
            TreeSet plugins = (TreeSet)((SetOps)new TreeSet(org.openmole.tool.file.package$.MODULE$.fileOrdering()).$plus$plus((IterableOnce)IArray.package.IArray$.MODULE$.wrapRefArray((Object[])job.plugins())).$plus$plus(environment.scriptPlugins())).$minus$minus(environment.environmentPlugins()).$plus$plus((IterableOnce)IArray.package.IArray$.MODULE$.wrapRefArray((Object[])job.files()).toSet().$amp((Set)environment.environmentPlugins().toSet()));
            TreeSet files = (TreeSet)((SetOps)new TreeSet(org.openmole.tool.file.package$.MODULE$.fileOrdering()).$plus$plus((IterableOnce)IArray.package.IArray$.MODULE$.wrapRefArray((Object[])job.files()))).$minus$minus((IterableOnce)plugins);
            Runtime runtime = this.replicateTheRuntime(environment, replicate, services);
            ExecutionMessage executionMessage = this.createExecutionMessage((File)jobFile, (Iterable<File>)files, (Iterable<File>)plugins, replicate, environment, runtimeSetting, archiveResult, services);
            String inputPath = (String)services.newFile().withTmpFile("job", ".tar", (Function1 & Serializable)executionMessageFile -> {
                services.serializerService().serializeAndArchiveFiles((Object)executionMessage, executionMessageFile, true, services.newFile());
                return MODULE$.signalUpload(services.eventDispatcher().eventId(), (Function0<String>)((Function0 & Serializable)() -> BatchEnvironment$.$anonfun$2$$anonfun$1(upload, executionMessageFile)), (File)executionMessageFile, environment, storageId, services.eventDispatcher());
            }, services.newFile());
            FileMessage serializedStorage = (FileMessage)services.newFile().withTmpFile("remoteStorage", ".tar", (Function1 & Serializable)storageFile -> {
                services.serializerService().serializeAndArchiveFiles((Object)remoteStorage, storageFile, true, services.newFile());
                String hash = Hash$.MODULE$.file(storageFile, Hash$.MODULE$.file$default$2()).toString();
                String path = MODULE$.signalUpload(services.eventDispatcher().eventId(), (Function0<String>)((Function0 & Serializable)() -> BatchEnvironment$.$anonfun$4(upload, storageFile)), (File)storageFile, environment, storageId, services.eventDispatcher());
                return FileMessage$.MODULE$.apply(path, hash);
            }, services.newFile());
            return SerializedJob$.MODULE$.apply(inputPath, runtime, serializedStorage, executionMessage);
        }, services.newFile());
    }

    public boolean serializeJob$default$8() {
        return false;
    }

    public Runtime replicateTheRuntime(BatchEnvironment environment, Function2<File, package.TransferOptions, ReplicatedFile> replicate, BatchEnvironment.Services services) {
        IndexedSeq environmentPluginPath = (IndexedSeq)((SeqOps)((IndexedSeqOps)org.openmole.tool.random.package$.MODULE$.shuffled(environment.environmentPlugins(), (Random)services.randomProvider().apply()).map((Function1 & Serializable)p -> (ReplicatedFile)replicate.apply(p, (Object)package.TransferOptions$.MODULE$.apply(true, package.TransferOptions$.MODULE$.$lessinit$greater$default$2(), package.TransferOptions$.MODULE$.$lessinit$greater$default$3())))).map((Function1 & Serializable)_$1 -> FileMessage$.MODULE$.apply(_$1))).sortBy((Function1 & Serializable)_$2 -> _$2.path(), (Ordering)Ordering.String$.MODULE$);
        FileMessage runtimeFileMessage = FileMessage$.MODULE$.apply((ReplicatedFile)replicate.apply((Object)environment.runtime(), (Object)package.TransferOptions$.MODULE$.apply(true, package.TransferOptions$.MODULE$.$lessinit$greater$default$2(), package.TransferOptions$.MODULE$.$lessinit$greater$default$3())));
        FileMessage jvmLinuxX64FileMessage = FileMessage$.MODULE$.apply((ReplicatedFile)replicate.apply((Object)environment.jvmLinuxX64(), (Object)package.TransferOptions$.MODULE$.apply(true, package.TransferOptions$.MODULE$.$lessinit$greater$default$2(), package.TransferOptions$.MODULE$.$lessinit$greater$default$3())));
        return Runtime$.MODULE$.apply(runtimeFileMessage, (Seq<FileMessage>)environmentPluginPath, jvmLinuxX64FileMessage);
    }

    public ExecutionMessage createExecutionMessage(File jobFile, Iterable<File> serializationFile, Iterable<File> serializationPlugin, Function2<File, package.TransferOptions, ReplicatedFile> replicate, BatchEnvironment environment, Option<RuntimeSetting> runtimeSetting, boolean archiveResult, BatchEnvironment.Services services) {
        IndexedSeq pluginReplicas = (IndexedSeq)org.openmole.tool.random.package$.MODULE$.shuffled(serializationPlugin, (Random)services.randomProvider().apply()).map((Function1 & Serializable)_$3 -> (ReplicatedFile)replicate.apply(_$3, (Object)package.TransferOptions$.MODULE$.apply(true, package.TransferOptions$.MODULE$.$lessinit$greater$default$2(), package.TransferOptions$.MODULE$.$lessinit$greater$default$3())));
        IndexedSeq files = (IndexedSeq)org.openmole.tool.random.package$.MODULE$.shuffled(serializationFile, (Random)services.randomProvider().apply()).map((Function1 & Serializable)_$4 -> (ReplicatedFile)replicate.apply(_$4, (Object)package.TransferOptions$.MODULE$.apply(package.TransferOptions$.MODULE$.$lessinit$greater$default$1(), package.TransferOptions$.MODULE$.$lessinit$greater$default$2(), package.TransferOptions$.MODULE$.$lessinit$greater$default$3())));
        return ExecutionMessage$.MODULE$.apply((Iterable)pluginReplicas.sortBy((Function1 & Serializable)_$5 -> _$5.originalPath(), (Ordering)Ordering.String$.MODULE$), (Iterable)files.sortBy((Function1 & Serializable)_$6 -> _$6.originalPath(), (Ordering)Ordering.String$.MODULE$), jobFile, (RuntimeSetting)runtimeSetting.getOrElse(BatchEnvironment$::createExecutionMessage$$anonfun$3), archiveResult);
    }

    public boolean isClean(BatchEnvironment environment, BatchEnvironment.Services services) {
        Seq<BatchExecutionJob> environmentJobs = environment.jobs();
        return environmentJobs.forall((Function1 & Serializable)j -> MODULE$.executionSate(environment, (BatchExecutionJob)j) == ExecutionState$.MODULE$.KILLED());
    }

    public void finishedExecutionJob(BatchEnvironment environment, BatchExecutionJob job) {
        BatchEnvironment$ExecutionJobRegistry$.MODULE$.finished(environment.registry(), job, environment);
        environment.finishedJob(job);
    }

    public byte executionSate(BatchEnvironment environment, BatchExecutionJob job) {
        return job._state();
    }

    public void setExecutionSate(BatchEnvironment environment, BatchExecutionJob job, byte newState, EventDispatcher eventDispatcher) {
        BatchExecutionJob batchExecutionJob = job;
        synchronized (batchExecutionJob) {
            byte state = this.executionSate(environment, job);
            if (state != ExecutionState$.MODULE$.KILLED() && newState != state) {
                byte by = newState;
                if (ExecutionState$.MODULE$.DONE() == by && state != ExecutionState$.MODULE$.DONE()) {
                    v0 = BoxesRunTime.boxToLong((long)environment.state()._done().incrementAndGet());
                } else if (ExecutionState$.MODULE$.FAILED() == by) {
                    if (state == ExecutionState$.MODULE$.DONE()) {
                        environment.state()._done().decrementAndGet();
                    }
                    v0 = BoxesRunTime.boxToLong((long)environment.state()._failed().incrementAndGet());
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                eventDispatcher.trigger((Object)environment, (Event)Environment.JobStateChanged$.MODULE$.apply(job.id(), (ExecutionJob)job, newState, state));
                job._state_$eq(newState);
                v1 = BoxedUnit.UNIT;
            } else {
                v1 = BoxedUnit.UNIT;
            }
        }
    }

    public long submit(BatchEnvironment env, JobGroup job, BatchEnvironment.Services services) {
        long id = env.state().jobId().getAndIncrement();
        BatchExecutionJob bej = BatchExecutionJob$.MODULE$.apply(id, job, env.state().jobStore(), services.serializerService());
        BatchEnvironment$ExecutionJobRegistry$.MODULE$.register(env.registry(), bej);
        JobManager$.MODULE$.$bang(Manage$.MODULE$.apply(bej, env), services);
        return id;
    }

    public Seq<File> environmentPlugins(BatchEnvironment env) {
        return (Seq)PluginManager$.MODULE$.pluginsForClass(env.getClass()).toSeq().distinctBy((Function1 & Serializable)_$7 -> _$7.getCanonicalPath());
    }

    public Seq<File> scriptPlugins(BatchEnvironment.Services services) {
        return (Seq)this.closureBundleAndPlugins$1(services).distinctBy((Function1 & Serializable)_$8 -> _$8.getCanonicalPath());
    }

    public boolean registryIsEmpty(BatchEnvironment environment) {
        return BatchEnvironment$ExecutionJobRegistry$.MODULE$.isEmpty(environment.registry());
    }

    public void waitJobKilled(BatchEnvironment environment) {
        BatchEnvironment$ExecutionJobRegistry$.MODULE$.waitEmpty(environment.registry());
    }

    public UpdateInterval defaultUpdateInterval(Preference preference) {
        return UpdateInterval$.MODULE$.apply((Time)preference.apply(this.MinUpdateInterval(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Time$.MODULE$), (Time)preference.apply(this.MaxUpdateInterval(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Time$.MODULE$), (Time)preference.apply(this.IncrementUpdateInterval(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Time$.MODULE$));
    }

    private final Option $init$$$anonfun$1() {
        return Some$.MODULE$.apply((Object)InformationConversions$.MODULE$.InformationConversions((Object)BoxesRunTime.boxToInteger((int)1024), (Numeric)Numeric.IntIsIntegral$.MODULE$).megabytes());
    }

    private final Option $init$$$anonfun$2() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)30), (Numeric)Numeric.IntIsIntegral$.MODULE$).seconds());
    }

    private final Option $init$$$anonfun$3() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).minutes());
    }

    private final Option $init$$$anonfun$4() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)20), (Numeric)Numeric.IntIsIntegral$.MODULE$).seconds());
    }

    private final Option $init$$$anonfun$5() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)10), (Numeric)Numeric.IntIsIntegral$.MODULE$).seconds());
    }

    private final Option $init$$$anonfun$6() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)5), (Numeric)Numeric.IntIsIntegral$.MODULE$).minutes());
    }

    private final Option $init$$$anonfun$7() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3));
    }

    private final Option $init$$$anonfun$8() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3));
    }

    private final Option $init$$$anonfun$9() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3));
    }

    private final Option $init$$$anonfun$10() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3));
    }

    private final Option $init$$$anonfun$11() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)5), (Numeric)Numeric.IntIsIntegral$.MODULE$).seconds());
    }

    private final Option $init$$$anonfun$12() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100));
    }

    private static final String uploadReplica$1$$anonfun$1(Function2 upload$2, File toReplicate$2, package.TransferOptions options$2) {
        return (String)upload$2.apply((Object)toReplicate$2, (Object)options$2);
    }

    private final String uploadReplica$1(BatchEnvironment.Services services$1, Function2 upload$1, File toReplicate$1, package.TransferOptions options$1, BatchEnvironment environment$1, String storageId$5) {
        return this.signalUpload(services$1.eventDispatcher().eventId(), (Function0<String>)((Function0 & Serializable)() -> BatchEnvironment$.uploadReplica$1$$anonfun$1(upload$1, toReplicate$1, options$1)), toReplicate$1, environment$1, storageId$5, services$1.eventDispatcher());
    }

    private final String $anonfun$1(BatchEnvironment.Services services$8, Function2 upload$8, File toReplicate$3, package.TransferOptions options$3, BatchEnvironment environment$6, String storageId$9) {
        return this.uploadReplica$1(services$8, upload$8, toReplicate$3, options$3, environment$6, storageId$9);
    }

    private final RunnableTask[] tasks$1(BatchExecutionJob job$2, BatchEnvironment.Services services$3) {
        return job$2.runnableTasks(services$3.serializerService());
    }

    private static final String $anonfun$2$$anonfun$1(Function2 upload$5, File executionMessageFile$1) {
        return (String)upload$5.apply((Object)executionMessageFile$1, (Object)package.TransferOptions$.MODULE$.apply(package.TransferOptions$.MODULE$.$lessinit$greater$default$1(), true, true));
    }

    private static final String $anonfun$4(Function2 upload$7, File storageFile$1) {
        return (String)upload$7.apply((Object)storageFile$1, (Object)package.TransferOptions$.MODULE$.apply(true, true, true));
    }

    private static final RuntimeSetting createExecutionMessage$$anonfun$3() {
        return RuntimeSetting$.MODULE$.apply(RuntimeSetting$.MODULE$.apply$default$1(), RuntimeSetting$.MODULE$.apply$default$2());
    }

    private final Seq closureBundleAndPlugins$1(BatchEnvironment.Services services$6) {
        return (Seq)Option$.MODULE$.option2Iterable(services$6.compilationContext()).toSeq().flatMap((Function1 & Serializable)c -> {
            Tuple2<BatchExecutionJob.ClosuresBundle, Option<File>> tuple2 = BatchExecutionJob$.MODULE$.replClassesToPlugins(c.classDirectory(), c.classLoader(), services$6.newFile(), services$6.fileService());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            BatchExecutionJob.ClosuresBundle cb = (BatchExecutionJob.ClosuresBundle)tuple2._1();
            Option file = (Option)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)cb, (Object)file);
            BatchExecutionJob.ClosuresBundle cb2 = (BatchExecutionJob.ClosuresBundle)tuple22._1();
            Option file2 = (Option)tuple22._2();
            return (IterableOnce)cb2.plugins().$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(file2).toSeq());
        });
    }

    public static final /* synthetic */ boolean org$openmole$plugin$environment$batch$environment$BatchEnvironment$ExecutionJobRegistry$$$_$pruneJobs$1$$anonfun$1(BatchExecutionJob job$3, BatchExecutionJob j) {
        return j.id() != job$3.id();
    }
}

