/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.base.JSCompDoubles;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.ForOverride;
import com.google.javascript.rhino.Node;

public abstract class CodeConsumer {
    boolean statementNeedsEnded = false;
    boolean statementStarted = false;
    boolean sawFunction = false;
    private int templateLitDepth = 0;
    private int templateLitSubDepth = 0;

    void startSourceMapping(Node node) {
    }

    void endSourceMapping(Node node) {
    }

    boolean continueProcessing() {
        return true;
    }

    abstract char getLastChar();

    final void add(String newcode) {
        this.maybeEndStatement();
        if (newcode.isEmpty()) {
            return;
        }
        char c = newcode.charAt(0);
        if ((CodeConsumer.isWordChar(c) || c == '\\') && CodeConsumer.isWordChar(this.getLastChar())) {
            this.append(" ");
        } else if (c == '/' && this.getLastChar() == '/') {
            this.append(" ");
        } else if ((c == '\"' || c == '\'') && CodeConsumer.isWordChar(this.getLastChar())) {
            this.maybeInsertSpace();
        }
        int startOfLine = 0;
        int endOfLine = newcode.indexOf(10);
        while (endOfLine >= 0) {
            if (endOfLine > startOfLine) {
                this.append(newcode.substring(startOfLine, endOfLine));
            }
            this.startNewLine();
            startOfLine = endOfLine + 1;
            endOfLine = newcode.indexOf(10, startOfLine);
        }
        if (newcode.length() > startOfLine) {
            this.append(newcode.substring(startOfLine));
        }
    }

    @ForOverride
    abstract void append(String var1);

    void addIdentifier(String identifier) {
        this.add(identifier);
    }

    void appendBlockStart() {
        this.append("{");
    }

    void appendBlockEnd() {
        this.append("}");
    }

    void startNewLine() {
    }

    void maybeLineBreak() {
        this.maybeCutLine();
    }

    void maybeCutLine() {
    }

    void endLine() {
    }

    void notePreferredLineBreak() {
    }

    void beginBlock() {
        if (this.statementNeedsEnded) {
            this.append(";");
            this.maybeLineBreak();
        }
        this.appendBlockStart();
        this.endLine();
        this.statementNeedsEnded = false;
    }

    void endBlock() {
        this.endBlock(false);
    }

    void endBlock(boolean shouldEndLine) {
        this.appendBlockEnd();
        if (shouldEndLine) {
            this.endLine();
        }
        this.statementNeedsEnded = false;
    }

    void listSeparator() {
        this.add(",");
        this.maybeLineBreak();
    }

    void optionalListSeparator() {
    }

    void endStatement() {
        this.endStatement(false);
    }

    void endStatement(boolean needSemiColon) {
        if (needSemiColon) {
            this.append(";");
            this.maybeLineBreak();
            this.statementNeedsEnded = false;
        } else if (this.statementStarted) {
            this.statementNeedsEnded = true;
        }
    }

    void maybeEndStatement() {
        if (this.statementNeedsEnded) {
            this.append(";");
            this.maybeLineBreak();
            this.endLine();
            this.statementNeedsEnded = false;
        }
        this.statementStarted = true;
    }

    void endFunction(boolean statementContext) {
        this.sawFunction = true;
        if (statementContext) {
            this.endLine();
        }
    }

    void endClass(boolean statementContext) {
        if (statementContext) {
            this.endLine();
        }
    }

    void beginCaseBody() {
        this.append(":");
    }

    void endCaseBody() {
    }

    final void beginTemplateLit() {
        Preconditions.checkState(this.templateLitDepth == this.templateLitSubDepth);
        this.maybeEndStatement();
        this.append("`");
        ++this.templateLitDepth;
    }

    final void beginTemplateLitSub() {
        Preconditions.checkState(this.isInTemplateLiteral());
        this.append("${");
        ++this.templateLitSubDepth;
    }

    final void endTemplateLitSub() {
        Preconditions.checkState(this.templateLitSubDepth > 0);
        Preconditions.checkState(this.templateLitDepth == this.templateLitSubDepth);
        this.append("}");
        --this.templateLitSubDepth;
    }

    final void endTemplateLit() {
        Preconditions.checkState(this.templateLitDepth > 0);
        Preconditions.checkState(this.isInTemplateLiteral());
        this.append("`");
        --this.templateLitDepth;
    }

    final boolean isInTemplateLiteral() {
        return this.templateLitDepth == this.templateLitSubDepth + 1;
    }

    void appendOp(String op, boolean binOp) {
        this.append(op);
    }

    void addOp(String op, boolean binOp) {
        this.maybeEndStatement();
        char first = op.charAt(0);
        char prev = this.getLastChar();
        if ((first == '+' || first == '-') && prev == first) {
            this.append(" ");
        } else if (Character.isLetter(first) && CodeConsumer.isWordChar(prev)) {
            this.append(" ");
        } else if (prev == '-' && first == '>' || prev == '<' && first == '!') {
            this.append(" ");
        }
        this.appendOp(op, binOp);
        if (binOp) {
            this.maybeCutLine();
        }
    }

    void addNumber(double x, Node n) {
        long value;
        Preconditions.checkState(JSCompDoubles.isPositive(x), x);
        if ((double)((long)x) != x) {
            this.addConstant(String.valueOf(x).replace(".0E", "E").replaceFirst("^0\\.", "."));
            return;
        }
        long mantissa = value = (long)x;
        int exp = 0;
        if (x >= 100.0) {
            while (mantissa % 10L == 0L) {
                mantissa /= 10L;
                ++exp;
            }
        }
        if (exp > 2) {
            this.addConstant(mantissa + "E" + exp);
            return;
        }
        String decValueString = Long.toString(value);
        if (value <= 1000000000000L) {
            this.addConstant(decValueString);
            return;
        }
        String hexValueString = Long.toHexString(value);
        if (hexValueString.length() + 2 < decValueString.length()) {
            this.addConstant("0x" + hexValueString);
        } else {
            this.addConstant(decValueString);
        }
    }

    void addConstant(String newcode) {
        this.add(newcode);
    }

    static boolean isWordChar(char ch) {
        return ch == '_' || ch == '$' || Character.isLetterOrDigit(ch);
    }

    boolean shouldPreserveExtras(Node n) {
        return false;
    }

    void maybeInsertSpace() {
    }

    boolean breakAfterBlockFor(Node n, boolean statementContext) {
        return statementContext;
    }

    void endFile() {
    }
}

